/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import com.sun.jndi.ldap.LdapCtxFactory;
import com4j.typelibs.ado20.ClassFactory;
import groovy.lang.Binding;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.active_directory.AbstractActiveDirectoryAuthenticationProvider;
import hudson.plugins.active_directory.ActiveDirectoryUnixAuthenticationProvider;
import hudson.plugins.active_directory.GroupLookupStrategy;
import hudson.plugins.active_directory.Messages;
import hudson.plugins.active_directory.SocketInfo;
import hudson.plugins.active_directory.TrustAllSocketFactory;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.TokenBasedRememberMeServices2;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.spring.BeanBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.rememberme.RememberMeServices;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

public class ActiveDirectorySecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    public final String domain;
    public final String site;
    public final String bindName;
    public final Secret bindPassword;
    public final String server;
    private GroupLookupStrategy groupLookupStrategy;
    public final boolean removeIrrelevantGroups;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectorySecurityRealm.class.getName());
    public static String DOMAIN_CONTROLLERS = System.getProperty(ActiveDirectorySecurityRealm.class.getName() + ".domainControllers");
    public static boolean FORCE_LDAPS = Boolean.getBoolean(ActiveDirectorySecurityRealm.class.getName() + ".forceLdaps");

    public ActiveDirectorySecurityRealm(String domain, String site, String bindName, String bindPassword, String server) {
        this(domain, site, bindName, bindPassword, server, GroupLookupStrategy.AUTO, false);
    }

    public ActiveDirectorySecurityRealm(String domain, String site, String bindName, String bindPassword, String server, GroupLookupStrategy groupLookupStrategy) {
        this(domain, site, bindName, bindPassword, server, groupLookupStrategy, false);
    }

    @DataBoundConstructor
    public ActiveDirectorySecurityRealm(String domain, String site, String bindName, String bindPassword, String server, GroupLookupStrategy groupLookupStrategy, boolean removeIrrelevantGroups) {
        this.domain = Util.fixEmpty((String)domain);
        this.site = Util.fixEmpty((String)site);
        this.bindName = Util.fixEmpty((String)bindName);
        this.bindPassword = Secret.fromString((String)Util.fixEmpty((String)bindPassword));
        this.groupLookupStrategy = groupLookupStrategy;
        this.removeIrrelevantGroups = removeIrrelevantGroups;
        server = Util.fixEmpty((String)server);
        if (server != null && !server.contains(":")) {
            server = server + ":3268";
        }
        this.server = server;
    }

    public GroupLookupStrategy getGroupLookupStrategy() {
        if (this.groupLookupStrategy == null) {
            return GroupLookupStrategy.AUTO;
        }
        return this.groupLookupStrategy;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        BeanBuilder builder = new BeanBuilder(((Object)((Object)this)).getClass().getClassLoader());
        Binding binding = new Binding();
        binding.setVariable("realm", (Object)this);
        builder.parse(((Object)((Object)this)).getClass().getResourceAsStream("ActiveDirectory.groovy"), binding);
        WebApplicationContext context = builder.createApplicationContext();
        AbstractActiveDirectoryAuthenticationProvider adp = (AbstractActiveDirectoryAuthenticationProvider)ActiveDirectorySecurityRealm.findBean(AbstractActiveDirectoryAuthenticationProvider.class, (ApplicationContext)context);
        UserDetailsService uds = (UserDetailsService)ActiveDirectorySecurityRealm.findBean(UserDetailsService.class, (ApplicationContext)context);
        TokenBasedRememberMeServices2 rms = new TokenBasedRememberMeServices2(){

            public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
                try {
                    return super.autoLogin(request, response);
                }
                catch (Exception e) {
                    this.cancelCookie(request, response, "Failed to handle remember-me cookie: " + Functions.printThrowable((Throwable)e));
                    return null;
                }
            }
        };
        rms.setUserDetailsService(uds);
        rms.setKey(Hudson.getInstance().getSecretKey());
        rms.setParameter("remember_me");
        return new SecurityRealm.SecurityComponents((AuthenticationManager)ActiveDirectorySecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)context), uds, (RememberMeServices)rms);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAuthTest(StaplerRequest req, StaplerResponse rsp, @QueryParameter String username, @QueryParameter String password) throws IOException, ServletException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            AbstractActiveDirectoryAuthenticationProvider uds = this.getAuthenticationProvider();
            if (uds instanceof ActiveDirectoryUnixAuthenticationProvider) {
                ActiveDirectoryUnixAuthenticationProvider p = (ActiveDirectoryUnixAuthenticationProvider)uds;
                DescriptorImpl descriptor = this.getDescriptor();
                for (String domainName : this.domain.split(",")) {
                    try {
                        pw.println("Domain=" + domainName + " site=" + this.site);
                        List<SocketInfo> ldapServers = descriptor.obtainLDAPServer(domainName, this.site, this.server);
                        pw.println("List of domain controllers: " + ldapServers);
                        for (SocketInfo ldapServer : ldapServers) {
                            pw.println("Trying a domain controller at " + ldapServer);
                            try {
                                UserDetails d = p.retrieveUser(username, password, domainName, Collections.singletonList(ldapServer));
                                pw.println("Authenticated as " + d);
                            }
                            catch (org.acegisecurity.AuthenticationException e) {
                                e.printStackTrace(pw);
                            }
                        }
                    }
                    catch (NamingException e) {
                        pw.println("Failing to resolve domain controllers");
                        e.printStackTrace(pw);
                    }
                }
            } else {
                pw.println("Using Windows ADSI. No diagnostics available.");
            }
        }
        catch (Exception e) {
            e.printStackTrace(pw);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
        req.setAttribute("output", (Object)out.toString());
        req.getView((Object)this, "test.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        return this.getAuthenticationProvider().loadGroupByGroupname(groupname);
    }

    public AbstractActiveDirectoryAuthenticationProvider getAuthenticationProvider() {
        return (AbstractActiveDirectoryAuthenticationProvider)this.getSecurityComponents().userDetails;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.getAuthenticationProvider().loadUserByUsername(username);
    }

    protected UserDetails authenticate(String username, String password) throws org.acegisecurity.AuthenticationException {
        return this.getAuthenticationProvider().retrieveUser(username, new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        private static boolean WARNED = false;
        private static final List<String> CANDIDATES = Arrays.asList("_gc._tcp.", "_ldap._tcp.");

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/active-directory/help/realm.html";
        }

        public boolean canDoNativeAuth() {
            if (!Functions.isWindows()) {
                return false;
            }
            try {
                ClassFactory.createConnection().dispose();
                return true;
            }
            catch (Throwable t) {
                if (!WARNED) {
                    LOGGER.log(Level.INFO, "COM4J isn't working. Falling back to non-native authentication", t);
                    WARNED = true;
                }
                return false;
            }
        }

        public ListBoxModel doFillGroupLookupStrategyItems() {
            ListBoxModel model = new ListBoxModel();
            for (GroupLookupStrategy e : GroupLookupStrategy.values()) {
                model.add(e.getDisplayName(), e.name());
            }
            return model;
        }

        /*
         * Exception decompiling
         */
        public FormValidation doValidate(@QueryParameter(fixEmpty=true) String domain, @QueryParameter(fixEmpty=true) String site, @QueryParameter(fixEmpty=true) String bindName, @QueryParameter(fixEmpty=true) String bindPassword, @QueryParameter(fixEmpty=true) String server) throws IOException, ServletException, NamingException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public DirContext bind(String principalName, String password, List<SocketInfo> ldapServers) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("java.naming.referral", "follow");
            props.put("java.naming.ldap.attributes.binary", "tokenGroups objectSid");
            props.put("java.naming.ldap.factory.socket", TrustAllSocketFactory.class.getName());
            NamingException error = null;
            for (SocketInfo ldapServer : ldapServers) {
                try {
                    LdapContext context = this.bind(principalName, password, ldapServer, props);
                    LOGGER.fine("Bound to " + ldapServer);
                    return context;
                }
                catch (AuthenticationException e) {
                    LOGGER.log(Level.WARNING, "Failed to authenticate while binding to " + ldapServer, e);
                    throw new BadCredentialsException("Either no such user '" + principalName + "' or incorrect password", (Throwable)e);
                }
                catch (NamingException e) {
                    LOGGER.log(Level.WARNING, "Failed to bind to " + ldapServer, e);
                    error = e;
                }
            }
            throw new BadCredentialsException("Either no such user '" + principalName + "' or incorrect password", error);
        }

        private void customizeLdapProperty(Hashtable<String, String> props, String propName) {
            String prop = System.getProperty(propName, null);
            if (prop != null) {
                props.put(propName, prop);
            }
        }

        private void customizeLdapProperties(Hashtable<String, String> props) {
            this.customizeLdapProperty(props, "com.sun.jndi.ldap.connect.timeout");
            this.customizeLdapProperty(props, "com.sun.jndi.ldap.read.timeout");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LdapContext bind(String principalName, String password, SocketInfo server, Hashtable<String, String> props) throws NamingException {
            String ldapUrl = (FORCE_LDAPS ? "ldaps://" : "ldap://") + server + '/';
            String oldName = Thread.currentThread().getName();
            Thread.currentThread().setName("Connecting to " + ldapUrl + " : " + oldName);
            LOGGER.fine("Connecting to " + ldapUrl);
            try {
                props.put("java.naming.provider.url", ldapUrl);
                props.put("java.naming.ldap.version", "3");
                this.customizeLdapProperties(props);
                LdapContext context = (LdapContext)LdapCtxFactory.getLdapCtxInstance(ldapUrl, props);
                if (!FORCE_LDAPS) {
                    try {
                        StartTlsResponse rsp = (StartTlsResponse)context.extendedOperation(new StartTlsRequest());
                        rsp.negotiate((SSLSocketFactory)TrustAllSocketFactory.getDefault());
                        LOGGER.fine("Connection upgraded to TLS");
                    }
                    catch (NamingException e) {
                        LOGGER.log(Level.FINE, "Failed to start TLS. Authentication will be done via plain-text LDAP", e);
                        context.removeFromEnvironment("java.naming.ldap.factory.socket");
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, "Failed to start TLS. Authentication will be done via plain-text LDAP", e);
                        context.removeFromEnvironment("java.naming.ldap.factory.socket");
                    }
                }
                if (principalName == null || password == null || password.equals("")) {
                    context.addToEnvironment("java.naming.security.authentication", "none");
                    LOGGER.fine("Binding anonymously to " + ldapUrl);
                } else {
                    context.addToEnvironment("java.naming.security.principal", principalName);
                    context.addToEnvironment("java.naming.security.credentials", password);
                    LOGGER.fine("Binding as " + principalName + " to " + ldapUrl);
                }
                context.reconnect(null);
                LdapContext ldapContext = context;
                return ldapContext;
            }
            finally {
                Thread.currentThread().setName(oldName);
            }
        }

        public DirContext createDNSLookupContext() throws NamingException {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns:");
            return new InitialDirContext(env);
        }

        public List<SocketInfo> obtainLDAPServer(String domainName, String site, String preferredServer) throws NamingException {
            return this.obtainLDAPServer(this.createDNSLookupContext(), domainName, site, preferredServer);
        }

        public List<SocketInfo> obtainLDAPServer(DirContext ictx, String domainName, String site, String preferredServers) throws NamingException {
            ArrayList<SocketInfo> result = new ArrayList<SocketInfo>();
            if (preferredServers == null) {
                preferredServers = DOMAIN_CONTROLLERS;
            }
            if (preferredServers != null) {
                for (String token : preferredServers.split(",")) {
                    result.add(new SocketInfo(token.trim()));
                }
                return result;
            }
            String ldapServer = null;
            Attribute a = null;
            NamingException failure = null;
            for (String candidate : CANDIDATES) {
                ldapServer = candidate + (site != null ? site + "._sites." : "") + domainName;
                LOGGER.fine("Attempting to resolve " + ldapServer + " to SRV record");
                try {
                    Attributes attributes = ictx.getAttributes(ldapServer, new String[]{"SRV"});
                    a = attributes.get("SRV");
                    if (a == null) continue;
                    break;
                }
                catch (NamingException e) {
                    failure = e;
                }
                catch (NumberFormatException x) {
                    failure = (NamingException)new NamingException("JDK IPv6 bug encountered").initCause(x);
                }
            }
            if (a != null) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class PrioritizedSocketInfo
                implements Comparable<PrioritizedSocketInfo> {
                    SocketInfo socket;
                    int priority;

                    PrioritizedSocketInfo(SocketInfo socket, int priority) {
                        this.socket = socket;
                        this.priority = priority;
                    }

                    @Override
                    public int compareTo(PrioritizedSocketInfo that) {
                        return that.priority - this.priority;
                    }
                }
                ArrayList<PrioritizedSocketInfo> plist = new ArrayList<PrioritizedSocketInfo>();
                NamingEnumeration<?> ne = a.getAll();
                while (ne.hasMoreElements()) {
                    String record = ne.next().toString();
                    LOGGER.fine("SRV record found: " + record);
                    String[] fields = record.split(" ");
                    String hostName = fields[3];
                    if (hostName.endsWith(".")) {
                        hostName = hostName.substring(0, hostName.length() - 1);
                    }
                    int port = Integer.parseInt(fields[2]);
                    if (FORCE_LDAPS) {
                        if (port == 389) {
                            port = 636;
                        }
                        if (port == 3268) {
                            port = 3269;
                        }
                    }
                    int p = Integer.parseInt(fields[0]);
                    plist.add(new PrioritizedSocketInfo(new SocketInfo(hostName, port), p));
                }
                Collections.sort(plist);
                for (PrioritizedSocketInfo psi : plist) {
                    result.add(psi.socket);
                }
            }
            if (result.isEmpty()) {
                NamingException x = new NamingException("No SRV record found for " + ldapServer);
                if (failure != null) {
                    x.initCause(failure);
                }
                throw x;
            }
            LOGGER.fine(ldapServer + " resolved to " + result);
            return result;
        }
    }
}

