/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LDAPSearchBuilder {
    private final DirContext context;
    private final String baseDN;
    private final SearchControls controls = new SearchControls();

    public LDAPSearchBuilder(DirContext context, String baseDN) {
        this.context = context;
        this.baseDN = baseDN;
    }

    public LDAPSearchBuilder objectScope() {
        this.controls.setSearchScope(0);
        return this;
    }

    public LDAPSearchBuilder subTreeScope() {
        this.controls.setSearchScope(2);
        return this;
    }

    public LDAPSearchBuilder returns(String ... attributes) {
        this.controls.setReturningAttributes(attributes);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attributes searchOne(String filter, Object ... args) throws NamingException {
        NamingEnumeration<SearchResult> r = this.search(filter, args);
        try {
            if (r.hasMore()) {
                Attributes attributes = r.next().getAttributes();
                return attributes;
            }
            Attributes attributes = null;
            return attributes;
        }
        finally {
            r.close();
        }
    }

    public NamingEnumeration<SearchResult> search(String filter, Object ... args) throws NamingException {
        return this.context.search(this.baseDN, filter, args, this.controls);
    }
}

