/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.testfairy;

import com.testfairy.uploader.TestFairyException;
import com.testfairy.uploader.Uploader;
import com.testfairy.uploader.Validation;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.testfairy.RemoteRecorder;
import org.jenkinsci.plugins.testfairy.TestFairyBaseRecorder;
import org.jenkinsci.plugins.testfairy.Utils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class TestFairyIosRecorder
extends TestFairyBaseRecorder {
    @DataBoundConstructor
    public TestFairyIosRecorder(String apiKey, String appFile, String mappingFile, String testersGroups, Boolean notifyTesters, Boolean autoUpdate, String maxDuration, Boolean recordOnBackground, Boolean dataOnlyWifi, Boolean isVideoEnabled, String screenshotInterval, String videoQuality, String advancedOptions, Boolean cpu, Boolean memory, Boolean network, Boolean logs, Boolean phoneSignal, Boolean wifi, Boolean gps, Boolean battery) {
        super(apiKey, appFile, mappingFile, testersGroups, notifyTesters, autoUpdate, maxDuration, recordOnBackground, dataOnlyWifi, isVideoEnabled, screenshotInterval, videoQuality, advancedOptions, cpu, memory, logs, network, phoneSignal, wifi, gps, battery, false);
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (build.getResult() != null && build.getResult() == Result.FAILURE) {
            return false;
        }
        listener.getLogger().println("TestFairy iOS/Android Uploader... v " + Utils.getVersion(this.getClass()) + ", run on " + Util.getHostName());
        try {
            EnvVars vars = build.getEnvironment((TaskListener)listener);
            String changeLog = Utils.extractChangeLog(vars, build.getChangeSet(), listener.getLogger());
            try {
                launcher.getChannel().call((Callable)new IosRemoteRecorder(listener, this, vars, changeLog));
            }
            catch (Throwable ue) {
                throw new TestFairyException(ue.getMessage(), ue);
            }
            return true;
        }
        catch (TestFairyException e) {
            listener.error(e.getMessage() + "\n");
            e.printStackTrace(listener.getLogger());
            return false;
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckApiKey(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set an ApiKey");
            }
            if (value.length() != 40) {
                return FormValidation.warning((String)"This is invalid ApiKey");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAppFile(@QueryParameter String value) throws IOException, ServletException {
            return Validation.checkAbsolutePath(value);
        }

        public FormValidation doCheckMappingFile(@QueryParameter String value) throws IOException, ServletException {
            return Validation.checkAbsolutePath(value);
        }

        public ListBoxModel doFillMaxDurationItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("10 minutes", "10m");
            items.add("1 hour", "60m");
            items.add("5 hours", "300m");
            items.add("24 hours", "1440m");
            return items;
        }

        public ListBoxModel doFillScreenshotIntervalItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("1 second", "1");
            items.add("2 seconds", "2");
            items.add("5 seconds", "5");
            return items;
        }

        public ListBoxModel doFillVideoQualityItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("High", "high");
            items.add("Medium", "medium");
            items.add("Low", "low");
            return items;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "  TestFairy iOS/Android Uploader";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }

    class IosRemoteRecorder
    extends RemoteRecorder {
        public IosRemoteRecorder(BuildListener listener, TestFairyIosRecorder testFairyIosRecorder, EnvVars vars, String changeLog) {
            super(listener, testFairyIosRecorder, vars, changeLog);
        }

        public String call() throws Throwable {
            Utils.setJenkinsUrl(this.vars);
            Uploader.setServer(this.vars, this.listener.getLogger());
            Uploader upload = new Uploader(this.listener.getLogger(), Utils.getVersion(this.getClass()));
            String appFilePath = Utils.getFilePath(TestFairyIosRecorder.this.appFile, "*.ipa/*.apk", this.vars, true);
            String mappingFilePath = Utils.getFilePath(TestFairyIosRecorder.this.mappingFile, "symbols file", this.vars, false);
            String responseString = upload.uploadApp(appFilePath, mappingFilePath, this.changeLog, this.recorder, true);
            JSONObject response = JSONObject.fromObject((Object)responseString);
            this.listener.getLogger().println("Check the new build : " + response.getString("build_url"));
            return responseString;
        }
    }
}

