/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.testfairy;

import com.testfairy.uploader.TestFairyException;
import com.testfairy.uploader.Uploader;
import com.testfairy.uploader.Validation;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.testfairy.RemoteRecorder;
import org.jenkinsci.plugins.testfairy.TestFairyBaseRecorder;
import org.jenkinsci.plugins.testfairy.Utils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class TestFairyAndroidRecorder
extends TestFairyBaseRecorder {
    private String keystorePath;
    private final String storepass;
    private final String alias;
    private final String keypass;

    @DataBoundConstructor
    public TestFairyAndroidRecorder(String apiKey, String appFile, String mappingFile, String testersGroups, Boolean notifyTesters, Boolean autoUpdate, String maxDuration, Boolean recordOnBackground, Boolean dataOnlyWifi, Boolean isVideoEnabled, String screenshotInterval, String videoQuality, String advancedOptions, String keystorePath, String storepass, String alias, String keypass, Boolean cpu, Boolean memory, Boolean network, Boolean logs, Boolean phoneSignal, Boolean wifi, Boolean gps, Boolean battery, Boolean openGl) {
        super(apiKey, appFile, mappingFile, testersGroups, notifyTesters, autoUpdate, maxDuration, recordOnBackground, dataOnlyWifi, isVideoEnabled, screenshotInterval, videoQuality, advancedOptions, cpu, memory, logs, network, phoneSignal, wifi, gps, battery, openGl);
        this.keystorePath = keystorePath;
        this.storepass = storepass;
        this.alias = alias;
        this.keypass = keypass;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getStorepass() {
        return this.storepass;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getKeypass() {
        return this.keypass;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult() != null && build.getResult() == Result.FAILURE) {
            return false;
        }
        listener.getLogger().println("TestFairy Uploader (Deprecated)... v " + Utils.getVersion(this.getClass()) + ", run on " + Util.getHostName());
        try {
            EnvVars vars = build.getEnvironment((TaskListener)listener);
            String changeLog = Utils.extractChangeLog(vars, build.getChangeSet(), listener.getLogger());
            AndroidBuildEnvironment environment = this.getDescriptor().getEnvironment(launcher);
            try {
                launcher.getChannel().call((Callable)new AndroidRemoteRecorder(listener, this, vars, environment, changeLog));
            }
            catch (Throwable ue) {
                throw new TestFairyException(ue.getMessage(), ue);
            }
            return true;
        }
        catch (TestFairyException e) {
            listener.error(e.getMessage() + "\n");
            e.printStackTrace(listener.getLogger());
            return false;
        }
    }

    private void checkKeystoreParams(EnvVars vars) throws TestFairyException {
        this.keystorePath = Utils.getFilePath(this.keystorePath, "keystore file", vars, true);
        if (this.getKeystorePath() == null || this.getKeystorePath().isEmpty()) {
            throw new TestFairyException("Missing Keystore file");
        }
        if (this.getStorepass() == null || this.getStorepass().isEmpty()) {
            throw new TestFairyException("Missing Storepass");
        }
        if (this.getAlias() == null || this.getAlias().isEmpty()) {
            throw new TestFairyException("Missing Alias");
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static class AndroidBuildEnvironment
    implements Serializable {
        public String zipPath;
        public String jarsignerPath;
        public String zipalignPath;

        public AndroidBuildEnvironment(String jarsignerPath, String zipalignPath) {
            this.jarsignerPath = jarsignerPath;
            this.zipalignPath = zipalignPath;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher>
    implements Serializable {
        private String jarsignerPath;
        private String zipalignPath;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckApiKey(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set an ApiKey");
            }
            if (value.length() != 40) {
                return FormValidation.warning((String)"This is invalid ApiKey");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAppFile(@QueryParameter String value) throws IOException, ServletException {
            return Validation.checkAbsolutePath(value);
        }

        public FormValidation doCheckMappingFile(@QueryParameter String value) throws IOException, ServletException {
            return Validation.checkAbsolutePath(value);
        }

        public FormValidation doCheckZipPath(@QueryParameter String value) throws IOException, ServletException {
            return Validation.checkProgram(value);
        }

        public FormValidation doCheckJarsignerPath(@QueryParameter String value) throws IOException, ServletException {
            return Validation.checkProgram(value);
        }

        public FormValidation doCheckZipalignPath(@QueryParameter String value) throws IOException, ServletException {
            return Validation.checkProgram(value);
        }

        public ListBoxModel doFillMaxDurationItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("10 minutes", "10m");
            items.add("1 hour", "60m");
            items.add("5 hours", "300m");
            items.add("24 hours", "1440m");
            return items;
        }

        public ListBoxModel doFillScreenshotIntervalItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("1 second", "1");
            items.add("2 seconds", "2");
            items.add("5 seconds", "5");
            return items;
        }

        public ListBoxModel doFillVideoQualityItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("High", "high");
            items.add("Medium", "medium");
            items.add("Low", "low");
            return items;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return " TestFairy Uploader (Deprecated)";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.jarsignerPath = formData.getString("jarsignerPath");
            this.zipalignPath = formData.getString("zipalignPath");
            this.save();
            return super.configure(req, formData);
        }

        public String getJarsignerPath() {
            return this.jarsignerPath;
        }

        public String getZipalignPath() {
            return this.zipalignPath;
        }

        public AndroidBuildEnvironment getEnvironment(Launcher launcher) throws TestFairyException {
            if (this.jarsignerPath == null) {
                this.jarsignerPath = "jarsigner";
            }
            if (this.zipalignPath == null) {
                this.zipalignPath = "zipalign";
            }
            try {
                launcher.getChannel().call((Callable)new RemoteRecorder(){

                    public String call() throws Throwable {
                        Validation.isValidProgram(DescriptorImpl.this.jarsignerPath, "jarsigner");
                        Validation.isValidProgram(DescriptorImpl.this.zipalignPath, "zipalign");
                        return null;
                    }
                });
            }
            catch (Throwable ue) {
                throw new TestFairyException(ue.getMessage(), ue);
            }
            return new AndroidBuildEnvironment(this.jarsignerPath, this.zipalignPath);
        }
    }

    class AndroidRemoteRecorder
    extends RemoteRecorder {
        private final AndroidBuildEnvironment environment;

        public AndroidRemoteRecorder(BuildListener listener, TestFairyAndroidRecorder androidRecorder, EnvVars vars, AndroidBuildEnvironment environment, String changeLog) {
            super(listener, androidRecorder, vars, changeLog);
            this.environment = environment;
        }

        public String call() throws Throwable {
            Uploader uploader = new Uploader(this.listener.getLogger(), Utils.getVersion(this.getClass()));
            Utils.setJenkinsUrl(this.vars);
            Uploader.setServer(this.vars, this.listener.getLogger());
            String appFilePath = Utils.getApkFilePath(TestFairyAndroidRecorder.this.appFile, this.environment, this.vars);
            String mappingFilePath = Utils.getFilePath(TestFairyAndroidRecorder.this.mappingFile, "symbols file", this.vars, false);
            TestFairyAndroidRecorder.this.checkKeystoreParams(this.vars);
            String responseString = uploader.uploadApp(appFilePath, mappingFilePath, this.changeLog, this.recorder, false);
            JSONObject response = JSONObject.fromObject((Object)responseString);
            String instrumentedUrl = response.getString("instrumented_url");
            instrumentedUrl = instrumentedUrl + instrumentedUrl + "?api_key=" + TestFairyAndroidRecorder.this.apiKey;
            String instrumentedAppPath = Utils.downloadFromUrl(instrumentedUrl, this.listener.getLogger());
            String signedFilePath = uploader.signingApk(this.environment, instrumentedAppPath, (TestFairyAndroidRecorder)this.recorder);
            String responseSigned = uploader.uploadSignedApk(signedFilePath, mappingFilePath, this.recorder);
            return responseSigned;
        }
    }
}

