/*
 * Decompiled with CFR 0.152.
 */
package com.testfairy.uploader.command;

import com.testfairy.uploader.TestFairyException;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import org.jenkinsci.plugins.testfairy.TestFairyAndroidRecorder;

public class JarSignerCommand
extends ArrayList<String> {
    public JarSignerCommand(String jarsignerPath, TestFairyAndroidRecorder recorder, String apkFilename) throws TestFairyException {
        try {
            if (JarSignerCommand.isJks(new File(recorder.getKeystorePath()))) {
                this.add(jarsignerPath);
                this.add("-keystore");
                this.add(recorder.getKeystorePath());
                this.add("-storepass");
                this.add(recorder.getStorepass());
                if (recorder.getKeypass() != null && !recorder.getKeypass().isEmpty()) {
                    this.add("-keypass");
                    this.add(recorder.getKeypass());
                }
                this.add("-digestalg");
                this.add("SHA1");
                this.add("-sigalg");
                this.add("MD5withRSA");
                this.add(apkFilename);
                this.add(recorder.getAlias());
            } else {
                this.add(jarsignerPath);
                this.add("-storetype");
                this.add("pkcs12");
                this.add("-storepass");
                this.add(recorder.getStorepass());
                this.add("-keystore");
                this.add(recorder.getKeystorePath());
                this.add(apkFilename);
                this.add(recorder.getAlias());
            }
        }
        catch (Exception e) {
            throw new TestFairyException("jarsignerPath: " + jarsignerPath + ", keystorePath:" + recorder.getKeystorePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJks(File f) throws Exception {
        KeyStore ks = null;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(f);
            ks = KeyStore.getInstance("jks");
            ks.load(fis, null);
            boolean bl = true;
            return bl;
        }
    }
}

