/*
 * Decompiled with CFR 0.152.
 */
package com.testfairy.uploader;

import com.testfairy.uploader.TestFairyException;
import com.testfairy.uploader.Uploader;
import hudson.util.FormValidation;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Validation
implements Serializable {
    public static FormValidation checkApk(String jarsignerPath, String apkPath) {
        if (apkPath.length() == 0) {
            return FormValidation.error((String)"Please set a Path");
        }
        if (!Validation.isValidAPK(jarsignerPath, apkPath)) {
            return FormValidation.warning((String)(apkPath + " is invalid. Please make sure that this file exists."));
        }
        return FormValidation.ok();
    }

    public static boolean isValidAPK(String jarsignerPath, String apkPath) {
        ArrayList<String> toVerify = new ArrayList<String>();
        toVerify.add(jarsignerPath);
        toVerify.add("-verify");
        toVerify.add(apkPath);
        String out = Validation.exec(toVerify);
        return out != null && out.contains("jar verified.");
    }

    public static FormValidation checkProgram(String value) {
        if (value.length() == 0) {
            return FormValidation.error((String)"Please set a Path");
        }
        if (!Validation.isValidProgram(value).booleanValue()) {
            return FormValidation.warning((String)(value + " is invalid. Please make sure that this file exists."));
        }
        return FormValidation.ok();
    }

    public static FormValidation checkAbsolutePath(String value) {
        if (!(value.startsWith("/") || value.startsWith("$") || value.startsWith("C:\\") || value.startsWith("\\"))) {
            return FormValidation.warning((String)"Please make sure you are using absolute path");
        }
        return FormValidation.ok();
    }

    private static Boolean isValidProgram(String path) {
        if (path == null) {
            return false;
        }
        ArrayList<String> toVerify = new ArrayList<String>();
        toVerify.add(path);
        toVerify.add("-h");
        String out = Validation.exec(toVerify);
        if (out != null) {
            return true;
        }
        return false;
    }

    public static Boolean isValidProgram(String path, String name) throws TestFairyException {
        if (path == null) {
            throw new TestFairyException("Wrong " + name + " path, Please check it on " + Uploader.JENKINS_URL + "configure (" + path + ")");
        }
        ArrayList<String> toVerify = new ArrayList<String>();
        toVerify.add(path);
        toVerify.add("-h");
        String out = Validation.exec(toVerify);
        if (out != null) {
            return true;
        }
        throw new TestFairyException("Wrong " + name + " path, Please check it on " + Uploader.JENKINS_URL + "configure (" + path + ")");
    }

    private static String exec(List<String> command) {
        String outputStringToReturn = "";
        try {
            String outputString;
            ProcessBuilder pb = new ProcessBuilder(command);
            Process process = pb.start();
            DataInputStream inputStream = new DataInputStream(process.getInputStream());
            while ((outputString = inputStream.readLine()) != null) {
                outputStringToReturn = outputStringToReturn + outputString;
            }
        }
        catch (IOException e1) {
            outputStringToReturn = null;
        }
        return outputStringToReturn;
    }
}

