/*
 * Decompiled with CFR 0.152.
 */
package com.testfairy.apk;

import com.testfairy.apk.ApkArchiveEntry;
import com.testfairy.apk.ApkArchiveVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;

public class ApkArchiveWriter
extends ApkArchiveVisitor {
    private OutputStream outputStream;
    private ZipArchiveOutputStream zaos;
    private Set<String> includedFiles = new HashSet<String>();

    public ApkArchiveWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.zaos = new ZipArchiveOutputStream(outputStream);
    }

    public ApkArchiveWriter(ApkArchiveVisitor av) {
        super(av);
    }

    public void writeTo(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.zaos = new ZipArchiveOutputStream(outputStream);
    }

    @Override
    public void visit() {
        super.visit();
    }

    @Override
    public void visitEntry(ApkArchiveEntry entry) throws IOException {
        super.visitEntry(entry);
        if (this.includedFiles.contains(entry.getFilename())) {
            return;
        }
        ZipArchiveEntry zipEntry = new ZipArchiveEntry(entry.getFilename());
        this.includedFiles.add(entry.getFilename());
        if (entry.getMethod() == 0) {
            zipEntry.setSize(entry.getSize());
            zipEntry.setCrc(entry.getCrc());
        }
        this.zaos.setMethod(entry.getMethod());
        this.zaos.putArchiveEntry((ArchiveEntry)zipEntry);
        IOUtils.copy((InputStream)entry.getInputStream(), (OutputStream)this.zaos);
        this.zaos.closeArchiveEntry();
    }

    @Override
    public void visitEnd() throws IOException {
        super.visitEnd();
        this.zaos.close();
        this.includedFiles.clear();
    }
}

