/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete;

import com.smartbear.jenkins.plugins.testcomplete.Messages;
import hudson.FilePath;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;

public class Workspace {
    private final FilePath slaveWorkspacePath;
    private final String logId;
    private final FilePath slaveLogXFilePath;
    private final FilePath slaveHtmlXFilePath;
    private final FilePath masterLogXFilePath;
    private final FilePath masterHtmlXFilePath;
    private final FilePath slaveErrorFilePath;
    private final FilePath slaveExitCodeFilePath;
    private final FilePath masterLogDirectory;
    private final FilePath slaveMHTFilePath;
    private final FilePath masterMHTFilePath;

    public Workspace(Run<?, ?> run, FilePath filePath) throws IOException, InterruptedException {
        this.slaveWorkspacePath = this.getSlaveWorkspace(filePath);
        this.logId = Long.toString(System.currentTimeMillis());
        String logXName = this.logId + ".tclogx";
        String htmlXName = this.logId + ".htmlx";
        String mhtName = this.logId + ".mht";
        this.slaveLogXFilePath = new FilePath(this.slaveWorkspacePath, logXName);
        this.slaveHtmlXFilePath = new FilePath(this.slaveWorkspacePath, htmlXName);
        this.slaveMHTFilePath = new FilePath(this.slaveWorkspacePath, mhtName);
        this.masterLogDirectory = this.getMasterLogDirectory(run);
        this.masterLogXFilePath = new FilePath(this.masterLogDirectory, logXName);
        this.masterHtmlXFilePath = new FilePath(this.masterLogDirectory, htmlXName);
        this.masterMHTFilePath = new FilePath(this.masterLogDirectory, mhtName);
        this.slaveErrorFilePath = new FilePath(this.slaveWorkspacePath, this.logId + ".txt");
        this.slaveExitCodeFilePath = new FilePath(this.slaveWorkspacePath, this.logId + "_exitcode" + ".txt");
    }

    private FilePath getMasterLogDirectory(Run<?, ?> run) throws IOException, InterruptedException {
        String buildDir = run.getRootDir().getAbsolutePath();
        FilePath masterLogDirectory = new FilePath(new File(buildDir + File.separator + "tcreports"));
        masterLogDirectory.mkdirs();
        return masterLogDirectory;
    }

    private FilePath getSlaveWorkspace(FilePath filePath) throws IOException, InterruptedException {
        if (filePath == null) {
            throw new IOException(Messages.TcTestBuilder_WorkspaceNotSpecified());
        }
        filePath.mkdirs();
        return filePath.absolutize();
    }

    FilePath getSlaveWorkspacePath() {
        return this.slaveWorkspacePath;
    }

    String getLogId() {
        return this.logId;
    }

    FilePath getSlaveLogXFilePath() {
        return this.slaveLogXFilePath;
    }

    FilePath getSlaveHtmlXFilePath() {
        return this.slaveHtmlXFilePath;
    }

    FilePath getMasterLogXFilePath() {
        return this.masterLogXFilePath;
    }

    FilePath getMasterHtmlXFilePath() {
        return this.masterHtmlXFilePath;
    }

    FilePath getSlaveErrorFilePath() {
        return this.slaveErrorFilePath;
    }

    FilePath getSlaveExitCodeFilePath() {
        return this.slaveExitCodeFilePath;
    }

    FilePath getSlaveMHTFilePath() {
        return this.slaveMHTFilePath;
    }

    FilePath getMasterMHTFilePath() {
        return this.masterMHTFilePath;
    }

    FilePath getMasterLogDirectory() {
        return this.masterLogDirectory;
    }
}

