/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete;

import com.smartbear.jenkins.plugins.testcomplete.Base64;
import com.smartbear.jenkins.plugins.testcomplete.Messages;
import com.smartbear.jenkins.plugins.testcomplete.TcLog;
import hudson.PluginWrapper;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.lang.ref.WeakReference;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Semaphore;
import javax.crypto.Cipher;
import jenkins.model.Jenkins;
import org.jenkinsci.remoting.RoleChecker;

public class Utils {
    private static final String PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDCD43scUktBOFoR10dS80DbFJfMgJoyNGtfxVyQ6DKwmzb1OS+P3E5Y47K3G6fXX8OfhT0WmQ/Aqr61nUXxRgn2cFHKyc4rjFjfMTkPGkv7rWdIuu+4VR9PYEXar4OyCQEThfhdDSPzfHJ8oiPNqkXe5IYL1xQevURO0+Sapzf7wIDAQAB";
    private static final int ENC_CHUNK_MAX_SIZE = 116;

    private Utils() {
    }

    static boolean isWindows(VirtualChannel channel, TaskListener listener) {
        try {
            return (Boolean)channel.call((Callable)new Callable<Boolean, Exception>(){

                public void checkRoles(RoleChecker roleChecker) throws SecurityException {
                }

                public Boolean call() {
                    String os = System.getProperty("os.name");
                    if (os != null) {
                        os = os.toLowerCase();
                    }
                    return os != null && os.contains("windows");
                }
            });
        }
        catch (Exception e) {
            TcLog.error(listener, Messages.TcTestBuilder_RemoteCallingFailed(), e);
            return false;
        }
    }

    static boolean IsLaunchedAsSystemUser(VirtualChannel channel, TaskListener listener) {
        try {
            return (Boolean)channel.call((Callable)new Callable<Boolean, Exception>(){

                public void checkRoles(RoleChecker roleChecker) throws SecurityException {
                }

                public Boolean call() {
                    String winDir = System.getenv("WINDIR");
                    if (winDir == null) {
                        return false;
                    }
                    String userProfile = System.getenv("USERPROFILE");
                    if (userProfile == null) {
                        return false;
                    }
                    return userProfile.startsWith(winDir);
                }
            });
        }
        catch (Exception e) {
            TcLog.error(listener, Messages.TcTestBuilder_RemoteCallingFailed(), e);
            return false;
        }
    }

    static long getSystemTime(VirtualChannel channel, TaskListener listener) {
        try {
            return (Long)channel.call((Callable)new Callable<Long, Exception>(){

                public void checkRoles(RoleChecker roleChecker) throws SecurityException {
                }

                public Long call() {
                    return System.currentTimeMillis();
                }
            });
        }
        catch (Exception e) {
            TcLog.error(listener, Messages.TcTestBuilder_RemoteCallingFailed(), e);
            return 0L;
        }
    }

    static int getTimezoneOffset(VirtualChannel channel, TaskListener listener) {
        try {
            return (Integer)channel.call((Callable)new Callable<Integer, Exception>(){

                public void checkRoles(RoleChecker roleChecker) throws SecurityException {
                }

                public Integer call() {
                    Calendar now = Calendar.getInstance();
                    TimeZone timeZone = now.getTimeZone();
                    return timeZone.getRawOffset();
                }
            });
        }
        catch (Exception e) {
            TcLog.error(listener, Messages.TcTestBuilder_RemoteCallingFailed(), e);
            return 0;
        }
    }

    public static long safeConvertDate(String oleDate) {
        double dateToConvert = 0.0;
        try {
            dateToConvert = Double.parseDouble(oleDate);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Utils.OLEDateToMillis(dateToConvert);
    }

    private static long OLEDateToMillis(double dSerialDate) {
        return (long)((dSerialDate - 25569.0) * 24.0 * 3600.0 * 1000.0);
    }

    static String encryptPassword(String password) throws Exception {
        byte[] keyRawData = new Base64().decode(PUBLIC_KEY);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec ks = new X509EncodedKeySpec(keyRawData);
        RSAPublicKey publicKey = (RSAPublicKey)keyFactory.generatePublic(ks);
        byte[] encryptedData = Utils.encrypt(password, publicKey);
        return new Base64().encode(encryptedData);
    }

    private static byte[] encrypt(String data, Key publicKey) throws Exception {
        ArrayList<byte[]> resultData = new ArrayList<byte[]>();
        Cipher rsa = Cipher.getInstance("RSA");
        rsa.init(1, publicKey);
        byte[] dataRaw = data.getBytes("UTF-16LE");
        int chunksCount = dataRaw.length / 116 + (dataRaw.length % 116 > 0 ? 1 : 0);
        int remaining = dataRaw.length;
        for (int i = 0; i < chunksCount; ++i) {
            int startIndex = i * 116;
            int length = Math.min(remaining, 116);
            remaining -= length;
            resultData.add(Utils.reverseOrder(rsa.doFinal(dataRaw, startIndex, length)));
        }
        int totalLength = 0;
        for (int i = 0; i < resultData.size(); ++i) {
            totalLength += ((byte[])resultData.get(i)).length;
        }
        byte[] result = new byte[totalLength];
        int position = 0;
        for (int i = 0; i < resultData.size(); ++i) {
            byte[] current = (byte[])resultData.get(i);
            System.arraycopy(current, 0, result, position, current.length);
            position += current.length;
        }
        return result;
    }

    private static byte[] reverseOrder(byte[] data) {
        int length = data.length;
        byte[] reversedData = new byte[length];
        for (int i = 0; i < length; ++i) {
            reversedData[i] = data[length - 1 - i];
        }
        return reversedData;
    }

    public static String getPluginVersionOrNull() {
        if (Jenkins.getInstanceOrNull() == null) {
            return null;
        }
        for (PluginWrapper plugin : Jenkins.getInstanceOrNull().pluginManager.getPlugins()) {
            String name = plugin.getShortName();
            if (name == null || !name.equals("TestComplete")) continue;
            return plugin.getVersion().split("[ ]")[0];
        }
        return null;
    }

    public static class BusyNodeList {
        private Map<WeakReference<Computer>, Semaphore> computerLocks = new HashMap<WeakReference<Computer>, Semaphore>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock(Computer computer, TaskListener listener) throws InterruptedException {
            Semaphore semaphore = null;
            BusyNodeList busyNodeList = this;
            synchronized (busyNodeList) {
                for (WeakReference<Computer> computerRef : this.computerLocks.keySet()) {
                    Computer actualComputer = (Computer)computerRef.get();
                    if (actualComputer == null || actualComputer != computer) continue;
                    semaphore = this.computerLocks.get(computerRef);
                }
                if (semaphore == null) {
                    semaphore = new Semaphore(1, true);
                    this.computerLocks.put(new WeakReference<Computer>(computer), semaphore);
                } else {
                    listener.getLogger().println();
                    TcLog.info(listener, Messages.TcTestBuilder_WaitingForNodeRelease(), new Object[0]);
                }
            }
            semaphore.acquire();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(Computer computer) throws InterruptedException {
            Semaphore semaphore = null;
            BusyNodeList busyNodeList = this;
            synchronized (busyNodeList) {
                for (WeakReference<Computer> computerRef : this.computerLocks.keySet()) {
                    Computer actualComputer = (Computer)computerRef.get();
                    if (actualComputer == null || actualComputer != computer) continue;
                    semaphore = this.computerLocks.get(computerRef);
                }
            }
            if (semaphore != null) {
                semaphore.release();
            }
            Thread.sleep(200L);
            busyNodeList = this;
            synchronized (busyNodeList) {
                ArrayList<WeakReference<Computer>> toRemove = new ArrayList<WeakReference<Computer>>();
                for (WeakReference<Object> computerRef : this.computerLocks.keySet()) {
                    Computer actualComputer = (Computer)computerRef.get();
                    if (actualComputer == null || actualComputer != computer || (semaphore = this.computerLocks.get(computerRef)).availablePermits() <= 0) continue;
                    toRemove.add(computerRef);
                }
                for (WeakReference<Object> computerRef : toRemove) {
                    this.computerLocks.remove(computerRef);
                }
            }
        }
    }
}

