/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.smartbear.jenkins.plugins.testcomplete.Messages;
import com.smartbear.jenkins.plugins.testcomplete.ScreenResolution;
import com.smartbear.jenkins.plugins.testcomplete.TcInstallation;
import com.smartbear.jenkins.plugins.testcomplete.TcLog;
import com.smartbear.jenkins.plugins.testcomplete.TcLogInfo;
import com.smartbear.jenkins.plugins.testcomplete.TcReportAction;
import com.smartbear.jenkins.plugins.testcomplete.TcSummaryAction;
import com.smartbear.jenkins.plugins.testcomplete.Utils;
import com.smartbear.jenkins.plugins.testcomplete.Workspace;
import com.smartbear.jenkins.plugins.testcomplete.parser.ILogParser;
import com.smartbear.jenkins.plugins.testcomplete.parser.LogParser;
import com.smartbear.jenkins.plugins.testcomplete.parser.LogParser2;
import com.smartbear.jenkins.plugins.testcomplete.parser.ParserSettings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class TcTestBuilder
extends Builder
implements Serializable,
SimpleBuildStep {
    private static final String RUN_ARG = "/run";
    private static final String SILENT_MODE_ARG = "/SilentMode";
    private static final String NS_ARG = "/ns";
    private static final String EXIT_ARG = "/exit";
    private static final String EXPORT_LOG_ARG = "/ExportLog:";
    private static final String ERROR_LOG_ARG = "/ErrorLog:";
    private static final String TIMEOUT_ARG = "/Timeout:";
    private static final String PROJECT_ARG = "/project:";
    private static final String UNIT_ARG = "/unit:";
    private static final String ROUTINE_ARG = "/routine:";
    private static final String TEST_ARG = "/test:";
    private static final String NO_LOG_ARG = "/DoNotShowLog";
    private static final String FORCE_CONVERSION_ARG = "/ForceConversion";
    private static final String VERSION_ARG = "/JenkinsTCPluginVersion:";
    private static final String TAGS_ARG = "/tags:";
    private static final String ACCESS_KEY_ARG = "/accesskey:";
    private static final String DEBUG_FLAG_NAME = "TESTCOMPLETE_PLUGIN_DEBUG";
    private static final String KEEP_LOGS_FLAG_NAME = "TESTCOMPLETE_PLUGIN_KEEP_LOGS";
    private transient boolean DEBUG = false;
    private transient boolean KEEP_LOGS = false;
    private String suite;
    private String launchType;
    private String project;
    private String unit;
    private String routine;
    private String test;
    private String tags;
    private String executorType;
    private String executorVersion;
    private String actionOnWarnings;
    private String actionOnErrors;
    private String commandLineArguments;
    private boolean useTimeout;
    private String timeout;
    private boolean useTCService;
    private String userName;
    private Secret userPassword;
    private String credentialsId;
    private boolean useActiveSession;
    private String accessKeyId;
    private String sessionScreenResolution;
    private boolean generateMHT;
    private boolean publishJUnitReports;
    private static Utils.BusyNodeList busyNodes = new Utils.BusyNodeList();

    @DataBoundConstructor
    public TcTestBuilder(String suite) {
        this.suite = suite != null ? suite : "";
        this.launchType = TcInstallation.LaunchType.lcSuite.toString();
        this.project = "";
        this.unit = "";
        this.routine = "";
        this.test = "";
        this.tags = "";
        this.executorType = "any";
        this.executorVersion = "any";
        this.actionOnWarnings = BuildStepAction.NONE.toString();
        this.actionOnErrors = BuildStepAction.MAKE_UNSTABLE.toString();
        this.commandLineArguments = "";
        this.useTimeout = false;
        this.timeout = "";
        this.useTCService = false;
        this.sessionScreenResolution = ScreenResolution.getDefaultResolution().toString();
        this.userName = "";
        this.userPassword = Secret.fromString((String)"");
        this.useActiveSession = true;
        this.credentialsId = "";
        this.accessKeyId = "";
        this.generateMHT = false;
        this.publishJUnitReports = true;
    }

    @DataBoundSetter
    public void setLaunchConfig(LaunchConfig launchConfig) {
        this.launchType = launchConfig == null ? TcInstallation.LaunchType.lcSuite.toString() : launchConfig.launchType;
        this.project = launchConfig == null ? "" : launchConfig.project;
        this.unit = launchConfig == null ? "" : launchConfig.unit;
        this.routine = launchConfig == null ? "" : launchConfig.routine;
        this.test = launchConfig == null ? "" : launchConfig.test;
        this.tags = launchConfig == null ? "" : launchConfig.tags;
    }

    public LaunchConfig getLaunchConfig() {
        return null;
    }

    @DataBoundSetter
    public void setSuite(String suite) {
        this.suite = suite != null ? suite : "";
    }

    public String getSuite() {
        return this.suite;
    }

    @DataBoundSetter
    public void setLaunchType(String launchType) {
        this.launchType = launchType;
    }

    public String getLaunchType() {
        return this.launchType;
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    @DataBoundSetter
    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    @DataBoundSetter
    public void setRoutine(String routine) {
        this.routine = routine;
    }

    public String getRoutine() {
        return this.routine;
    }

    @DataBoundSetter
    public void setTest(String test) {
        this.test = test;
    }

    public String getTest() {
        return this.test;
    }

    @DataBoundSetter
    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getTags() {
        return this.tags;
    }

    @DataBoundSetter
    public void setExecutorType(String executorType) {
        this.executorType = executorType;
    }

    public String getExecutorType() {
        if (TcInstallation.ExecutorType.TELite.name().equals(this.executorType)) {
            return TcInstallation.ExecutorType.TE.name();
        }
        return this.executorType;
    }

    @DataBoundSetter
    public void setExecutorVersion(String executorVersion) {
        this.executorVersion = executorVersion;
    }

    public String getExecutorVersion() {
        return this.executorVersion;
    }

    @DataBoundSetter
    public void setActionOnWarnings(String actionOnWarnings) {
        this.actionOnWarnings = actionOnWarnings;
    }

    public String getActionOnWarnings() {
        return this.actionOnWarnings;
    }

    @DataBoundSetter
    public void setActionOnErrors(String actionOnErrors) {
        this.actionOnErrors = actionOnErrors;
    }

    public String getActionOnErrors() {
        return this.actionOnErrors;
    }

    @DataBoundSetter
    public void setCommandLineArguments(String commandLineArguments) {
        this.commandLineArguments = commandLineArguments;
    }

    public String getCommandLineArguments() {
        return this.commandLineArguments;
    }

    @DataBoundSetter
    public void setUseTimeout(boolean useTimeout) {
        this.useTimeout = useTimeout;
    }

    public boolean getUseTimeout() {
        return this.useTimeout;
    }

    @DataBoundSetter
    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setUseTCService(boolean useTCService) {
        this.useTCService = useTCService;
    }

    public boolean getUseTCService() {
        return this.useTCService;
    }

    @DataBoundSetter
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    @DataBoundSetter
    public void setUserPassword(String userPassword) {
        this.userPassword = Secret.fromString((String)userPassword);
    }

    public Secret getUserPassword() {
        return this.userPassword;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setUseActiveSession(boolean useActiveSession) {
        this.useActiveSession = useActiveSession;
    }

    public boolean getUseActiveSession() {
        return this.useActiveSession;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @DataBoundSetter
    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    @DataBoundSetter
    public void setSessionScreenResolution(String sessionScreenResolution) {
        this.sessionScreenResolution = sessionScreenResolution;
    }

    public String getSessionScreenResolution() {
        return this.sessionScreenResolution;
    }

    @DataBoundSetter
    public void setGenerateMHT(boolean generateMHT) {
        this.generateMHT = generateMHT;
    }

    public boolean getGenerateMHT() {
        return this.generateMHT;
    }

    @DataBoundSetter
    public void setPublishJUnitReports(boolean publishJUnitReports) {
        this.publishJUnitReports = publishJUnitReports;
    }

    public boolean getPublishJUnitReports() {
        return this.publishJUnitReports;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean usingOldCredentials() {
        return (!StringUtils.isEmpty((String)this.getUserName()) || !StringUtils.isEmpty((String)this.getUserPassword().getPlainText())) && StringUtils.isEmpty((String)this.getCredentialsId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fixExitCode(int exitCode, Workspace workspace, TaskListener listener) throws IOException, InterruptedException {
        BufferedReader br = null;
        int fixedCode = exitCode;
        try {
            if (workspace.getSlaveExitCodeFilePath().exists()) {
                br = new BufferedReader(new InputStreamReader(workspace.getSlaveExitCodeFilePath().read(), Charset.forName("UTF-8")));
                try {
                    String exiCodeString = br.readLine().trim();
                    if (this.DEBUG) {
                        TcLog.debug(listener, Messages.TcTestBuilder_Debug_ExitCodeRead(), exiCodeString);
                    }
                    fixedCode = Integer.parseInt(exiCodeString);
                }
                catch (Exception e) {
                    if (this.DEBUG) {
                        TcLog.debug(listener, Messages.TcTestBuilder_Debug_ExitCodeReadFailed(), new Object[0]);
                    }
                }
            } else if (this.DEBUG) {
                TcLog.debug(listener, Messages.TcTestBuilder_Debug_ExitCodeFileNotExists(), new Object[0]);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            workspace.getSlaveExitCodeFilePath().delete();
        }
        return fixedCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        Computer currentComputer = filePath.toComputer();
        try {
            this.performInternal(run, filePath, launcher, taskListener, currentComputer);
        }
        catch (CBTException | CredentialsNotFoundException | InvalidConfigurationException | TagsException e) {
            TcLog.error(taskListener, e.getMessage(), new Object[0]);
            run.setResult(Result.FAILURE);
        }
        finally {
            busyNodes.release(currentComputer);
        }
    }

    /*
     * Exception decompiling
     */
    public void performInternal(Run<?, ?> run, FilePath filePath, Launcher launcher, TaskListener listener, Computer currentComputer) throws IOException, InterruptedException, InvalidConfigurationException, CBTException, TagsException, CredentialsNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TestResultAction getTestResultAction(Run<?, ?> run) {
        return (TestResultAction)run.getAction(TestResultAction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishResult(Run<?, ?> run, TaskListener listener, Workspace workspace, TcReportAction tcReportAction) throws InterruptedException {
        if (tcReportAction.getLogInfo() == null || tcReportAction.getLogInfo().getXML() == null) {
            TcLog.warning(listener, Messages.TcTestBuilder_UnableToPublishTestData(), new Object[0]);
            return;
        }
        OutputStream os = null;
        String reportFileName = tcReportAction.getId() + ".xml";
        FilePath reportFile = new FilePath(workspace.getMasterLogDirectory(), reportFileName);
        if (this.DEBUG) {
            TcLog.debug(listener, Messages.TcTestBuilder_Debug_JUNIT_PathOnMaster(), reportFile.getRemote());
        }
        try {
            FilePath slaveJUnitFilePath;
            os = reportFile.write();
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                String xml = tcReportAction.getLogInfo().getXML();
                byteArrayOutputStream.write(xml.getBytes("UTF-8"));
                byteArrayOutputStream.writeTo(os);
            }
            finally {
                os.close();
            }
            if (this.DEBUG) {
                TcLog.debug(listener, Messages.TcTestBuilder_Debug_JUNIT_GeneratedSuccessfully(), new Object[0]);
            }
            if (this.KEEP_LOGS) {
                slaveJUnitFilePath = new FilePath(workspace.getSlaveWorkspacePath(), reportFileName);
                slaveJUnitFilePath.copyFrom(reportFile);
                if (this.DEBUG) {
                    TcLog.debug(listener, Messages.TcTestBuilder_Debug_JUNIT_CopiedToWorkspace(), slaveJUnitFilePath.getRemote());
                }
            }
            slaveJUnitFilePath = run;
            synchronized (slaveJUnitFilePath) {
                TestResultAction testResultAction = this.getTestResultAction((Run<?, ?>)run);
                if (testResultAction == null) {
                    TestResult testResult = new TestResult(true);
                    testResult.parse(new File(reportFile.getRemote()));
                    testResultAction = new TestResultAction((Run)run, testResult, listener);
                    if (this.DEBUG) {
                        TcLog.debug(listener, Messages.TcTestBuilder_Debug_JUNIT_ResultCreated() + ' ' + String.format(Messages.TcTestBuilder_Debug_JUNIT_ResultInfo(), testResultAction.getFailCount(), testResultAction.getSkipCount(), testResultAction.getTotalCount()), new Object[0]);
                    }
                    run.addAction((Action)testResultAction);
                } else {
                    TestResult testResult = testResultAction.getResult();
                    testResult.parse(new File(reportFile.getRemote()));
                    testResult.tally();
                    testResultAction.setResult(testResult, listener);
                    if (this.DEBUG) {
                        TcLog.debug(listener, Messages.TcTestBuilder_Debug_JUNIT_ResultAppended() + ' ' + String.format(Messages.TcTestBuilder_Debug_JUNIT_ResultInfo(), testResultAction.getFailCount(), testResultAction.getSkipCount(), testResultAction.getTotalCount()), new Object[0]);
                    }
                }
            }
        }
        catch (IOException e) {
            if (this.DEBUG) {
                TcLog.debug(listener, Messages.TcTestBuilder_ExceptionOccurred(), e.getMessage());
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            try {
                if (reportFile.exists() && !this.KEEP_LOGS) {
                    if (this.DEBUG) {
                        TcLog.debug(listener, Messages.TcTestBuilder_Debug_JUNIT_ReportDeleted(), new Object[0]);
                    }
                    reportFile.delete();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private ArgumentListBuilder prepareServiceCommandLine(Run<?, ?> run, TaskListener listener, TcInstallation chosenInstallation, ArgumentListBuilder baseArgs, EnvVars env) throws Exception {
        ScreenResolution resolution;
        String sessionScreenResolutionString;
        ArgumentListBuilder resultArgs = new ArgumentListBuilder();
        resultArgs.addQuoted(chosenInstallation.getServicePath());
        String domain = "";
        String userName = "";
        String password = "";
        if (this.usingOldCredentials()) {
            userName = env.expand(this.getUserName());
            password = env.expand(this.getUserPassword().getPlainText());
        } else {
            String credentialsId = env.expand(this.getCredentialsId());
            if (!StringUtils.isEmpty((String)credentialsId)) {
                StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardUsernamePasswordCredentials.class, run, (DomainRequirement[])new DomainRequirement[0]);
                if (credentials == null) {
                    throw new CredentialsNotFoundException(String.format(Messages.TcTestBuilder_CredentialsNotFound(), credentialsId));
                }
                userName = credentials.getUsername();
                password = credentials.getPassword().getPlainText();
            }
        }
        if (!StringUtils.isEmpty((String)userName) && userName.contains("\\")) {
            int pos = userName.lastIndexOf("\\");
            domain = userName.substring(0, pos);
            userName = userName.substring(pos + 1);
        }
        resultArgs.add("//LogonAndExecute");
        resultArgs.add("//lDomain:").addQuoted(domain);
        resultArgs.add("//lName:").addQuoted(userName);
        resultArgs.add("//lPassword:").addQuoted(Utils.encryptPassword(password), true);
        long timeout = this.getTimeoutValue(null, env);
        if (timeout != -1L) {
            timeout += 180L;
            timeout *= 1000L;
        }
        resultArgs.add("//lTimeout:").addQuoted(Long.toString(timeout));
        resultArgs.add("//lUseActiveSession:").addQuoted(Boolean.toString(this.getUseActiveSession()));
        resultArgs.add("//lCommandLine:").addQuoted(baseArgs.toStringWithQuote());
        if (this.DEBUG) {
            TcLog.debug(listener, Messages.TcTestBuilder_Debug_SessionScreenResolution(), this.sessionScreenResolution);
        }
        if ((sessionScreenResolutionString = this.sessionScreenResolution) == null || sessionScreenResolutionString.isEmpty()) {
            sessionScreenResolutionString = ScreenResolution.getDefaultResolutionString();
        }
        if ((resolution = ScreenResolution.parseResolution(sessionScreenResolutionString)) != null) {
            if (!resolution.equals(ScreenResolution.getDefaultResolution())) {
                if (chosenInstallation.isCustomScreenResolutionSupported()) {
                    if (this.useActiveSession) {
                        TcLog.warning(listener, Messages.TcTestBuilder_CustomSessionScreenResolutionCanBeIgnored(), new Object[0]);
                    }
                    resultArgs.add("//lSessionScreenWidth:").addQuoted(Integer.toString(resolution.getWidth()));
                    resultArgs.add("//lSessionScreenHeight:").addQuoted(Integer.toString(resolution.getHeight()));
                } else {
                    TcLog.warning(listener, Messages.TcTestBuilder_CustomSessionScreenResolutionNotSupported(), new Object[0]);
                }
            }
        } else {
            TcLog.warning(listener, Messages.TcTestBuilder_NotSupportedSessionScreenResolution(), this.sessionScreenResolution);
        }
        return resultArgs;
    }

    private ArgumentListBuilder prepareSessionCreatorCommandLine(TaskListener listener, TcInstallation chosenInstallation, ArgumentListBuilder baseArgs, EnvVars env) throws Exception {
        ArgumentListBuilder resultArgs = new ArgumentListBuilder();
        resultArgs.addQuoted(chosenInstallation.getSessionCreatorPath());
        resultArgs.add("ExecuteProcess");
        if (this.DEBUG) {
            resultArgs.add("/v");
        }
        resultArgs.add("/c:" + baseArgs.toStringWithQuote());
        return resultArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFiles(TcInstallation installation, Run<?, ?> run, VirtualChannel channel, TaskListener listener, Workspace workspace, TcReportAction testResult, long startTime) throws IOException, InterruptedException {
        String logFileName;
        BufferedReader br = null;
        try {
            if (workspace.getSlaveErrorFilePath().exists()) {
                br = new BufferedReader(new InputStreamReader(workspace.getSlaveErrorFilePath().read(), Charset.forName("UTF-8")));
                String errorString = br.readLine().trim();
                TcLog.warning(listener, Messages.TcTestBuilder_ErrorMessage(), errorString);
                testResult.setError(errorString);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (!this.KEEP_LOGS) {
                workspace.getSlaveErrorFilePath().delete();
            }
        }
        if (workspace.getSlaveLogXFilePath().exists()) {
            try {
                workspace.getSlaveLogXFilePath().copyTo(workspace.getMasterLogXFilePath());
                logFileName = workspace.getMasterLogXFilePath().getName();
                testResult.setTcLogXFileName(logFileName);
                EnvVars env = run.getEnvironment(listener);
                String suiteFileName = new FilePath(new File(env.expand(this.getSuite()))).getBaseName();
                boolean errorOnWarnings = BuildStepAction.MAKE_FAILED.name().equals(this.actionOnWarnings);
                ParserSettings parserSettings = new ParserSettings(new File(workspace.getMasterLogXFilePath().getRemote()), suiteFileName, env.expand(this.getProject()), this.getPublishJUnitReports(), errorOnWarnings);
                int timezoneOffset = Utils.getTimezoneOffset(channel, listener);
                ILogParser logParser = installation.hasNewLogVersion() ? new LogParser2(parserSettings, timezoneOffset) : new LogParser(parserSettings, timezoneOffset);
                testResult.setLogInfo(logParser.parse(listener));
            }
            finally {
                if (!this.KEEP_LOGS) {
                    workspace.getSlaveLogXFilePath().delete();
                }
            }
        } else {
            TcLog.warning(listener, Messages.TcTestBuilder_UnableToFindLogFile(), workspace.getSlaveLogXFilePath().getName());
            testResult.setLogInfo(new TcLogInfo(startTime, 0L, 0, 1, 0));
        }
        if (workspace.getSlaveHtmlXFilePath().exists()) {
            try {
                workspace.getSlaveHtmlXFilePath().copyTo(workspace.getMasterHtmlXFilePath());
                logFileName = workspace.getMasterHtmlXFilePath().getName();
                testResult.setHtmlXFileName(logFileName);
            }
            finally {
                if (!this.KEEP_LOGS) {
                    workspace.getSlaveHtmlXFilePath().delete();
                }
            }
        } else {
            TcLog.warning(listener, Messages.TcTestBuilder_UnableToFindLogFile(), workspace.getSlaveHtmlXFilePath().getName());
        }
        if (this.getGenerateMHT()) {
            if (workspace.getSlaveMHTFilePath().exists()) {
                try {
                    workspace.getSlaveMHTFilePath().copyTo(workspace.getMasterMHTFilePath());
                    logFileName = workspace.getMasterMHTFilePath().getName();
                    testResult.setMhtFileName(logFileName);
                }
                finally {
                    if (!this.KEEP_LOGS) {
                        workspace.getSlaveMHTFilePath().delete();
                    }
                }
            } else {
                TcLog.warning(listener, Messages.TcTestBuilder_UnableToFindLogFile(), workspace.getSlaveMHTFilePath().getName());
            }
        }
    }

    private String makeDisplayName(Run<?, ?> run, TaskListener listener) throws IOException, InterruptedException {
        StringBuilder builder = new StringBuilder();
        EnvVars env = run.getEnvironment(listener);
        String launchType = this.getLaunchType();
        String suiteFileName = new FilePath(new File(env.expand(this.getSuite()))).getBaseName();
        builder.append(suiteFileName);
        if (TcInstallation.LaunchType.lcProject.name().equals(launchType)) {
            builder.append("/");
            builder.append(env.expand(this.getProject()));
        } else if (TcInstallation.LaunchType.lcRoutine.name().equals(launchType)) {
            builder.append("/");
            builder.append(env.expand(this.getProject()));
            builder.append("/");
            builder.append(env.expand(this.getUnit()));
            builder.append("/");
            builder.append(env.expand(this.getRoutine()));
        } else if (TcInstallation.LaunchType.lcKdt.name().equals(launchType)) {
            builder.append("/");
            builder.append(env.expand(this.getProject()));
            builder.append("/KeyWordTests|");
            builder.append(env.expand(this.getTest()));
        } else if (TcInstallation.LaunchType.lcTags.name().equals(launchType)) {
            builder.append("/");
            builder.append(env.expand(this.getProject()));
            builder.append("/Tags|");
            builder.append(env.expand(this.getTags()));
        } else if (TcInstallation.LaunchType.lcItem.name().equals(launchType)) {
            builder.append("/");
            builder.append(env.expand(this.getProject()));
            builder.append("/");
            builder.append(env.expand(this.getTest()));
        }
        return builder.toString();
    }

    private String getExitCodeDescription(int exitCode) {
        switch (exitCode) {
            case -6: {
                return Messages.TcServiceProcessNotAvailable();
            }
            case -7: {
                return Messages.TcServiceInvalidArgs();
            }
            case -8: {
                return Messages.TcServiceInternalError();
            }
            case -9: {
                return Messages.TcServiceInternalError();
            }
            case -10: {
                return Messages.TcServiceSessionCreationError();
            }
            case -11: {
                return Messages.TcServiceSessionLogOffError();
            }
            case -12: {
                return Messages.TcServiceProcessCreationError();
            }
            case -13: {
                return Messages.TcServiceTimeout();
            }
            case -14: {
                return Messages.TcServiceOldVersion();
            }
        }
        return null;
    }

    private long getTimeoutValue(TaskListener listener, EnvVars env) {
        if (this.getUseTimeout()) {
            try {
                long timeout = Long.parseLong(env.expand(this.getTimeout()));
                if (timeout > 0L) {
                    return timeout;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (listener != null) {
                TcLog.warning(listener, Messages.TcTestBuilder_InvalidTimeoutValue(), env.expand(this.getTimeout()));
            }
        }
        return -1L;
    }

    private void checkParameter(String value, String parameterName, Class<?> targetEnum, String additionalValue) throws InvalidConfigurationException {
        if (value == null) {
            throw new InvalidConfigurationException(String.format(Messages.TcTestBuilder_InvalidParameterValue(), "", parameterName));
        }
        for (Object targetValue : targetEnum.getEnumConstants()) {
            if (!value.equals(targetValue.toString())) continue;
            return;
        }
        if (value.equals(additionalValue)) {
            return;
        }
        throw new InvalidConfigurationException(String.format(Messages.TcTestBuilder_InvalidParameterValue(), value, parameterName));
    }

    private void addArg(ArgumentListBuilder args, String value, boolean newFormat) {
        if (newFormat) {
            args.addQuoted(value);
        } else {
            args.add(value);
        }
    }

    private ArgumentListBuilder makeCommandLineArgs(Run<?, ?> run, Launcher launcher, TaskListener listener, Workspace workspace, TcInstallation installation, boolean useNewCommandLineFormat, Collection<String> passwordsToMask) throws IOException, InterruptedException, TagsException, CredentialsNotFoundException {
        long timeout;
        ArgumentListBuilder args = new ArgumentListBuilder();
        FilePath execPath = new FilePath(launcher.getChannel(), installation.getExecutorPath());
        this.addArg(args, execPath.getRemote(), useNewCommandLineFormat);
        EnvVars env = run.getEnvironment(listener);
        this.addArg(args, new FilePath(workspace.getSlaveWorkspacePath(), env.expand(this.getSuite())).getRemote(), useNewCommandLineFormat);
        args.add(RUN_ARG);
        String accessKeyId = env.expand(this.getAccessKeyId());
        if (!StringUtils.isEmpty((String)accessKeyId)) {
            StringCredentials credentials = (StringCredentials)CredentialsProvider.findCredentialById((String)accessKeyId, StringCredentials.class, run, (DomainRequirement[])new DomainRequirement[0]);
            if (credentials == null) {
                throw new CredentialsNotFoundException(String.format(Messages.TcTestBuilder_AccessKeyNotFound(), accessKeyId));
            }
            String accessKey = credentials.getSecret().getPlainText();
            args.add(ACCESS_KEY_ARG + accessKey, true);
            passwordsToMask.add(accessKey);
        }
        args.add(SILENT_MODE_ARG);
        args.add(FORCE_CONVERSION_ARG);
        args.add(NS_ARG);
        args.add(EXIT_ARG);
        this.addArg(args, EXPORT_LOG_ARG + workspace.getSlaveLogXFilePath().getRemote(), useNewCommandLineFormat);
        this.addArg(args, EXPORT_LOG_ARG + workspace.getSlaveHtmlXFilePath().getRemote(), useNewCommandLineFormat);
        this.addArg(args, ERROR_LOG_ARG + workspace.getSlaveErrorFilePath(), useNewCommandLineFormat);
        if (this.getGenerateMHT()) {
            this.addArg(args, EXPORT_LOG_ARG + workspace.getSlaveMHTFilePath().getRemote(), useNewCommandLineFormat);
        }
        if (this.getUseTimeout() && (timeout = this.getTimeoutValue(listener, env)) != -1L) {
            args.add(TIMEOUT_ARG + timeout);
        }
        if (TcInstallation.LaunchType.lcProject.name().equals(this.launchType)) {
            this.addArg(args, PROJECT_ARG + env.expand(this.getProject()), useNewCommandLineFormat);
        } else if (TcInstallation.LaunchType.lcRoutine.name().equals(this.launchType)) {
            this.addArg(args, PROJECT_ARG + env.expand(this.getProject()), useNewCommandLineFormat);
            this.addArg(args, UNIT_ARG + env.expand(this.getUnit()), useNewCommandLineFormat);
            this.addArg(args, ROUTINE_ARG + env.expand(this.getRoutine()), useNewCommandLineFormat);
        } else if (TcInstallation.LaunchType.lcKdt.name().equals(this.launchType)) {
            this.addArg(args, PROJECT_ARG + env.expand(this.getProject()), useNewCommandLineFormat);
            this.addArg(args, "/test:KeyWordTests|" + env.expand(this.getTest()), useNewCommandLineFormat);
        } else if (TcInstallation.LaunchType.lcTags.name().equals(this.launchType)) {
            if (installation.compareVersion("14.20", false) < 0) {
                throw new TagsException(Messages.TcTestBuilder_Tags_NotSupportedTCVersion());
            }
            this.addArg(args, PROJECT_ARG + env.expand(this.getProject()), useNewCommandLineFormat);
            this.addArg(args, TAGS_ARG + env.expand(this.getTags()), useNewCommandLineFormat);
        } else if (TcInstallation.LaunchType.lcItem.name().equals(this.launchType)) {
            this.addArg(args, PROJECT_ARG + env.expand(this.getProject()), useNewCommandLineFormat);
            this.addArg(args, TEST_ARG + env.expand(this.getTest()), useNewCommandLineFormat);
        }
        if (installation.getType() == TcInstallation.ExecutorType.TE) {
            args.add(NO_LOG_ARG);
        }
        if (useNewCommandLineFormat) {
            String[] tokenizedArgs;
            for (String arg : tokenizedArgs = Util.tokenize((String)env.expand(this.getCommandLineArguments()))) {
                String escapedCommandLineArgument = arg.replace("\"", "\\\\\\\"");
                if (escapedCommandLineArgument.isEmpty()) continue;
                args.add("\"" + escapedCommandLineArgument + "\"");
            }
        } else {
            args.addTokenized(env.expand(this.getCommandLineArguments()));
        }
        String version = Utils.getPluginVersionOrNull();
        if (version != null) {
            args.add(VERSION_ARG + version);
        } else if (this.DEBUG) {
            TcLog.debug(listener, Messages.TcTestBuilder_Debug_FailedToDefineSelfVersion(), new Object[0]);
        }
        if (this.DEBUG) {
            TcLog.debug(listener, Messages.TcTestBuilder_Debug_AdditionalCommandLineArguments(), this.commandLineArguments);
        }
        return args;
    }

    private TcSummaryAction getOrCreateAction(Run<?, ?> run) {
        TcSummaryAction currentAction = (TcSummaryAction)run.getAction(TcSummaryAction.class);
        if (currentAction == null) {
            currentAction = new TcSummaryAction(run);
            run.addAction((Action)currentAction);
        }
        return currentAction;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"testcompletetest"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            super(TcTestBuilder.class);
            this.load();
        }

        public String getPluginName() {
            return "TestComplete";
        }

        public Builder newInstance(StaplerRequest req, @Nonnull JSONObject formData) throws Descriptor.FormException {
            TcTestBuilder builder = (TcTestBuilder)super.newInstance(req, formData);
            if (!StringUtils.isEmpty((String)builder.getCredentialsId())) {
                builder.setUserName("");
                builder.setUserPassword("");
            }
            if (TcInstallation.LaunchType.lcCBT.name().equals(builder.getLaunchType())) {
                builder.setLaunchType(TcInstallation.LaunchType.lcSuite.name());
            }
            return builder;
        }

        public FormValidation doCheckSuite(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.TcTestBuilder_Descriptor_ValueNotSpecified());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProject(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.TcTestBuilder_Descriptor_ValueNotSpecified());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUnit(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.TcTestBuilder_Descriptor_ValueNotSpecified());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRoutine(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.TcTestBuilder_Descriptor_ValueNotSpecified());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTest(@QueryParameter String value) {
            if (value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.TcTestBuilder_Descriptor_ValueNotSpecified());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            try {
                Integer.parseInt(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.TcTestBuilder_Descriptor_IsNotNumber());
            }
        }

        public ListBoxModel doFillExecutorTypeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add(Messages.TcTestBuilder_Descriptor_AnyTagText(), "any");
            model.add("TestExecute", TcInstallation.ExecutorType.TE.toString());
            model.add("TestComplete", TcInstallation.ExecutorType.TC.toString());
            return model;
        }

        public ListBoxModel doFillSessionScreenResolutionItems() {
            ListBoxModel model = new ListBoxModel();
            for (ScreenResolution resolution : ScreenResolution.getList()) {
                model.add(resolution.toString());
            }
            return model;
        }

        public ListBoxModel doFillExecutorVersionItems() {
            ListBoxModel model = new ListBoxModel();
            model.add(Messages.TcTestBuilder_Descriptor_LatestTagText(), "any");
            model.add("15", "15.0");
            model.add("14", "14.0");
            model.add("12", "12.0");
            model.add("11", "11.0");
            model.add("10", "10.0");
            model.add("9", "9.0");
            return model;
        }

        public ListBoxModel doFillActionOnWarningsItems() {
            ListBoxModel model = new ListBoxModel();
            model.add(Messages.BuildStepAction_None(), BuildStepAction.NONE.name());
            model.add(Messages.BuildStepAction_MakeUnstable(), BuildStepAction.MAKE_UNSTABLE.name());
            model.add(Messages.BuildStepAction_MakeFailed(), BuildStepAction.MAKE_FAILED.name());
            return model;
        }

        public ListBoxModel doFillActionOnErrorsItems() {
            ListBoxModel model = new ListBoxModel();
            model.add(Messages.BuildStepAction_None(), BuildStepAction.NONE.name());
            model.add(Messages.BuildStepAction_MakeUnstable(), BuildStepAction.MAKE_UNSTABLE.name());
            model.add(Messages.BuildStepAction_MakeFailed(), BuildStepAction.MAKE_FAILED.name());
            return model;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.TcTestBuilder_DisplayName();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            return this.getCredentialList(item, credentialsId);
        }

        private ListBoxModel getCredentialList(Item item, String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.add(credentialsId);
            }
            List standardCredentials = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList());
            return result.withEmptySelection().withAll((Iterable)standardCredentials).withMatching(CredentialsMatchers.withId((String)credentialsId), (IdCredentials[])new StandardCredentials[0]);
        }

        public ListBoxModel doFillAccessKeyIdItems(@AncestorInPath Item item, @QueryParameter String accessKeyId) {
            return this.getAccessKeyIdCredentialList(item, accessKeyId);
        }

        private ListBoxModel getAccessKeyIdCredentialList(Item item, String accessKeyId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.add(accessKeyId);
            }
            List stringCredentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, null, Collections.emptyList());
            return result.withEmptySelection().withAll((Iterable)stringCredentials).withMatching(CredentialsMatchers.withId((String)accessKeyId), (IdCredentials[])new StandardCredentials[0]);
        }
    }

    private static class CredentialsNotFoundException
    extends Exception {
        CredentialsNotFoundException(String message) {
            super(message);
        }
    }

    private static class InvalidConfigurationException
    extends Exception {
        InvalidConfigurationException(String message) {
            super(message);
        }
    }

    private static class TagsException
    extends Exception {
        TagsException(String message) {
            super(message);
        }
    }

    private static class CBTException
    extends Exception {
        CBTException(String message) {
            super(message);
        }
    }

    public static enum BuildStepAction {
        NONE,
        MAKE_UNSTABLE,
        MAKE_FAILED;

    }

    public static class LaunchConfig {
        private String launchType = TcInstallation.LaunchType.lcSuite.toString();
        private String project = "";
        private String unit = "";
        private String routine = "";
        private String test = "";
        private String tags = "";

        @DataBoundConstructor
        public LaunchConfig() {
        }

        @DataBoundSetter
        public void setValue(String value) {
            this.launchType = value;
        }

        public String getValue() {
            return this.launchType;
        }

        @DataBoundSetter
        public void setProject(String project) {
            this.project = project;
        }

        public String getProject() {
            return this.project;
        }

        @DataBoundSetter
        public void setUnit(String unit) {
            this.unit = unit;
        }

        public String getUnit() {
            return this.unit;
        }

        @DataBoundSetter
        public void setRoutine(String routine) {
            this.routine = routine;
        }

        public String getRoutine() {
            return this.routine;
        }

        @DataBoundSetter
        public void setTest(String test) {
            this.test = test;
        }

        public String getTest() {
            return this.test;
        }

        @DataBoundSetter
        public void setTags(String tags) {
            this.tags = tags;
        }

        public String getTags() {
            return this.tags;
        }
    }
}

