/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete;

import com.smartbear.jenkins.plugins.testcomplete.Messages;
import com.smartbear.jenkins.plugins.testcomplete.TcLogInfo;
import com.smartbear.jenkins.plugins.testcomplete.TcSummaryAction;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Run;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class TcReportAction
implements Action,
Serializable {
    private final Run<?, ?> build;
    private final String id;
    private final String testName;
    private final String agent;
    private String tcLogXFileName = "";
    private String htmlXFileName = "";
    private String mhtFileName = "";
    private int exitCode = 0;
    private boolean result = true;
    private boolean startFailed = false;
    private String error = "";
    private TcLogInfo logInfo = null;
    private transient TcSummaryAction parent = null;

    public TcReportAction(Run<?, ?> build, String id, String testName, String agent) {
        this.id = id;
        this.testName = testName;
        this.agent = agent;
        this.build = build;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return this.testName;
    }

    public String getUrlName() {
        return null;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public String getId() {
        return this.id;
    }

    @Exported(name="testName")
    public String getTestName() {
        return this.testName;
    }

    @Exported(name="agent")
    public String getAgent() {
        return this.agent;
    }

    @Exported(name="url")
    public String getUrl() {
        return Jenkins.get().getRootUrl() + this.build.getUrl() + "TestComplete" + "/reports/" + this.id;
    }

    public String getTcLogXFileName() {
        return this.tcLogXFileName;
    }

    public void setTcLogXFileName(String tcLogXFileName) {
        this.tcLogXFileName = tcLogXFileName;
    }

    public String getHtmlXFileName() {
        return this.htmlXFileName;
    }

    public void setHtmlXFileName(String htmlXFileName) {
        this.htmlXFileName = htmlXFileName;
    }

    public String getMhtFileName() {
        return this.mhtFileName;
    }

    public void setMhtFileName(String mhtFileName) {
        this.mhtFileName = mhtFileName;
    }

    @Exported(name="exitCode")
    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    @Exported(name="success")
    public boolean getResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    @Exported(name="failedToStart")
    public boolean getStartFailed() {
        return this.startFailed;
    }

    public void setStartFailed(boolean startFailed) {
        this.startFailed = startFailed;
    }

    @Exported(name="error")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    @Exported(name="details", inline=true)
    public TcLogInfo getLogInfo() {
        return this.logInfo;
    }

    public void setLogInfo(TcLogInfo logInfo) {
        this.logInfo = logInfo;
    }

    public TcSummaryAction getParent() {
        return this.parent;
    }

    public void setParent(TcSummaryAction parent) {
        this.parent = parent;
    }

    public boolean hasInfo() {
        return this.htmlXFileName != null && !this.htmlXFileName.isEmpty() || this.error != null && !this.error.isEmpty();
    }

    public String getNoInfoMessage(String url) {
        return String.format(Messages.TcTestBuilder_NoInfo(), url);
    }

    public boolean hasMHTReport() {
        return this.mhtFileName != null && !this.mhtFileName.isEmpty();
    }
}

