/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete;

import com.smartbear.jenkins.plugins.testcomplete.Messages;
import com.smartbear.jenkins.plugins.testcomplete.TcInstallation;
import com.smartbear.jenkins.plugins.testcomplete.TcLog;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.jna.JnaException;
import hudson.util.jna.RegistryKey;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jenkinsci.remoting.RoleChecker;

class TcInstallationsScanner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int REGISTRY_KEY_WOW64_32KEY = 512;
    private static final int REGISTRY_KEY_READ = 131097;
    private final VirtualChannel channel;
    private final TaskListener listener;

    TcInstallationsScanner(VirtualChannel channel, TaskListener listener) {
        this.channel = channel;
        this.listener = listener;
    }

    List<TcInstallation> getInstallations() {
        List result = null;
        try {
            result = (List)this.channel.call((Callable)new ScannerCallable());
        }
        catch (Exception e) {
            TcLog.error(this.listener, Messages.TcTestBuilder_RemoteCallingFailed(), e.getCause().getMessage());
        }
        return result != null ? result : new LinkedList();
    }

    TcInstallation findInstallation(List<TcInstallation> installations, String executorType, String executorVersion) {
        TcInstallation result = null;
        for (TcInstallation one : installations) {
            if (!executorType.equals("any") && one.getType() != TcInstallation.ExecutorType.valueOf(executorType) || !executorVersion.equals("any") && one.compareVersion(executorVersion, true) != 0) continue;
            if (result == null) {
                result = one;
                continue;
            }
            if (one.compareVersion(result.getVersion(), false) > 0) {
                result = one;
                continue;
            }
            if (result.compareVersion(one.getVersion(), false) != 0 || one.getType() != TcInstallation.ExecutorType.TE) continue;
            result = one;
        }
        return result;
    }

    private static class ScannerCallable
    implements Callable<List<TcInstallation>, Exception>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final String registryKey = "SOFTWARE\\SmartBear\\";

        ScannerCallable() {
        }

        public List<TcInstallation> call() {
            ArrayList<TcInstallation> result = new ArrayList<TcInstallation>();
            this.scanForInstallations(result, "TestComplete", TcInstallation.ExecutorType.TC);
            this.scanForInstallations(result, "TestExecute", TcInstallation.ExecutorType.TE);
            this.scanForInstallations(result, "TestExecuteLite", TcInstallation.ExecutorType.TELite);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanForInstallations(List<TcInstallation> result, String executor, TcInstallation.ExecutorType type) {
            block14: {
                String key = registryKey + executor + "\\";
                RegistryKey executorKey = null;
                try {
                    executorKey = RegistryKey.LOCAL_MACHINE.open(key, 131609);
                    Collection installKeys = executorKey.getSubKeys();
                    if (installKeys == null || installKeys.size() <= 0) break block14;
                    for (String versionKey : installKeys) {
                        if (!versionKey.matches("^[0-9]{1,3}([.][0-9]{1,5})+$")) continue;
                        RegistryKey setupKey = null;
                        try {
                            setupKey = executorKey.open(versionKey + "\\Setup\\", 131609);
                            String path = setupKey.getStringValue("Product path");
                            String version = setupKey.getStringValue("Version");
                            if (version == null || !version.matches("^[0-9]{1,3}([.][0-9]{1,5})+$") || path == null || path.isEmpty()) continue;
                            String rootBinPath = path + "bin";
                            String executorPath = path + "x64\\bin\\" + executor + ".exe";
                            if (new File(executorPath).exists()) {
                                result.add(new TcInstallation(rootBinPath, executorPath, type, version));
                                continue;
                            }
                            executorPath = path + "bin\\" + executor + ".exe";
                            if (!new File(executorPath).exists()) continue;
                            result.add(new TcInstallation(rootBinPath, executorPath, type, version));
                        }
                        catch (JnaException jnaException) {}
                        continue;
                        finally {
                            if (setupKey == null) continue;
                            setupKey.dispose();
                        }
                    }
                }
                catch (JnaException jnaException) {
                }
                finally {
                    if (executorKey != null) {
                        executorKey.dispose();
                    }
                }
            }
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
        }
    }
}

