/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete;

import com.smartbear.jenkins.plugins.testcomplete.Messages;
import hudson.FilePath;
import java.io.File;
import java.io.Serializable;

public class TcInstallation
implements Serializable {
    private static final int VERSION_PARTS = 3;
    private final String rootBinPath;
    private final String executorPath;
    private final ExecutorType type;
    private final String version;

    public TcInstallation(String rootBinPath, String executorPath, ExecutorType type, String version) {
        this.rootBinPath = rootBinPath;
        this.executorPath = executorPath;
        this.type = type;
        this.version = version;
    }

    public String getExecutorPath() {
        return this.executorPath;
    }

    public String getServicePath() {
        return this.rootBinPath + "\\" + String.format("TestCompleteService%d.exe", this.getMajorVersion());
    }

    public String getSessionCreatorPath() {
        return new FilePath(new File(this.executorPath)).getParent().getRemote() + "\\" + "SessionCreator.exe";
    }

    public ExecutorType getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public int getMajorVersion() {
        String[] parts = this.version.split("[.]");
        return Integer.parseInt(parts[0]);
    }

    public int compareVersion(String anotherVersion, boolean majorOnly) {
        int i;
        int[] selfVersionParts = new int[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            selfVersionParts[i2] = 0;
        }
        int[] anotherVersionParts = new int[3];
        for (int i3 = 0; i3 < 3; ++i3) {
            anotherVersionParts[i3] = 0;
        }
        String[] selfSplit = this.version.split("[.]");
        for (int i4 = 0; i4 < Math.min(3, selfSplit.length); ++i4) {
            selfVersionParts[i4] = Integer.parseInt(selfSplit[i4]);
        }
        String[] anotherSplit = anotherVersion.split("[.]");
        for (i = 0; i < Math.min(3, anotherSplit.length); ++i) {
            anotherVersionParts[i] = Integer.parseInt(anotherSplit[i]);
        }
        for (i = 0; i < (majorOnly ? 1 : 3); ++i) {
            if (selfVersionParts[i] > anotherVersionParts[i]) {
                return 1;
            }
            if (selfVersionParts[i] >= anotherVersionParts[i]) continue;
            return -1;
        }
        return 0;
    }

    public boolean isServiceLaunchingAvailable() {
        return this.compareVersion("10.60", false) >= 0;
    }

    public boolean isCustomScreenResolutionSupported() {
        return this.compareVersion("12.30", false) >= 0;
    }

    public boolean hasNewLogVersion() {
        return this.compareVersion("14.10", false) >= 0;
    }

    public boolean hasExtendedCommandLine() {
        return this.compareVersion("14.30", false) >= 0;
    }

    public String toString() {
        return String.format(Messages.TcInstallation_InstallationString(), new Object[]{this.getType(), this.getVersion(), this.getExecutorPath()});
    }

    public static enum ExecutorType {
        TC,
        TE,
        TELite;

    }

    public static enum LaunchType {
        lcSuite,
        lcProject,
        lcTags,
        lcRoutine,
        lcKdt,
        lcItem,
        lcCBT;

    }
}

