/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete;

import java.util.ArrayList;
import java.util.List;

public class ScreenResolution {
    private static final String SEPARATOR = "x";
    private int width;
    private int height;
    private static ScreenResolution defaultResolution;
    private static List<ScreenResolution> list;

    public ScreenResolution(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return Integer.toString(this.width) + SEPARATOR + Integer.toString(this.height);
    }

    static ScreenResolution parseResolution(String resolutionString) {
        if (resolutionString == null || resolutionString.isEmpty()) {
            return null;
        }
        String[] parts = resolutionString.split(SEPARATOR);
        if (parts.length != 2) {
            return null;
        }
        try {
            int width = Integer.parseInt(parts[0]);
            int height = Integer.parseInt(parts[1]);
            for (ScreenResolution item : list) {
                if (item.getWidth() != width || item.getHeight() != height) continue;
                return item;
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static List<ScreenResolution> getList() {
        return new ArrayList<ScreenResolution>(list);
    }

    public static ScreenResolution getDefaultResolution() {
        return defaultResolution;
    }

    public static String getDefaultResolutionString() {
        return ScreenResolution.getDefaultResolution().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScreenResolution)) {
            return false;
        }
        ScreenResolution another = (ScreenResolution)obj;
        return this.height == another.height && this.width == another.width;
    }

    static {
        list = new ArrayList<ScreenResolution>();
        list.add(new ScreenResolution(800, 600));
        list.add(new ScreenResolution(1024, 600));
        list.add(new ScreenResolution(1024, 768));
        list.add(new ScreenResolution(1152, 864));
        list.add(new ScreenResolution(1280, 720));
        list.add(new ScreenResolution(1280, 768));
        list.add(new ScreenResolution(1280, 800));
        defaultResolution = new ScreenResolution(1280, 1024);
        list.add(defaultResolution);
        list.add(new ScreenResolution(1360, 768));
        list.add(new ScreenResolution(1366, 768));
        list.add(new ScreenResolution(1440, 900));
        list.add(new ScreenResolution(1600, 900));
        list.add(new ScreenResolution(1600, 1200));
        list.add(new ScreenResolution(1680, 1050));
        list.add(new ScreenResolution(1920, 1080));
        list.add(new ScreenResolution(1920, 1200));
        list.add(new ScreenResolution(2560, 1440));
        list.add(new ScreenResolution(2560, 1600));
        list.add(new ScreenResolution(3200, 1200));
        list.add(new ScreenResolution(3840, 2160));
        list.add(new ScreenResolution(7680, 4320));
    }
}

