/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.modules.windows_slave_installer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Callable;
import jenkins.model.Jenkins;
import org.jenkinsci.modules.windows_slave_installer.WindowsSlaveInstaller;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="1.9")
public class SlaveExeUpdater
extends ComputerListener {
    private volatile String ourCopy;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Should be accessible to System Grrovy Scripts")
    static boolean DISABLE_AUTOMATIC_UPDATE = Boolean.getBoolean("org.jenkinsci.modules.windows_slave_installer.disableAutoUpdate");

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void onOnline(Computer c, final TaskListener listener) throws IOException, InterruptedException {
        if (DISABLE_AUTOMATIC_UPDATE) {
            return;
        }
        if (!(c instanceof SlaveComputer)) {
            return;
        }
        final SlaveComputer sc = (SlaveComputer)c;
        Jenkins.MasterComputer.threadPoolForRemoting.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    Channel ch = sc.getChannel();
                    Slave n = sc.getNode();
                    if (n == null || ch == null) {
                        return null;
                    }
                    FilePath root = new FilePath((VirtualChannel)ch, n.getRemoteFS());
                    FilePath agentExe = root.child("jenkins-slave.exe");
                    if (!agentExe.exists()) {
                        return null;
                    }
                    String current = agentExe.digest();
                    URL ourExe = WindowsSlaveInstaller.class.getResource("jenkins-slave.exe");
                    if (SlaveExeUpdater.this.ourCopy == null) {
                        SlaveExeUpdater.this.ourCopy = Util.getDigestOf((InputStream)ourExe.openStream());
                    }
                    if (SlaveExeUpdater.this.ourCopy.equals(current)) {
                        return null;
                    }
                    FilePath tmp = new FilePath(agentExe.getChannel(), agentExe.getRemote() + ".new");
                    FilePath backup = new FilePath(agentExe.getChannel(), agentExe.getRemote() + ".bak");
                    if (backup.exists()) {
                        try {
                            backup.delete();
                        }
                        catch (IOException e) {
                            listener.getLogger().println("Looks like jenkins-slave.exe.bak is currently running. aborting overwrite");
                            return null;
                        }
                    }
                    tmp.copyFrom(ourExe);
                    agentExe.renameTo(backup);
                    tmp.renameTo(agentExe);
                    listener.getLogger().println("Scheduled overwrite of jenkins-slave.exe on the next service startup");
                }
                catch (Throwable e) {
                    e.printStackTrace(listener.error("Failed to update jenkins-slave.exe"));
                }
                return null;
            }
        });
    }
}

