/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.modules.windows_slave_installer;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import hudson.Launcher;
import hudson.lifecycle.Messages;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import hudson.util.jna.DotNet;
import hudson.util.jna.Kernel32Utils;
import hudson.util.jna.SHELLEXECUTEINFO;
import hudson.util.jna.Shell32;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.modules.slave_installer.InstallationException;
import org.jenkinsci.modules.slave_installer.LaunchConfiguration;
import org.jenkinsci.modules.slave_installer.Prompter;
import org.jenkinsci.modules.slave_installer.SlaveInstaller;
import org.jvnet.localizer.Localizable;

public class WindowsSlaveInstaller
extends SlaveInstaller {
    private static final long serialVersionUID = 1L;

    public Localizable getConfirmationText() {
        return Messages._WindowsSlaveInstaller_ConfirmInstallation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int runElevated(File slaveExe, String command, TaskListener out, File pwd) throws IOException, InterruptedException {
        try {
            return new Launcher.LocalLauncher(out).launch().cmds(slaveExe, new String[]{command}).stdout(out).pwd(pwd).join();
        }
        catch (IOException e) {
            if (!e.getMessage().contains("CreateProcess") || !e.getMessage().contains("=740")) {
                throw e;
            }
            SHELLEXECUTEINFO sei = new SHELLEXECUTEINFO();
            sei.fMask = 64;
            sei.lpVerb = "runas";
            sei.lpFile = slaveExe.getAbsolutePath();
            sei.lpParameters = "/redirect redirect.log " + command;
            sei.lpDirectory = pwd.getAbsolutePath();
            sei.nShow = 0;
            if (!Shell32.INSTANCE.ShellExecuteEx(sei)) {
                throw new IOException("Failed to shellExecute: " + Native.getLastError());
            }
            try {
                int n = Kernel32Utils.waitForExitProcess((Pointer)sei.hProcess);
                return n;
            }
            finally {
                FileInputStream fin = new FileInputStream(new File(pwd, "redirect.log"));
                IOUtils.copy((InputStream)fin, (OutputStream)out.getLogger());
                fin.close();
            }
        }
    }

    public void install(LaunchConfiguration params, Prompter prompter) throws InstallationException, IOException, InterruptedException {
        ByteArrayOutputStream baos;
        StreamTaskListener task;
        int r;
        if (!DotNet.isInstalled((int)2, (int)0)) {
            throw new InstallationException(Messages.WindowsSlaveInstaller_DotNetRequired());
        }
        final File dir = params.getStorage().getAbsoluteFile();
        if (!dir.exists()) {
            throw new InstallationException(Messages.WindowsSlaveInstaller_RootFsDoesntExist((Object)dir));
        }
        final File slaveExe = new File(dir, "jenkins-slave.exe");
        FileUtils.copyURLToFile((URL)WindowsSlaveInstaller.class.getResource("jenkins-slave.exe"), (File)slaveExe);
        FileUtils.copyURLToFile((URL)WindowsSlaveInstaller.class.getResource("jenkins-slave.exe.config"), (File)new File(dir, "jenkins-slave.exe.config"));
        String xml = WindowsSlaveInstaller.generateSlaveXml(WindowsSlaveInstaller.generateServiceId(dir.getPath()), System.getProperty("java.home") + "\\bin\\java.exe", null, params.buildRunnerArguments().toStringWithQuote());
        FileUtils.writeStringToFile((File)new File(dir, "jenkins-slave.xml"), (String)xml, (String)"UTF-8");
        File dstSlaveJar = new File(dir, "slave.jar").getCanonicalFile();
        if (!dstSlaveJar.exists()) {
            FileUtils.copyFile((File)params.getJarFile(), (File)dstSlaveJar);
        }
        if ((r = WindowsSlaveInstaller.runElevated(slaveExe, "install", (TaskListener)(task = new StreamTaskListener((OutputStream)(baos = new ByteArrayOutputStream()))), dir)) != 0) {
            throw new InstallationException(baos.toString());
        }
        Runtime.getRuntime().addShutdownHook(new Thread("service starter"){

            public void run() {
                try {
                    StreamTaskListener task = StreamTaskListener.fromStdout();
                    int r = WindowsSlaveInstaller.runElevated(slaveExe, "start", (TaskListener)task, dir);
                    task.getLogger().println(r == 0 ? "Successfully started" : "start service failed. Exit code=" + r);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        System.exit(0);
    }

    public static String generateServiceId(String slaveRoot) throws IOException {
        return "jenkinsslave-" + slaveRoot.replace(':', '_').replace('\\', '_').replace('/', '_');
    }

    public static String generateSlaveXml(String id, String java, String vmargs, String args) throws IOException {
        String xml = IOUtils.toString((InputStream)WindowsSlaveInstaller.class.getResourceAsStream("jenkins-slave.xml"), (String)"UTF-8");
        xml = xml.replace("@ID@", id);
        xml = xml.replace("@JAVA@", java);
        xml = xml.replace("@VMARGS@", StringUtils.defaultString((String)vmargs));
        xml = xml.replace("@ARGS@", args);
        return xml;
    }
}

