/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.sshd;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import java.io.IOException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.util.ServerTcpPort;
import jenkins.util.Timer;
import net.sf.json.JSONObject;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.jenkinsci.main.modules.sshd.CommandFactoryImpl;
import org.jenkinsci.main.modules.sshd.IdleTimeout;
import org.jenkinsci.main.modules.sshd.PublicKeyAuthenticatorImpl;
import org.jenkinsci.main.modules.sshd.UserAuthNamedFactory;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class SSHD
extends GlobalConfiguration {
    private static final List<NamedFactory<Cipher>> ENABLED_CIPHERS = Arrays.asList(BuiltinCiphers.aes128ctr, BuiltinCiphers.aes192ctr, BuiltinCiphers.aes256ctr);
    @GuardedBy(value="this")
    private transient SshServer sshd;
    @Inject
    private transient InstanceIdentity identity;
    @CheckForSigned
    private volatile int port = -1;
    public static final String IDLE_TIMEOUT_KEY = "idle-timeout";
    private static final Logger LOGGER = Logger.getLogger(SSHD.class.getName());
    private static Logger MINA_LOGGER = Logger.getLogger("org.apache.sshd");

    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public SSHD() {
        this.load();
    }

    @CheckForSigned
    public int getPort() {
        return this.port;
    }

    @CheckForSigned
    public synchronized int getActualPort() {
        if (this.port == -1) {
            return -1;
        }
        if (this.sshd != null) {
            return this.sshd.getPort();
        }
        return this.port;
    }

    public void setPort(int port) {
        if (this.port != port) {
            this.port = port;
            Timer.get().submit(new Runnable(){

                @Override
                public void run() {
                    SSHD.this.restart();
                }
            });
            this.save();
        }
    }

    @Nonnull
    static List<NamedFactory<Cipher>> getActivatedCiphers() {
        ArrayList<NamedFactory<Cipher>> activatedCiphers = new ArrayList<NamedFactory<Cipher>>(ENABLED_CIPHERS.size());
        for (NamedFactory<Cipher> cipher : ENABLED_CIPHERS) {
            if (cipher instanceof BuiltinCiphers) {
                BuiltinCiphers c = (BuiltinCiphers)cipher;
                if (c.isSupported()) {
                    activatedCiphers.add(cipher);
                    continue;
                }
                LOGGER.log(Level.FINE, "Discovered unsupported built-in Cipher: {0}. It will not be enabled", c);
                continue;
            }
            activatedCiphers.add(cipher);
        }
        return activatedCiphers;
    }

    public synchronized void start() throws IOException, InterruptedException {
        int port = this.port;
        if (port < 0) {
            return;
        }
        LOGGER.fine("starting SSHD");
        this.stop();
        this.sshd = SshServer.setUpDefaultServer();
        this.sshd.setUserAuthFactories(Arrays.asList(new UserAuthNamedFactory()));
        this.sshd.setCipherFactories(SSHD.getActivatedCiphers());
        this.sshd.setPort(port);
        this.sshd.setKeyPairProvider((KeyPairProvider)new AbstractKeyPairProvider(){

            public Iterable<KeyPair> loadKeys() {
                return Collections.singletonList(new KeyPair(SSHD.this.identity.getPublic(), SSHD.this.identity.getPrivate()));
            }
        });
        this.sshd.setShellFactory(null);
        this.sshd.setCommandFactory((CommandFactory)new CommandFactoryImpl());
        this.sshd.setPublickeyAuthenticator((PublickeyAuthenticator)new PublicKeyAuthenticatorImpl());
        String idleTimeoutPropertyName = SSHD.class.getName() + "." + IDLE_TIMEOUT_KEY;
        IdleTimeout.fromSystemProperty(idleTimeoutPropertyName).apply(this.sshd);
        this.sshd.start();
        LOGGER.info("Started SSHD at port " + this.sshd.getPort());
    }

    public synchronized void restart() {
        try {
            if (this.sshd != null) {
                this.sshd.stop(false);
                this.sshd = null;
            }
            this.start();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to restart SSHD", e);
        }
    }

    public synchronized void stop() throws IOException, InterruptedException {
        if (this.sshd != null) {
            this.sshd.stop(true);
            this.sshd = null;
        }
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.setPort(new ServerTcpPort(json.getJSONObject("port")).getPort());
        return true;
    }

    public static SSHD get() {
        return (SSHD)((Object)ExtensionList.lookup(GlobalConfiguration.class).get(SSHD.class));
    }

    @Initializer(after=InitMilestone.JOB_LOADED, fatal=false)
    public static void init() throws IOException, InterruptedException {
        SSHD.get().start();
    }

    static {
        if (MINA_LOGGER.getLevel() == null) {
            MINA_LOGGER.setLevel(Level.WARNING);
        }
    }
}

