/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.sshd;

import java.security.PublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.security.SecurityListener;
import org.acegisecurity.Authentication;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.jenkinsci.main.modules.cli.auth.ssh.PublicKeySignatureWriter;
import org.jenkinsci.main.modules.cli.auth.ssh.UserPropertyImpl;

class PublicKeyAuthenticatorImpl
implements PublickeyAuthenticator {
    private final PublicKeySignatureWriter signatureWriter = new PublicKeySignatureWriter();
    private static final Logger LOGGER = Logger.getLogger(PublicKeyAuthenticatorImpl.class.getName());

    PublicKeyAuthenticatorImpl() {
    }

    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        hudson.model.User user = this.retrieveOnlyKeyValidatedUser(username, key);
        if (user == null) {
            SecurityListener.fireFailedToAuthenticate((String)username);
            return false;
        }
        Authentication auth = this.verifyUserUsingSecurityRealm(user);
        if (auth == null) {
            SecurityListener.fireFailedToAuthenticate((String)username);
            return false;
        }
        SSHUserDetails userDetails = new SSHUserDetails(username, auth);
        SecurityListener.fireAuthenticated((UserDetails)userDetails);
        return true;
    }

    @CheckForNull
    private hudson.model.User retrieveOnlyKeyValidatedUser(String username, PublicKey key) {
        LOGGER.log(Level.FINE, "Authentication attempted from {0} with {1}", new Object[]{username, key});
        hudson.model.User u = hudson.model.User.getById((String)username, (boolean)false);
        if (u == null) {
            LOGGER.log(Level.FINE, "No such user exists: {0}", new Object[]{username});
            return null;
        }
        UserPropertyImpl sshKey = (UserPropertyImpl)u.getProperty(UserPropertyImpl.class);
        if (sshKey == null) {
            LOGGER.log(Level.FINE, "No SSH key registered for user: {0}", new Object[]{username});
            return null;
        }
        String signature = this.signatureWriter.asString(key);
        if (!sshKey.isAuthorizedKey(signature)) {
            LOGGER.log(Level.FINE, "Key signature did not match for the user: {0} : {1}", new Object[]{username, signature});
            return null;
        }
        return u;
    }

    @CheckForNull
    private Authentication verifyUserUsingSecurityRealm(@Nonnull hudson.model.User user) {
        try {
            return user.impersonate();
        }
        catch (UsernameNotFoundException e) {
            LOGGER.log(Level.FINE, user.getId() + " is not a real user according to SecurityRealm", e);
            return null;
        }
    }

    private static class SSHUserDetails
    extends User {
        private SSHUserDetails(@Nonnull String username, @Nonnull Authentication auth) {
            super(username, "", true, true, true, true, auth.getAuthorities());
        }
    }
}

