/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.sshd;

import hudson.model.User;
import hudson.security.ACL;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.jenkinsci.main.modules.sshd.SshCommandFactory;

public abstract class AsynchronousCommand
implements Command,
SessionAware {
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private SshCommandFactory.CommandLine cmdLine;
    private Thread thread;
    private ServerSession session;
    private Environment environment;

    protected AsynchronousCommand(SshCommandFactory.CommandLine cmdLine) {
        this.cmdLine = cmdLine;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public OutputStream getErrorStream() {
        return this.err;
    }

    public SshCommandFactory.CommandLine getCmdLine() {
        return this.cmdLine;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public ServerSession getSession() {
        return this.session;
    }

    public void setSession(ServerSession session) {
        this.session = session;
    }

    @CheckForNull
    protected User getCurrentUser() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && jenkins.isUseSecurity()) {
            return User.get((String)this.getSession().getUsername());
        }
        return null;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void start(Environment env) throws IOException {
        this.environment = env;
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int i;
                    SecurityContext old = SecurityContextHolder.getContext();
                    User user = AsynchronousCommand.this.getCurrentUser();
                    if (user != null) {
                        ACL.impersonate((Authentication)user.impersonate());
                    }
                    try {
                        i = AsynchronousCommand.this.run();
                    }
                    finally {
                        AsynchronousCommand.this.out.flush();
                        AsynchronousCommand.this.err.flush();
                        SecurityContextHolder.setContext((SecurityContext)old);
                    }
                    AsynchronousCommand.this.callback.onExit(i);
                }
                catch (Exception e) {
                    PrintWriter ps = new PrintWriter(new OutputStreamWriter(AsynchronousCommand.this.err, Charset.defaultCharset()));
                    e.printStackTrace(ps);
                    ps.flush();
                    AsynchronousCommand.this.callback.onExit(255, e.getMessage());
                }
            }
        });
        this.thread.setName("SSH command: " + this.cmdLine.getSingleLine());
        this.thread.start();
    }

    protected abstract int run() throws Exception;

    public void destroy() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }
}

