/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.sshd;

import hudson.model.User;
import java.security.PublicKey;
import java.util.logging.Logger;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.jenkinsci.main.modules.cli.auth.ssh.PublicKeySignatureWriter;
import org.jenkinsci.main.modules.cli.auth.ssh.UserPropertyImpl;

class PublicKeyAuthenticatorImpl
implements PublickeyAuthenticator {
    private final PublicKeySignatureWriter signatureWriter = new PublicKeySignatureWriter();
    private static final Logger LOGGER = Logger.getLogger(PublicKeyAuthenticatorImpl.class.getName());

    PublicKeyAuthenticatorImpl() {
    }

    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        LOGGER.fine("Authentication attempted from " + username + " with " + key);
        User u = User.get((String)username, (boolean)false);
        if (u == null) {
            LOGGER.fine("No such user exists: " + username);
            return false;
        }
        UserPropertyImpl sshKey = (UserPropertyImpl)u.getProperty(UserPropertyImpl.class);
        if (sshKey == null) {
            LOGGER.fine("No SSH key registered for user: " + username);
            return false;
        }
        String signature = this.signatureWriter.asString(key);
        if (!sshKey.isAuthorizedKey(signature)) {
            LOGGER.fine("Key signature didn't match for the user: " + username + " : " + signature);
            return false;
        }
        return true;
    }
}

