/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.instance_identity.pem;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.UnrecoverableKeyException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.bouncycastle.api.PEMEncodable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class PEMHelper {
    private static final Logger LOGGER = Logger.getLogger(PEMHelper.class.getName());

    @NonNull
    public static KeyPair decodePEM(@NonNull String pem) throws IOException {
        try {
            PEMEncodable decode = PEMEncodable.decode((String)pem);
            KeyPair keyPair = decode.toKeyPair();
            if (keyPair != null) {
                return keyPair;
            }
            Object rawObject = decode.getRawObject();
            String received = rawObject != null ? rawObject.getClass().getName() : "null";
            LOGGER.log(Level.SEVERE, "Error reading private key, obtained unexpected result. Received {0} when expecting {1}", new Object[]{received, RSAPrivateCrtKey.class.getName()});
            throw new IOException("Error reading private key, obtained unexpected result.");
        }
        catch (UnrecoverableKeyException e) {
            LOGGER.log(Level.SEVERE, "Error reading private key, obtained unexpected result.", e);
            throw new IOException("Error reading private key, obtained unexpected result.");
        }
    }

    @NonNull
    public static String encodePEM(@NonNull KeyPair keys) throws IOException {
        try {
            PEMEncodable pemEncodable = PEMEncodable.create((Key)keys.getPrivate());
            return pemEncodable.encode();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error writing private key, obtained unexpected result.", e);
            throw new IOException("Error writing private key, obtained unexpected result.");
        }
    }
}

