/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.instance_identity;

import hudson.FilePath;
import hudson.Util;
import hudson.model.PageDecorator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.CryptoConfidentialKey;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.jenkinsci.main.modules.instance_identity.PageDecoratorImpl;

public class InstanceIdentity {
    private final KeyPair keys;
    private static final CryptoConfidentialKey KEY = new CryptoConfidentialKey(InstanceIdentity.class, "KEY");
    private static final Logger LOGGER = Logger.getLogger(InstanceIdentity.class.getName());

    public InstanceIdentity() throws IOException {
        this(new File(Jenkins.getInstance().getRootDir(), "identity.key.enc"), new File(Jenkins.getInstance().getRootDir(), "identity.key"));
    }

    public InstanceIdentity(File keyFile) throws IOException {
        this(keyFile, null);
    }

    InstanceIdentity(File keyFile, File oldKeyFile) throws IOException {
        KeyPairGenerator gen;
        try {
            gen = KeyPairGenerator.getInstance("RSA");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        if (oldKeyFile != null && oldKeyFile.exists()) {
            this.keys = InstanceIdentity.read(null, oldKeyFile, gen);
            InstanceIdentity.write(this.keys, keyFile);
            Util.deleteFile((File)oldKeyFile);
        } else {
            KeyPair tempKeys = InstanceIdentity.read(keyFile, null, gen);
            if (tempKeys != null) {
                this.keys = tempKeys;
            } else {
                gen.initialize(2048, new SecureRandom());
                this.keys = gen.generateKeyPair();
                InstanceIdentity.write(this.keys, keyFile);
            }
        }
    }

    private static KeyPair read(File keyFile, File oldKeyFile, KeyPairGenerator gen) throws IOException {
        KeyPair keyPair = null;
        String provider = gen.getProvider().getName();
        if (keyFile != null) {
            try {
                byte[] enc = FileUtils.readFileToByteArray((File)keyFile);
                StringReader in = new StringReader(new String(KEY.decrypt().doFinal(enc), "UTF-8"));
                PEMParser r = new PEMParser((Reader)in);
                Object o = r.readObject();
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(provider);
                keyPair = converter.getKeyPair((PEMKeyPair)o);
            }
            catch (FileNotFoundException e) {
                LOGGER.fine("identity.key.enc doesn't exist. New Identity.key.enc will be generated");
                return null;
            }
            catch (GeneralSecurityException x) {
                LOGGER.log(Level.SEVERE, "identity.key.enc is corrupted. Identity.key.enc will be deleted and a new one will be generated", x);
                return null;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "failed to access identity.key.enc. Identity.key.enc will be deleted and a new one will be generated", e);
                return null;
            }
        } else if (oldKeyFile != null) {
            FileReader in = new FileReader(oldKeyFile);
            PEMParser r = new PEMParser((Reader)in);
            Object o = r.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(provider);
            keyPair = converter.getKeyPair((PEMKeyPair)o);
        }
        return keyPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(KeyPair keys, File keyFile) throws IOException {
        StringWriter sw = new StringWriter();
        JcaPEMWriter w = new JcaPEMWriter((Writer)sw);
        try {
            w.writeObject((Object)keys);
        }
        finally {
            w.close();
        }
        FileOutputStream os = new FileOutputStream(keyFile);
        try {
            ((OutputStream)os).write(KEY.encrypt().doFinal(sw.toString().getBytes("UTF-8")));
        }
        catch (GeneralSecurityException x) {
            throw new IOException(x);
        }
        finally {
            ((OutputStream)os).close();
        }
        InstanceIdentity.makeReadOnly(keyFile);
    }

    private static void makeReadOnly(File keyFile) {
        try {
            new FilePath(keyFile).chmod(384);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to make read only: " + keyFile, e);
        }
    }

    public RSAPublicKey getPublic() {
        return (RSAPublicKey)this.keys.getPublic();
    }

    public RSAPrivateKey getPrivate() {
        return (RSAPrivateKey)this.keys.getPrivate();
    }

    public static InstanceIdentity get() {
        return ((PageDecoratorImpl)((Object)Jenkins.getInstance().getExtensionList(PageDecorator.class).get(PageDecoratorImpl.class))).identity;
    }
}

