/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.instance_identity;

import hudson.FilePath;
import hudson.Util;
import hudson.model.PageDecorator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.CryptoConfidentialKey;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.jenkinsci.main.modules.instance_identity.PageDecoratorImpl;

public class InstanceIdentity {
    private final KeyPair keys;
    private static final CryptoConfidentialKey KEY = new CryptoConfidentialKey(InstanceIdentity.class, "KEY");
    private static final Logger LOGGER = Logger.getLogger(InstanceIdentity.class.getName());

    public InstanceIdentity() throws IOException {
        this(new File(Jenkins.getInstance().getRootDir(), "identity.key.enc"), new File(Jenkins.getInstance().getRootDir(), "identity.key"));
    }

    public InstanceIdentity(File keyFile) throws IOException {
        this(keyFile, null);
    }

    InstanceIdentity(File keyFile, File oldKeyFile) throws IOException {
        KeyPairGenerator gen;
        try {
            gen = KeyPairGenerator.getInstance("RSA");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        if (oldKeyFile.exists()) {
            this.keys = InstanceIdentity.read(new FileReader(oldKeyFile), gen);
            InstanceIdentity.write(this.keys, keyFile);
            Util.deleteFile((File)oldKeyFile);
        } else if (keyFile.exists()) {
            StringReader in;
            byte[] enc = FileUtils.readFileToByteArray((File)keyFile);
            try {
                in = new StringReader(new String(KEY.decrypt().doFinal(enc), "UTF-8"));
            }
            catch (GeneralSecurityException x) {
                throw new IOException(x);
            }
            this.keys = InstanceIdentity.read(in, gen);
        } else {
            gen.initialize(2048, new SecureRandom());
            this.keys = gen.generateKeyPair();
            InstanceIdentity.write(this.keys, keyFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyPair read(Reader in, KeyPairGenerator gen) throws IOException {
        String provider = gen.getProvider().getName();
        try {
            KeyPair keyPair = (KeyPair)new PEMReader(in, null, provider).readObject();
            return keyPair;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(KeyPair keys, File keyFile) throws IOException {
        StringWriter sw = new StringWriter();
        PEMWriter w = new PEMWriter((Writer)sw, "SunJCE");
        try {
            w.writeObject((Object)keys);
        }
        finally {
            w.close();
        }
        FileOutputStream os = new FileOutputStream(keyFile);
        try {
            ((OutputStream)os).write(KEY.encrypt().doFinal(sw.toString().getBytes("UTF-8")));
        }
        catch (GeneralSecurityException x) {
            throw new IOException(x);
        }
        finally {
            ((OutputStream)os).close();
        }
        InstanceIdentity.makeReadOnly(keyFile);
    }

    private static void makeReadOnly(File keyFile) {
        try {
            new FilePath(keyFile).chmod(384);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to make read only: " + keyFile, e);
        }
    }

    public RSAPublicKey getPublic() {
        return (RSAPublicKey)this.keys.getPublic();
    }

    public RSAPrivateKey getPrivate() {
        return (RSAPrivateKey)this.keys.getPrivate();
    }

    public static InstanceIdentity get() {
        return ((PageDecoratorImpl)((Object)Jenkins.getInstance().getExtensionList(PageDecorator.class).get(PageDecoratorImpl.class))).identity;
    }
}

