/*
 * Decompiled with CFR 0.152.
 */
package jenkins.websocket;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import jenkins.websocket.Provider;
import org.eclipse.jetty.ee9.websocket.api.Session;
import org.eclipse.jetty.ee9.websocket.api.WebSocketListener;
import org.eclipse.jetty.ee9.websocket.api.WriteCallback;
import org.eclipse.jetty.ee9.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.ee9.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.ee9.websocket.server.JettyWebSocketServerContainer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class Jetty12EE9Provider
implements Provider {
    private static long IDLE_TIMEOUT_SECONDS = Long.getLong("jenkins.websocket.idleTimeout", 60L);
    private static final String ATTR_LISTENER = Jetty12EE9Provider.class.getName() + ".listener";
    private boolean initialized = false;

    public Jetty12EE9Provider() {
        JettyWebSocketServerContainer.class.hashCode();
    }

    private void init(HttpServletRequest req) {
        if (!this.initialized) {
            JettyWebSocketServerContainer.getContainer((ServletContext)req.getServletContext()).setIdleTimeout(Duration.ofSeconds(IDLE_TIMEOUT_SECONDS));
            this.initialized = true;
        }
    }

    public Provider.Handler handle(HttpServletRequest req, HttpServletResponse rsp, final Provider.Listener listener) throws Exception {
        this.init(req);
        req.setAttribute(ATTR_LISTENER, (Object)listener);
        if (!"websocket".equalsIgnoreCase(req.getHeader("Upgrade"))) {
            rsp.sendError(400, "only WS connections accepted here");
            return null;
        }
        if (!JettyWebSocketServerContainer.getContainer((ServletContext)req.getServletContext()).upgrade(Jetty12EE9Provider::createWebSocket, req, rsp)) {
            rsp.sendError(400, "did not manage to upgrade");
            return null;
        }
        return new Provider.Handler(){

            public Future<Void> sendBinary(ByteBuffer data) throws IOException {
                CompletableFuture<Void> f = new CompletableFuture<Void>();
                this.session().getRemote().sendBytes(data, (WriteCallback)new WriteCallbackImpl(f));
                return f;
            }

            public Future<Void> sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
                CompletableFuture<Void> f = new CompletableFuture<Void>();
                this.session().getRemote().sendPartialBytes(partialByte, isLast, (WriteCallback)new WriteCallbackImpl(f));
                return f;
            }

            public Future<Void> sendText(String text) throws IOException {
                CompletableFuture<Void> f = new CompletableFuture<Void>();
                this.session().getRemote().sendString(text, (WriteCallback)new WriteCallbackImpl(f));
                return f;
            }

            public Future<Void> sendPing(ByteBuffer applicationData) throws IOException {
                CompletableFuture<Void> f = new CompletableFuture<Void>();
                this.session().getRemote().sendPing(applicationData, (WriteCallback)new WriteCallbackImpl(f));
                return f;
            }

            public void close() throws IOException {
                this.session().close();
            }

            private Session session() {
                Session session = (Session)listener.getProviderSession();
                if (session == null) {
                    throw new IllegalStateException("missing session");
                }
                return session;
            }
        };
    }

    private static Object createWebSocket(JettyServerUpgradeRequest req, JettyServerUpgradeResponse resp) {
        final Provider.Listener listener = (Provider.Listener)req.getHttpServletRequest().getAttribute(ATTR_LISTENER);
        if (listener == null) {
            throw new IllegalStateException("missing listener attribute");
        }
        return new WebSocketListener(){

            public void onWebSocketBinary(byte[] payload, int offset, int length) {
                listener.onWebSocketBinary(payload, offset, length);
            }

            public void onWebSocketText(String message) {
                listener.onWebSocketText(message);
            }

            public void onWebSocketClose(int statusCode, String reason) {
                listener.onWebSocketClose(statusCode, reason);
            }

            public void onWebSocketConnect(Session session) {
                listener.onWebSocketConnect((Object)session);
            }

            public void onWebSocketError(Throwable cause) {
                listener.onWebSocketError(cause);
            }
        };
    }

    private static final class WriteCallbackImpl
    implements WriteCallback {
        private final CompletableFuture<Void> f;

        WriteCallbackImpl(CompletableFuture<Void> f) {
            this.f = f;
        }

        public void writeSuccess() {
            this.f.complete(null);
        }

        public void writeFailed(Throwable x) {
            this.f.completeExceptionally(x);
        }
    }
}

