/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol.cert;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@IgnoreJRERequirement
public class BlindTrustX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private static void validateAuthType(String authType) {
        if (authType == null) {
            throw new IllegalArgumentException("authType must not be null");
        }
        if (authType.isEmpty()) {
            throw new IllegalArgumentException("authType must not be zero-length");
        }
    }

    private static void validateChain(X509Certificate[] chain) {
        if (chain == null) {
            throw new IllegalArgumentException("chain must not be null");
        }
        if (chain.length == 0) {
            throw new IllegalArgumentException("chain must not be zero-length");
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        BlindTrustX509ExtendedTrustManager.validateAuthType(authType);
        BlindTrustX509ExtendedTrustManager.validateChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        BlindTrustX509ExtendedTrustManager.validateAuthType(authType);
        BlindTrustX509ExtendedTrustManager.validateChain(chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        BlindTrustX509ExtendedTrustManager.validateAuthType(authType);
        BlindTrustX509ExtendedTrustManager.validateChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        BlindTrustX509ExtendedTrustManager.validateAuthType(authType);
        BlindTrustX509ExtendedTrustManager.validateChain(chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        BlindTrustX509ExtendedTrustManager.validateAuthType(authType);
        BlindTrustX509ExtendedTrustManager.validateChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        BlindTrustX509ExtendedTrustManager.validateAuthType(authType);
        BlindTrustX509ExtendedTrustManager.validateChain(chain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

