/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.jenkinsci.remoting.org.apache.commons.net.util.SubnetUtils;
import org.jenkinsci.remoting.org.apache.commons.validator.routines.InetAddressValidator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class NoProxyEvaluator {
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern PIPE = Pattern.compile("\\|");
    private final Set<InetAddress> noProxyIpAddresses = new HashSet<InetAddress>();
    private final Set<SubnetUtils.SubnetInfo> noProxySubnets = new HashSet<SubnetUtils.SubnetInfo>();
    private final Set<String> noProxyDomainsHosts = new HashSet<String>();

    public static boolean shouldProxy(String host) {
        NoProxyEvaluator evaluator = new NoProxyEvaluator(NoProxyEvaluator.getEnvironmentValue());
        return evaluator.shouldProxyHost(host);
    }

    NoProxyEvaluator(String noProxySpecification) {
        if (noProxySpecification != null) {
            this.processSpecificationsIntoTypes(noProxySpecification);
        }
    }

    boolean shouldProxyHost(String host) {
        if (host.toLowerCase(Locale.ROOT).equals("localhost")) {
            return false;
        }
        if (this.isIpAddress(host)) {
            try {
                InetAddress hostAddress = InetAddress.getByName(host);
                if (hostAddress.isLoopbackAddress()) {
                    return false;
                }
                if (this.matchesIpAddress(hostAddress)) {
                    return false;
                }
                return !this.matchesSubnet(host);
            }
            catch (UnknownHostException e) {
                return true;
            }
        }
        return !this.matchesDomainHost(host);
    }

    private static String getEnvironmentValue() {
        String noProxy = System.getenv("no_proxy");
        if (noProxy == null) {
            noProxy = System.getenv("NO_PROXY");
        }
        return noProxy;
    }

    private boolean matchesIpAddress(InetAddress hostAddress) {
        return this.noProxyIpAddresses.stream().anyMatch(inetAddress -> inetAddress.equals(hostAddress));
    }

    private void processSpecificationsIntoTypes(String noProxySpecification) {
        String[] noProxySpecifications;
        noProxySpecification = noProxySpecification.trim();
        for (String specification : noProxySpecifications = this.splitComponents(noProxySpecification)) {
            if ((specification = this.stripLeadingStarDot(this.stripLeadingDot(specification.trim()))).isEmpty()) continue;
            if (this.isIpAddress(specification)) {
                try {
                    this.noProxyIpAddresses.add(InetAddress.getByName(specification));
                }
                catch (UnknownHostException unknownHostException) {}
                continue;
            }
            try {
                SubnetUtils subnetUtils = new SubnetUtils(specification);
                SubnetUtils.SubnetInfo subnetInfo = subnetUtils.getInfo();
                this.noProxySubnets.add(subnetInfo);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.noProxyDomainsHosts.add(specification);
            }
        }
    }

    private String[] splitComponents(String noProxySpecification) {
        String[] noProxySpecifications = noProxySpecification.contains(",") ? COMMA.split(noProxySpecification) : (noProxySpecification.contains("|") ? PIPE.split(noProxySpecification) : new String[]{noProxySpecification});
        return noProxySpecifications;
    }

    private String stripLeadingDot(String string) {
        return string.startsWith(".") ? string.substring(1) : string;
    }

    private String stripLeadingStarDot(String string) {
        return string.startsWith("*.") ? string.substring(2) : string;
    }

    private boolean matchesSubnet(String host) {
        return this.noProxySubnets.stream().anyMatch(subnet -> subnet.isInRange(host));
    }

    private boolean matchesDomainHost(String host) {
        return this.noProxyDomainsHosts.stream().anyMatch(host::endsWith);
    }

    private boolean isIpAddress(String host) {
        return InetAddressValidator.getInstance().isValid(host);
    }
}

