/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.ErrorPropagatingOutputStream;
import hudson.remoting.ReferenceCountRecorder;
import hudson.remoting.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.meta.When;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

final class ExportTable {
    private final Map<Integer, Entry<?>> table = new HashMap();
    private final Map<Object, Entry<?>> reverse = new HashMap();
    private final ThreadLocal<ExportList> lists = new ThreadLocal();
    private final List<Entry<?>> unexportLog = new LinkedList();
    private int iota = 1;
    public static int UNEXPORT_LOG_SIZE = Integer.getInteger(ExportTable.class.getName() + ".unexportLogSize", 1024);
    private static final Logger LOGGER = Logger.getLogger(ExportTable.class.getName());

    ExportTable() {
    }

    ExportList startRecording() {
        ExportList el = new ExportList();
        this.lists.set(el);
        return el;
    }

    boolean isRecording() {
        return this.lists.get() != null;
    }

    synchronized <T> int export(@Nonnull Class<T> clazz, @CheckForNull T t) {
        return this.export(clazz, t, true);
    }

    synchronized <T> int export(@Nonnull Class<T> clazz, @CheckForNull T t, boolean notifyListener) {
        ExportList l;
        if (t == null) {
            return 0;
        }
        Entry<Object> e = this.reverse.get(t);
        if (e == null) {
            e = new Entry<T>(t, clazz);
        } else {
            e.addInterface(clazz);
        }
        e.addRef();
        if (notifyListener && (l = this.lists.get()) != null) {
            l.add(e);
        }
        return e.id;
    }

    synchronized void pin(@Nonnull Object t) {
        Entry<?> e = this.reverse.get(t);
        if (e != null) {
            e.pin();
        }
    }

    @Nonnull
    synchronized Object get(int id) throws ExecutionException {
        Entry<?> e = this.table.get(id);
        if (e != null) {
            return ((Entry)e).object;
        }
        throw this.diagnoseInvalidObjectId(id);
    }

    @CheckForNull
    synchronized Object getOrNull(int oid) {
        Entry<?> e = this.table.get(oid);
        if (e != null) {
            return ((Entry)e).object;
        }
        return null;
    }

    @Nonnull
    synchronized Class[] type(int id) throws ExecutionException {
        Entry<?> e = this.table.get(id);
        if (e != null) {
            return e.getInterfaces();
        }
        throw this.diagnoseInvalidObjectId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort(@CheckForNull Throwable e) {
        ArrayList values;
        Object object = this;
        synchronized (object) {
            values = new ArrayList(this.table.values());
        }
        for (Entry entry : values) {
            if (!(entry.object instanceof ErrorPropagatingOutputStream)) continue;
            try {
                ((ErrorPropagatingOutputStream)entry.object).error(e);
            }
            catch (Throwable x) {
                LOGGER.log(Level.INFO, "Failed to propagate a channel termination error", x);
            }
        }
        object = this;
        synchronized (object) {
            this.table.clear();
            this.reverse.clear();
        }
    }

    @Nonnull
    private synchronized ExecutionException diagnoseInvalidObjectId(int id) {
        Exception cause = null;
        if (!this.unexportLog.isEmpty()) {
            for (Entry<?> e : this.unexportLog) {
                if (e.id != id) continue;
                cause = new Exception("Object was recently deallocated\n" + Util.indent(e.dump()), e.releaseTrace);
            }
            if (cause == null) {
                ReleasedAt releasedAt = this.unexportLog.get((int)0).releaseTrace;
                Date releasedBefore = releasedAt != null ? new Date(releasedAt.timestamp) : new Date();
                cause = new Exception("Object appears to be deallocated at lease before " + releasedBefore);
            }
        }
        return new ExecutionException("Invalid object ID " + id + " iota=" + this.iota, cause);
    }

    synchronized void unexport(@CheckForNull Object t, Throwable callSite) {
        if (t == null) {
            return;
        }
        Entry<?> e = this.reverse.get(t);
        if (e == null) {
            LOGGER.log(Level.SEVERE, "Trying to unexport an object that's not exported: " + t);
            return;
        }
        e.release(callSite);
    }

    void unexportByOid(Integer oid, Throwable callSite) {
        this.unexportByOid(oid, callSite, false);
    }

    synchronized void unexportByOid(@CheckForNull Integer oid, @CheckForNull Throwable callSite, boolean severeErrorIfMissing) {
        if (oid == null) {
            return;
        }
        Entry<?> e = this.table.get(oid);
        if (e == null) {
            Level loggingLevel = severeErrorIfMissing ? Level.SEVERE : Level.FINE;
            LOGGER.log(loggingLevel, "Trying to unexport an object that's already unexported", this.diagnoseInvalidObjectId(oid));
            if (callSite != null) {
                LOGGER.log(loggingLevel, "2nd unexport attempt is here", callSite);
            }
            return;
        }
        e.release(callSite);
    }

    synchronized void dump(@Nonnull PrintWriter w) throws IOException {
        for (Entry<?> e : this.table.values()) {
            e.dump(w);
        }
    }

    synchronized boolean isExported(Object o) {
        return this.reverse.containsKey(o);
    }

    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"SE_BAD_FIELD_INNER_CLASS"}, justification="ExportList is supposed to be serializable as ArrayList, but it is not. The issue is ignored since the class does not belong to the public API")
    public final class ExportList
    extends ArrayList<Entry> {
        private final ExportList old;
        private static final long serialVersionUID = 1L;

        private ExportList() {
            this.old = (ExportList)ExportTable.this.lists.get();
            ExportTable.this.lists.set(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release(Throwable callSite) {
            ExportTable exportTable = ExportTable.this;
            synchronized (exportTable) {
                for (Entry e : this) {
                    e.release(callSite);
                }
            }
        }

        void stopRecording() {
            ExportTable.this.lists.set(this.old);
        }
    }

    static class ReleasedAt
    extends Source {
        ReleasedAt(@CheckForNull Throwable callSite) {
            super(callSite);
        }

        @Override
        public String toString() {
            return "  Released at " + new Date(this.timestamp);
        }
    }

    static class CreatedAt
    extends Source {
        CreatedAt() {
            super((Throwable)null);
        }

        @Override
        public String toString() {
            return "  Created at " + new Date(this.timestamp);
        }
    }

    static class Source
    extends Exception {
        protected final long timestamp = System.currentTimeMillis();

        Source(@CheckForNull Throwable callSite) {
            super(callSite);
            this.updateOurStackTraceCache();
        }

        @CheckReturnValue(when=When.NEVER)
        protected final StackTraceElement[] updateOurStackTraceCache() {
            return this.getStackTrace();
        }
    }

    private final class Entry<T> {
        final int id;
        private Class<? super T>[] interfaces;
        private T object;
        @Nonnull
        private final String objectType;
        @Nonnull
        final CreatedAt allocationTrace;
        @CheckForNull
        ReleasedAt releaseTrace;
        private int referenceCount;
        @CheckForNull
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Old System script magic")
        private ReferenceCountRecorder recorder;

        Entry(T object, Class<? super T> ... interfaces) {
            this.id = ExportTable.this.iota++;
            this.interfaces = (Class[])interfaces.clone();
            this.object = object;
            this.objectType = object.getClass().getName();
            this.allocationTrace = new CreatedAt();
            ExportTable.this.table.put(this.id, this);
            ExportTable.this.reverse.put(object, this);
        }

        void addRef() {
            ++this.referenceCount;
            if (this.recorder != null) {
                this.recorder.onAddRef(null);
            }
        }

        void pin() {
            if (this.referenceCount < 0x20000000) {
                this.referenceCount += 0x40000000;
            }
        }

        void release(@CheckForNull Throwable callSite) {
            if (this.recorder != null) {
                this.recorder.onRelease(callSite);
            }
            if (--this.referenceCount == 0) {
                ExportTable.this.table.remove(this.id);
                ExportTable.this.reverse.remove(this.object);
                this.object = null;
                this.releaseTrace = new ReleasedAt(callSite);
                ExportTable.this.unexportLog.add(this);
                while (ExportTable.this.unexportLog.size() > UNEXPORT_LOG_SIZE) {
                    ExportTable.this.unexportLog.remove(0);
                }
            }
        }

        private String interfaceNames() {
            StringBuilder buf = new StringBuilder(10 + this.getInterfaces().length * 128);
            String sep = "[";
            for (Class<T> clazz : this.getInterfaces()) {
                buf.append(sep).append(clazz.getName());
                sep = ", ";
            }
            buf.append("]");
            return buf.toString();
        }

        void dump(PrintWriter w) throws IOException {
            w.printf("#%d (ref.%d) : object=%s type=%s interfaces=%s%n", this.id, this.referenceCount, this.object, this.objectType, this.interfaceNames());
            this.allocationTrace.printStackTrace(w);
            if (this.releaseTrace != null) {
                this.releaseTrace.printStackTrace(w);
            }
            if (this.recorder != null) {
                this.recorder.dump(w);
            }
        }

        String dump() {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                this.dump(pw);
                pw.close();
                return sw.toString();
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }

        synchronized Class<? super T>[] getInterfaces() {
            return this.interfaces;
        }

        synchronized void setInterfaces(Class<? super T>[] interfaces) {
            this.interfaces = interfaces;
        }

        synchronized void addInterface(Class<? super T> clazz) {
            for (Class<T> clazz2 : this.interfaces) {
                if (!clazz2.equals(clazz)) continue;
                return;
            }
            Class[] replacement = new Class[this.interfaces.length + 1];
            System.arraycopy(this.interfaces, 0, replacement, 0, this.interfaces.length);
            replacement[this.interfaces.length] = clazz;
            this.interfaces = replacement;
        }
    }
}

