/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Checksum;
import hudson.remoting.JarCacheSupport;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class FileSystemJarCache
extends JarCacheSupport {
    public final File rootDir;
    private final boolean touch;
    private final Set<Checksum> notified = Collections.synchronizedSet(new HashSet());
    private static final Logger LOGGER = Logger.getLogger(FileSystemJarCache.class.getName());

    public FileSystemJarCache(File rootDir, boolean touch) {
        this.rootDir = rootDir;
        this.touch = touch;
        if (rootDir == null) {
            throw new IllegalArgumentException();
        }
        try {
            Util.mkdirs(rootDir);
        }
        catch (IOException ex) {
            throw new RuntimeException("Root directory not writable");
        }
    }

    @Override
    protected URL lookInCache(Channel channel, long sum1, long sum2) throws IOException, InterruptedException {
        File jar = this.map(sum1, sum2);
        if (jar.exists()) {
            LOGGER.log(Level.FINER, String.format("Jar file cache hit %16X%16X", sum1, sum2));
            if (this.touch) {
                jar.setLastModified(System.currentTimeMillis());
            }
            if (this.notified.add(new Checksum(sum1, sum2))) {
                this.getJarLoader(channel).notifyJarPresence(sum1, sum2);
            }
            return jar.toURI().toURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URL retrieve(Channel channel, long sum1, long sum2) throws IOException, InterruptedException {
        URL uRL;
        File target = this.map(sum1, sum2);
        if (target.exists()) {
            LOGGER.fine(String.format("Jar file already exists: %16X%16X", sum1, sum2));
            return target.toURI().toURL();
        }
        File tmp = this.createTempJar(target);
        try {
            RemoteOutputStream o = new RemoteOutputStream(new FileOutputStream(tmp));
            try {
                LOGGER.log(Level.FINE, String.format("Retrieving jar file %16X%16X", sum1, sum2));
                this.getJarLoader(channel).writeJarTo(sum1, sum2, o);
            }
            finally {
                o.close();
            }
            Checksum expected = new Checksum(sum1, sum2);
            Checksum actual = Checksum.forFile(tmp);
            if (!expected.equals(actual)) {
                throw new IOException(String.format("Incorrect checksum of retrieved jar: %s%nExpected: %s%nActual: %s", tmp.getAbsolutePath(), expected, actual));
            }
            if (!tmp.renameTo(target)) {
                if (!target.exists()) {
                    throw new IOException("Unable to create " + target + " from " + tmp);
                }
                actual = Checksum.forFile(target);
                if (!expected.equals(actual)) {
                    throw new IOException(String.format("Incorrect checksum of previous jar: %s%nExpected: %s%nActual: %s", target.getAbsolutePath(), expected, actual));
                }
            }
            uRL = target.toURI().toURL();
            tmp.delete();
        }
        catch (Throwable throwable) {
            try {
                tmp.delete();
                throw throwable;
            }
            catch (IOException e) {
                throw (IOException)new IOException("Failed to write to " + target).initCause(e);
            }
        }
        return uRL;
    }

    File createTempJar(@Nonnull File target) throws IOException {
        File parent = target.getParentFile();
        Util.mkdirs(parent);
        return File.createTempFile(target.getName(), "tmp", parent);
    }

    File map(long sum1, long sum2) {
        return new File(this.rootDir, String.format("%02X/%014X%016X.jar", (int)(sum1 >>> 56), sum1 & 0xFFFFFFFFFFFFFFL, sum2));
    }
}

