/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.EngineListener;
import hudson.remoting.EngineListenerSplitter;
import hudson.remoting.FileSystemJarCache;
import hudson.remoting.JarCache;
import hudson.remoting.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.jenkinsci.remoting.engine.EngineUtil;
import org.jenkinsci.remoting.engine.JnlpProtocol;
import org.jenkinsci.remoting.engine.JnlpProtocolFactory;

@NotThreadSafe
public class Engine
extends Thread {
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(final Runnable r) {
            Thread t = this.defaultFactory.newThread(new Runnable(){

                @Override
                public void run() {
                    CURRENT.set(Engine.this);
                    r.run();
                }
            });
            t.setDaemon(true);
            return t;
        }
    });
    @Deprecated
    public final EngineListener listener;
    private final EngineListenerSplitter events = new EngineListenerSplitter();
    private List<URL> candidateUrls;
    private List<X509Certificate> candidateCertificates;
    private URL hudsonUrl;
    private final String secretKey;
    public final String slaveName;
    private String credentials;
    private String proxyCredentials = System.getProperty("proxyCredentials");
    private String tunnel;
    private boolean noReconnect;
    private JarCache jarCache = new FileSystemJarCache(new File(System.getProperty("user.home"), ".jenkins/cache/jars"), true);
    private static final ThreadLocal<Engine> CURRENT = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(Engine.class.getName());
    static final int SOCKET_TIMEOUT = Integer.getInteger(Engine.class.getName() + ".socketTimeout", 1800000);
    @Deprecated
    public static final String GREETING_SUCCESS = "Welcome";

    public Engine(EngineListener listener, List<URL> hudsonUrls, String secretKey, String slaveName) {
        this.listener = listener;
        this.events.add(listener);
        this.candidateUrls = hudsonUrls;
        this.secretKey = secretKey;
        this.slaveName = slaveName;
        if (this.candidateUrls.isEmpty()) {
            throw new IllegalArgumentException("No URLs given");
        }
    }

    public void setJarCache(JarCache jarCache) {
        this.jarCache = jarCache;
    }

    public URL getHudsonUrl() {
        return this.hudsonUrl;
    }

    public void setTunnel(String tunnel) {
        this.tunnel = tunnel;
    }

    public void setCredentials(String creds) {
        this.credentials = creds;
    }

    public void setProxyCredentials(String proxyCredentials) {
        this.proxyCredentials = proxyCredentials;
    }

    public void setNoReconnect(boolean noReconnect) {
        this.noReconnect = noReconnect;
    }

    public void setCandidateCertificates(List<X509Certificate> candidateCertificates) {
        this.candidateCertificates = candidateCertificates == null ? null : new ArrayList<X509Certificate>(candidateCertificates);
    }

    public void addCandidateCertificate(X509Certificate certificate) {
        if (this.candidateCertificates == null) {
            this.candidateCertificates = new ArrayList<X509Certificate>();
        }
        this.candidateCertificates.add(certificate);
    }

    public void addListener(EngineListener el) {
        this.events.add(el);
    }

    public void removeListener(EngineListener el) {
        this.events.remove(el);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<JnlpProtocol> protocols = JnlpProtocolFactory.createProtocols(this.secretKey, this.slaveName, this.events);
        try {
            boolean first = true;
            while (true) {
                if (first) {
                    first = false;
                } else if (this.noReconnect) {
                    return;
                }
                this.events.status("Locating server among " + this.candidateUrls);
                Throwable firstError = null;
                String host = null;
                String port = null;
                HashSet<String> agentProtocolNames = null;
                SSLSocketFactory sslSocketFactory = this.getSSLSocketFactory();
                for (URL url : this.candidateUrls) {
                    block33: {
                        String s = url.toExternalForm();
                        if (!s.endsWith("/")) {
                            s = s + '/';
                        }
                        URL salURL = new URL(s + "tcpSlaveAgentListener/");
                        HttpURLConnection con = (HttpURLConnection)Util.openURLConnection(salURL, this.credentials, this.proxyCredentials, sslSocketFactory);
                        try {
                            con.setConnectTimeout(30000);
                            con.setReadTimeout(60000);
                            con.connect();
                        }
                        catch (IOException x) {
                            if (firstError == null) {
                                firstError = new IOException("Failed to connect to " + salURL + ": " + x.getMessage()).initCause(x);
                            }
                            con.disconnect();
                            continue;
                        }
                        try {
                            String names;
                            port = con.getHeaderField("X-Hudson-JNLP-Port");
                            if (con.getResponseCode() != 200) {
                                if (firstError != null) continue;
                                firstError = new Exception(salURL + " is invalid: " + con.getResponseCode() + " " + con.getResponseMessage());
                                continue;
                            }
                            if (port == null) {
                                if (firstError != null) continue;
                                firstError = new Exception(url + " is not Jenkins");
                                continue;
                            }
                            host = con.getHeaderField("X-Jenkins-JNLP-Host");
                            if (host == null) {
                                host = url.getHost();
                            }
                            if ((names = con.getHeaderField("X-Jenkins-Agent-Protocols")) == null) break block33;
                            agentProtocolNames = new HashSet<String>();
                            for (String name : names.split(",")) {
                                if ((name = name.trim()).isEmpty()) continue;
                                agentProtocolNames.add(name);
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            con.disconnect();
                            continue;
                        }
                    }
                    this.hudsonUrl = url;
                    firstError = null;
                    this.candidateUrls = Collections.singletonList(this.hudsonUrl);
                    break;
                }
                if (firstError != null) {
                    this.events.error(firstError);
                    return;
                }
                this.events.status("Handshaking");
                Socket jnlpSocket = this.connect(host, port);
                ChannelBuilder channelBuilder = new ChannelBuilder("channel", this.executor).withJarCache(this.jarCache).withMode(Channel.Mode.BINARY);
                Channel channel = null;
                boolean triedAtLeastOneProtocol = false;
                for (JnlpProtocol protocol : protocols) {
                    if (!protocol.isEnabled()) {
                        this.events.status("Protocol " + protocol.getName() + " is not enabled, skipping");
                        continue;
                    }
                    if (agentProtocolNames != null && !agentProtocolNames.contains(protocol.getName())) {
                        this.events.status("Server reports protocol " + protocol.getName() + " not supported, skipping");
                        continue;
                    }
                    triedAtLeastOneProtocol = true;
                    this.events.status("Trying protocol: " + protocol.getName());
                    try {
                        channel = protocol.establishChannel(jnlpSocket, channelBuilder);
                    }
                    catch (IOException ioe) {
                        this.events.status("Protocol " + protocol.getName() + " failed to establish channel", ioe);
                    }
                    catch (RuntimeException e) {
                        this.events.status("Protocol " + protocol.getName() + " encountered a runtime error", e);
                    }
                    catch (Error e) {
                        this.events.status("Protocol " + protocol.getName() + " could not be completed due to an error", e);
                    }
                    catch (Throwable e) {
                        this.events.status("Protocol " + protocol.getName() + " encountered an unexpected exception", e);
                    }
                    if (channel != null) break;
                    jnlpSocket.close();
                    jnlpSocket = this.connect(host, port);
                }
                if (channel == null) {
                    if (triedAtLeastOneProtocol) {
                        this.onConnectionRejected("None of the protocols were accepted");
                        continue;
                    }
                    this.onConnectionRejected("None of the protocols are enabled");
                    return;
                }
                this.events.status("Connected");
                channel.join();
                this.events.status("Terminated");
                if (this.noReconnect) {
                    return;
                }
                this.events.onDisconnect();
                this.waitForServerToBack();
                this.events.onReconnect();
            }
        }
        catch (Throwable e) {
            this.events.error(e);
            return;
        }
    }

    private void onConnectionRejected(String greeting) throws InterruptedException {
        this.events.error(new Exception("The server rejected the connection: " + greeting));
        Thread.sleep(10000L);
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Unsafe endline symbol is a pert of the protocol. Unsafe to fix it. See TODO below")
    private Socket connect(String host, String port) throws IOException, InterruptedException {
        if (this.tunnel != null) {
            String[] tokens = this.tunnel.split(":", 3);
            if (tokens.length != 2) {
                throw new IOException("Illegal tunneling parameter: " + this.tunnel);
            }
            if (tokens[0].length() > 0) {
                host = tokens[0];
            }
            if (tokens[1].length() > 0) {
                port = tokens[1];
            }
        }
        String msg = "Connecting to " + host + ':' + port;
        this.events.status(msg);
        int retry = 1;
        while (true) {
            boolean isHttpProxy = false;
            InetSocketAddress targetAddress = null;
            try {
                Socket s = null;
                targetAddress = Util.getResolvedHttpProxyAddress(host, Integer.parseInt(port));
                if (targetAddress == null) {
                    targetAddress = new InetSocketAddress(host, Integer.parseInt(port));
                } else {
                    isHttpProxy = true;
                }
                s = new Socket();
                s.connect(targetAddress);
                s.setTcpNoDelay(true);
                s.setSoTimeout(SOCKET_TIMEOUT);
                if (isHttpProxy) {
                    String connectCommand = String.format("CONNECT %s:%s HTTP/1.1\r\nHost: %s\r\n\r\n", host, port, host);
                    s.getOutputStream().write(connectCommand.getBytes("UTF-8"));
                    BufferedInputStream is = new BufferedInputStream(s.getInputStream());
                    String line = EngineUtil.readLine(is);
                    String[] responseLineParts = line.split(" ");
                    if (responseLineParts.length < 2 || !responseLineParts[1].equals("200")) {
                        throw new IOException("Got a bad response from proxy: " + line);
                    }
                    while (!EngineUtil.readLine(is).isEmpty()) {
                    }
                }
                return s;
            }
            catch (IOException e) {
                if (retry++ > 10) {
                    String suffix = "";
                    if (isHttpProxy) {
                        suffix = " through proxy " + targetAddress.toString();
                    }
                    throw new IOException("Failed to connect to " + host + ':' + port + suffix, e);
                }
                Thread.sleep(10000L);
                this.events.status(msg + " (retrying:" + retry + ")", e);
                continue;
            }
            break;
        }
    }

    private void waitForServerToBack() throws InterruptedException {
        Thread t = Thread.currentThread();
        String oldName = t.getName();
        SSLSocketFactory sslSocketFactory = null;
        try {
            sslSocketFactory = this.getSSLSocketFactory();
        }
        catch (Throwable e) {
            this.events.error(e);
        }
        try {
            int retries = 0;
            while (true) {
                HttpURLConnection con;
                block10: {
                    Thread.sleep(10000L);
                    URL url = new URL(this.hudsonUrl, "tcpSlaveAgentListener/");
                    t.setName(oldName + ": trying " + url + " for " + ++retries + " times");
                    con = (HttpURLConnection)Util.openURLConnection(url, this.credentials, this.proxyCredentials, sslSocketFactory);
                    con.setConnectTimeout(5000);
                    con.setReadTimeout(5000);
                    con.connect();
                    if (con.getResponseCode() != 200) break block10;
                    return;
                }
                try {
                    LOGGER.info("Master isn't ready to talk to us. Will retry again: response code=" + con.getResponseCode());
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Failed to connect to the master. Will retry again", e);
                }
            }
        }
        finally {
            t.setName(oldName);
        }
    }

    public static Engine current() {
        return CURRENT.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getCacertsKeyStore() throws PrivilegedActionException, KeyStoreException, NoSuchProviderException, CertificateException, NoSuchAlgorithmException, IOException {
        Map<String, String> properties = AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, String>>(){

            @Override
            public Map<String, String> run() throws Exception {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("trustStore", System.getProperty("javax.net.ssl.trustStore"));
                result.put("javaHome", System.getProperty("java.home"));
                result.put("trustStoreType", System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()));
                result.put("trustStoreProvider", System.getProperty("javax.net.ssl.trustStoreProvider", ""));
                result.put("trustStorePasswd", System.getProperty("javax.net.ssl.trustStorePassword", ""));
                return result;
            }
        });
        KeyStore keystore = null;
        FileInputStream trustStoreStream = null;
        try {
            String trustStore = properties.get("trustStore");
            if (!"NONE".equals(trustStore)) {
                File trustStoreFile;
                if (trustStore != null) {
                    trustStoreFile = new File(trustStore);
                    trustStoreStream = Engine.getFileInputStream(trustStoreFile);
                } else {
                    String javaHome = properties.get("javaHome");
                    trustStoreFile = new File(javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "jssecacerts");
                    trustStoreStream = Engine.getFileInputStream(trustStoreFile);
                    if (trustStoreStream == null) {
                        trustStoreFile = new File(javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts");
                        trustStoreStream = Engine.getFileInputStream(trustStoreFile);
                    }
                }
                trustStore = trustStoreStream != null ? trustStoreFile.getPath() : "No File Available, using empty keystore.";
            }
            String trustStoreType = properties.get("trustStoreType");
            String trustStoreProvider = properties.get("trustStoreProvider");
            LOGGER.log(Level.FINE, "trustStore is: {0}", trustStore);
            LOGGER.log(Level.FINE, "trustStore type is: {0}", trustStoreType);
            LOGGER.log(Level.FINE, "trustStore provider is: {0}", trustStoreProvider);
            if (trustStoreType.length() != 0) {
                LOGGER.log(Level.FINE, "init truststore");
                keystore = trustStoreProvider.length() == 0 ? KeyStore.getInstance(trustStoreType) : KeyStore.getInstance(trustStoreType, trustStoreProvider);
                char[] trustStorePasswdChars = null;
                String trustStorePasswd = properties.get("trustStorePasswd");
                if (trustStorePasswd.length() != 0) {
                    trustStorePasswdChars = trustStorePasswd.toCharArray();
                }
                keystore.load(trustStoreStream, trustStorePasswdChars);
                if (trustStorePasswdChars != null) {
                    for (int i = 0; i < trustStorePasswdChars.length; ++i) {
                        trustStorePasswdChars[i] = '\u0000';
                    }
                }
            }
        }
        finally {
            if (trustStoreStream != null) {
                trustStoreStream.close();
            }
        }
        return keystore;
    }

    @CheckForNull
    private static FileInputStream getFileInputStream(final File file) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws Exception {
                try {
                    return file.exists() ? new FileInputStream(file) : null;
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
        });
    }

    private SSLSocketFactory getSSLSocketFactory() throws PrivilegedActionException, KeyStoreException, NoSuchProviderException, CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException {
        SSLSocketFactory sslSocketFactory = null;
        if (this.candidateCertificates != null && !this.candidateCertificates.isEmpty()) {
            KeyStore keyStore = Engine.getCacertsKeyStore();
            keyStore.load(null, null);
            int i = 0;
            for (X509Certificate c : this.candidateCertificates) {
                keyStore.setCertificateEntry(String.format("alias-%d", i++), c);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, trustManagerFactory.getTrustManagers(), null);
            sslSocketFactory = ctx.getSocketFactory();
        }
        return sslSocketFactory;
    }
}

