/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.remoting.BinarySafeStream;
import hudson.remoting.Callable;
import hudson.remoting.CallableDecoratorAdapter;
import hudson.remoting.CallableDecoratorList;
import hudson.remoting.CallableFilter;
import hudson.remoting.Capability;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.ChannelProperty;
import hudson.remoting.ClassFilter;
import hudson.remoting.Command;
import hudson.remoting.CommandTransport;
import hudson.remoting.ExportTable;
import hudson.remoting.Future;
import hudson.remoting.FutureAdapter;
import hudson.remoting.GCCommand;
import hudson.remoting.IChannel;
import hudson.remoting.ImportedClassLoaderTable;
import hudson.remoting.InterceptingExecutorService;
import hudson.remoting.JarCache;
import hudson.remoting.JarLoader;
import hudson.remoting.JarLoaderImpl;
import hudson.remoting.PipeWindow;
import hudson.remoting.PipeWriter;
import hudson.remoting.PreloadJarTask;
import hudson.remoting.RemoteClassLoader;
import hudson.remoting.RemoteInvocationHandler;
import hudson.remoting.Request;
import hudson.remoting.SingleLaneExecutorService;
import hudson.remoting.SynchronousExecutorService;
import hudson.remoting.UserRequest;
import hudson.remoting.UserResponse;
import hudson.remoting.VirtualChannel;
import hudson.remoting.Which;
import hudson.remoting.forward.ForwarderFactory;
import hudson.remoting.forward.ListeningPort;
import hudson.remoting.forward.PortForwarder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.remoting.CallableDecorator;
import org.jenkinsci.remoting.RoleChecker;

public class Channel
implements VirtualChannel,
IChannel,
Closeable {
    private final CommandTransport transport;
    @Deprecated
    private final OutputStream underlyingOutput;
    private final String name;
    private volatile boolean remoteClassLoadingAllowed;
    private volatile boolean arbitraryCallableAllowed;
    final CallableDecoratorList decorators = new CallableDecoratorList();
    final ExecutorService executor;
    private volatile Throwable inClosed = null;
    private volatile Throwable outClosed = null;
    final Map<Integer, Request<?, ?>> pendingCalls = new Hashtable();
    private final ThreadLocal<int[]> lastIoId = new ThreadLastIoId();
    final Map<Integer, Request<?, ?>> executingCalls = Collections.synchronizedMap(new Hashtable());
    final ImportedClassLoaderTable importedClassLoaders = new ImportedClassLoaderTable(this);
    final ExportTable exportedObjects = new ExportTable();
    private final WeakHashMap<PipeWindow.Key, WeakReference<PipeWindow>> pipeWindows = new WeakHashMap();
    private final Ref reference = new Ref(this);
    private final Vector<Listener> listeners = new Vector();
    private int gcCounter;
    private int commandsSent;
    public final AtomicLong classLoadingTime = new AtomicLong();
    public final AtomicInteger classLoadingCount = new AtomicInteger();
    public final AtomicInteger classLoadingPrefetchCacheCount = new AtomicInteger();
    public final AtomicLong resourceLoadingTime = new AtomicLong();
    public final AtomicInteger resourceLoadingCount = new AtomicInteger();
    private final AtomicInteger ioId = new AtomicInteger();
    private final Hashtable<Object, Object> properties = new Hashtable();
    private final IChannel remoteChannel;
    public final Capability remoteCapability;
    private volatile long lastHeard;
    final PipeWriter pipeWriter;
    final ClassLoader baseClassLoader;
    private JarCache jarCache;
    final JarLoaderImpl jarLoader;
    short maximumBytecodeLevel = Short.MAX_VALUE;
    @Nonnull
    final ClassFilter classFilter;
    private static final ThreadLocal<Channel> CURRENT = new ThreadLocal();
    private static final Logger logger = Logger.getLogger(Channel.class.getName());
    public static final int PIPE_WINDOW_SIZE = Integer.getInteger(Channel.class.getName() + ".pipeWindowSize", 0x100000);
    static final Class jarLoaderProxy = RemoteInvocationHandler.getProxyClass(JarLoader.class);

    @Deprecated
    public Channel(String name, ExecutorService exec, InputStream is, OutputStream os) throws IOException {
        this(name, exec, Mode.BINARY, is, os, null);
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, Mode mode, InputStream is, OutputStream os) throws IOException {
        this(name, exec, mode, is, os, null);
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, InputStream is, OutputStream os, OutputStream header) throws IOException {
        this(name, exec, Mode.BINARY, is, os, header);
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, Mode mode, InputStream is, OutputStream os, OutputStream header) throws IOException {
        this(name, exec, mode, is, os, header, false);
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, Mode mode, InputStream is, OutputStream os, OutputStream header, boolean restricted) throws IOException {
        this(name, exec, mode, is, os, header, restricted, null);
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, Mode mode, InputStream is, OutputStream os, OutputStream header, boolean restricted, ClassLoader base) throws IOException {
        this(name, exec, mode, is, os, header, restricted, base, new Capability());
    }

    Channel(String name, ExecutorService exec, Mode mode, InputStream is, OutputStream os, OutputStream header, boolean restricted, ClassLoader base, Capability capability) throws IOException {
        this(new ChannelBuilder(name, exec).withMode(mode).withBaseLoader(base).withCapability(capability).withHeaderStream(header).withRestricted(restricted), is, os);
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, CommandTransport transport, boolean restricted, ClassLoader base) throws IOException {
        this(new ChannelBuilder(name, exec).withBaseLoader(base).withRestricted(restricted), transport);
    }

    Channel(ChannelBuilder settings, InputStream is, OutputStream os) throws IOException {
        this(settings, settings.negotiate(is, os));
    }

    @Deprecated
    public Channel(String name, ExecutorService exec, CommandTransport transport, boolean restricted, ClassLoader base, JarCache jarCache) throws IOException {
        this(new ChannelBuilder(name, exec).withBaseLoader(base).withRestricted(restricted).withJarCache(jarCache), transport);
    }

    protected Channel(ChannelBuilder settings, CommandTransport transport) throws IOException {
        this.name = settings.getName();
        this.executor = new InterceptingExecutorService(settings.getExecutors(), this.decorators);
        this.arbitraryCallableAllowed = settings.isArbitraryCallableAllowed();
        this.remoteClassLoadingAllowed = settings.isRemoteClassLoadingAllowed();
        this.underlyingOutput = transport.getUnderlyingStream();
        this.jarCache = settings.getJarCache();
        this.baseClassLoader = settings.getBaseLoader();
        this.classFilter = settings.getClassFilter();
        if (this.internalExport(IChannel.class, this, false) != 1) {
            throw new AssertionError();
        }
        this.remoteChannel = RemoteInvocationHandler.wrap(this, 1, IChannel.class, true, false);
        this.remoteCapability = transport.getRemoteCapability();
        this.pipeWriter = new PipeWriter(this.createPipeWriterExecutor());
        this.transport = transport;
        this.jarLoader = new JarLoaderImpl();
        this.setProperty(JarLoader.OURS, this.jarLoader);
        this.decorators.addAll(settings.getDecorators());
        this.properties.putAll(settings.getProperties());
        transport.setup(this, new CommandTransport.CommandReceiver(){

            @Override
            public void handle(Command cmd) {
                Channel.this.updateLastHeard();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Received " + cmd);
                }
                try {
                    cmd.execute(Channel.this);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Failed to execute command " + cmd + " (channel " + Channel.this.name + ")", t);
                    logger.log(Level.SEVERE, "This command is created here", cmd.createdAt);
                }
            }

            @Override
            public void terminate(IOException e) {
                Channel.this.terminate(e);
            }
        });
    }

    @Nonnull
    Ref ref() {
        return this.reference;
    }

    public boolean isOutClosed() {
        return this.outClosed != null;
    }

    public boolean isClosingOrClosed() {
        return this.inClosed != null || this.outClosed != null;
    }

    private ExecutorService createPipeWriterExecutor() {
        if (this.remoteCapability.supportsPipeThrottling()) {
            return new SingleLaneExecutorService(this.executor);
        }
        return new SynchronousExecutorService();
    }

    synchronized void send(Command cmd) throws IOException {
        if (this.outClosed != null) {
            throw new ChannelClosedException(this.outClosed);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Send " + cmd);
        }
        this.transport.write(cmd, cmd instanceof CloseCommand);
        ++this.commandsSent;
    }

    @Override
    public <T> T export(Class<T> type, T instance) {
        return this.export(type, instance, true);
    }

    <T> T export(Class<T> type, T instance, boolean userProxy) {
        if (instance == null) {
            return null;
        }
        if (++this.gcCounter % 10000 == 0) {
            try {
                this.send(new GCCommand());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to send GC command", e);
            }
        }
        boolean autoUnexportByCaller = this.exportedObjects.isRecording();
        int id = this.internalExport(type, instance, autoUnexportByCaller);
        return RemoteInvocationHandler.wrap(null, id, type, userProxy, autoUnexportByCaller);
    }

    <T> int internalExport(Class<T> clazz, T instance) {
        return this.exportedObjects.export(clazz, instance);
    }

    <T> int internalExport(Class<T> clazz, T instance, boolean automaticUnexport) {
        return this.exportedObjects.export(clazz, instance, automaticUnexport);
    }

    @Nonnull
    Object getExportedObject(int oid) throws ExecutionException {
        return this.exportedObjects.get(oid);
    }

    @CheckForNull
    Object getExportedObjectOrNull(int oid) {
        return this.exportedObjects.getOrNull(oid);
    }

    @Nonnull
    Class[] getExportedTypes(int oid) throws ExecutionException {
        return this.exportedObjects.type(oid);
    }

    void unexport(int id, Throwable cause) {
        this.unexport(id, cause, true);
    }

    void unexport(int id, Throwable cause, boolean severeErrorIfMissing) {
        this.exportedObjects.unexportByOid(id, cause, severeErrorIfMissing);
    }

    public void pin(Object instance) {
        this.exportedObjects.pin(instance);
    }

    public void pinClassLoader(ClassLoader cl) {
        RemoteClassLoader.pin(cl, this);
    }

    public boolean preloadJar(Callable<?, ?> classLoaderRef, Class ... classesInJar) throws IOException, InterruptedException {
        return this.preloadJar(UserRequest.getClassLoader(classLoaderRef), classesInJar);
    }

    public boolean preloadJar(ClassLoader local, Class ... classesInJar) throws IOException, InterruptedException {
        URL[] jars = new URL[classesInJar.length];
        for (int i = 0; i < classesInJar.length; ++i) {
            jars[i] = Which.jarFile(classesInJar[i]).toURI().toURL();
        }
        return this.call(new PreloadJarTask(jars, local));
    }

    public boolean preloadJar(ClassLoader local, URL ... jars) throws IOException, InterruptedException {
        return this.call(new PreloadJarTask(jars, local));
    }

    public JarCache getJarCache() {
        return this.jarCache;
    }

    public void setJarCache(JarCache jarCache) {
        this.jarCache = jarCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PipeWindow getPipeWindow(int oid) {
        WeakHashMap<PipeWindow.Key, WeakReference<PipeWindow>> weakHashMap = this.pipeWindows;
        synchronized (weakHashMap) {
            PipeWindow w;
            PipeWindow.Key k = new PipeWindow.Key(oid);
            WeakReference<PipeWindow> v = this.pipeWindows.get(k);
            if (v != null && (w = (PipeWindow)v.get()) != null) {
                return w;
            }
            w = this.remoteCapability.supportsPipeThrottling() ? new PipeWindow.Real(k, PIPE_WINDOW_SIZE) : new PipeWindow.Fake();
            this.pipeWindows.put(k, new WeakReference<PipeWindow>(w));
            return w;
        }
    }

    @Override
    public <V, T extends Throwable> V call(Callable<V, T> callable) throws IOException, T, InterruptedException {
        UserRequest request = null;
        try {
            request = new UserRequest(this, callable);
            UserResponse r = (UserResponse)request.call(this);
            Object RSP = r.retrieve(this, UserRequest.getClassLoader(callable));
            return (V)RSP;
        }
        catch (ClassNotFoundException e) {
            IOException x = new IOException("Remote call on " + this.name + " failed");
            x.initCause(e);
            throw x;
        }
        catch (Error e) {
            IOException x = new IOException("Remote call on " + this.name + " failed");
            x.initCause(e);
            throw x;
        }
        finally {
            if (request != null) {
                request.releaseExports();
            }
        }
    }

    @Override
    public <V, T extends Throwable> Future<V> callAsync(final Callable<V, T> callable) throws IOException {
        Future f = new UserRequest(this, callable).callAsync(this);
        return new FutureAdapter<V, UserResponse<V, T>>(f){

            @Override
            protected V adapt(UserResponse<V, T> r) throws ExecutionException {
                try {
                    return r.retrieve(Channel.this, UserRequest.getClassLoader(callable));
                }
                catch (Throwable t) {
                    throw new ExecutionException(t);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"ITA_INEFFICIENT_TO_ARRAY"})
    public void terminate(IOException e) {
        try {
            Channel channel = this;
            synchronized (channel) {
                if (e == null) {
                    throw new IllegalArgumentException();
                }
                this.outClosed = this.inClosed = e;
                RemoteInvocationHandler.notifyChannelTermination(this);
                try {
                    this.transport.closeRead();
                }
                catch (IOException x) {
                    logger.log(Level.WARNING, "Failed to close down the reader side of the transport", x);
                }
                try {
                    Map<Integer, Request<?, ?>> x = this.pendingCalls;
                    synchronized (x) {
                        for (Request<?, ?> req : this.pendingCalls.values()) {
                            req.abort(e);
                        }
                        this.pendingCalls.clear();
                    }
                    x = this.executingCalls;
                    synchronized (x) {
                        for (Request<?, ?> r : this.executingCalls.values()) {
                            java.util.concurrent.Future<?> f = r.future;
                            if (f == null) continue;
                            f.cancel(true);
                        }
                        this.executingCalls.clear();
                    }
                    this.exportedObjects.abort(e);
                    this.reference.clear();
                }
                finally {
                    this.notifyAll();
                }
            }
        }
        catch (Throwable throwable) {
            if (e instanceof OrderlyShutdown) {
                e = null;
            }
            for (Listener l : this.listeners.toArray(new Listener[0])) {
                try {
                    l.onClosed(this, e);
                }
                catch (Throwable t) {
                    LogRecord lr = new LogRecord(Level.SEVERE, "Listener {0} propagated an exception for channel {1}'s close: {2}");
                    lr.setThrown(t);
                    lr.setParameters(new Object[]{l, this, t.getMessage()});
                    logger.log(lr);
                }
            }
            throw throwable;
        }
        if (e instanceof OrderlyShutdown) {
            e = null;
        }
        for (Listener l : this.listeners.toArray(new Listener[0])) {
            try {
                l.onClosed(this, e);
            }
            catch (Throwable t) {
                LogRecord lr = new LogRecord(Level.SEVERE, "Listener {0} propagated an exception for channel {1}'s close: {2}");
                lr.setThrown(t);
                lr.setParameters(new Object[]{l, this, t.getMessage()});
                logger.log(lr);
            }
        }
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        return this.listeners.remove(l);
    }

    public void addLocalExecutionInterceptor(CallableDecorator decorator) {
        this.decorators.add(decorator);
    }

    public void removeLocalExecutionInterceptor(CallableDecorator decorator) {
        this.decorators.remove(decorator);
    }

    @Deprecated
    public void addLocalExecutionInterceptor(CallableFilter filter) {
        this.addLocalExecutionInterceptor(new CallableDecoratorAdapter(filter));
    }

    @Deprecated
    public void removeLocalExecutionInterceptor(CallableFilter filter) {
        this.removeLocalExecutionInterceptor(new CallableDecoratorAdapter(filter));
    }

    @Override
    public synchronized void join() throws InterruptedException {
        while (this.inClosed == null || this.outClosed == null) {
            this.wait(30000L);
        }
    }

    public boolean isInClosed() {
        return this.inClosed != null;
    }

    @Deprecated
    public boolean isRestricted() {
        return !this.isRemoteClassLoadingAllowed() || !this.isArbitraryCallableAllowed();
    }

    @Deprecated
    public void setRestricted(boolean b) {
        this.setRemoteClassLoadingAllowed(!b);
        this.setArbitraryCallableAllowed(!b);
    }

    public boolean isRemoteClassLoadingAllowed() {
        return this.remoteClassLoadingAllowed;
    }

    public void setRemoteClassLoadingAllowed(boolean b) {
        this.remoteClassLoadingAllowed = b;
    }

    public boolean isArbitraryCallableAllowed() {
        return this.arbitraryCallableAllowed;
    }

    public void setArbitraryCallableAllowed(boolean b) {
        this.arbitraryCallableAllowed = b;
    }

    public void setMaximumBytecodeLevel(short level) throws IOException, InterruptedException {
        if (level < 5) {
            throw new IllegalArgumentException("Does not make sense to specify JDK 1.4 or below since remoting itself requires JDK 5+");
        }
        this.call(new SetMaximumBytecodeLevel(level));
    }

    @Override
    public synchronized void join(long timeout) throws InterruptedException {
        long now = System.nanoTime();
        long end = now + TimeUnit.MILLISECONDS.toNanos(timeout);
        while (end - now > 0L && (this.inClosed == null || this.outClosed == null)) {
            this.wait(TimeUnit.NANOSECONDS.toMillis(end - now));
            now = System.nanoTime();
        }
    }

    public void resetPerformanceCounters() {
        this.classLoadingCount.set(0);
        this.classLoadingTime.set(0L);
        this.classLoadingPrefetchCacheCount.set(0);
        this.resourceLoadingCount.set(0);
        this.resourceLoadingTime.set(0L);
    }

    public void dumpPerformanceCounters(PrintWriter w) throws IOException {
        int l = this.classLoadingCount.get();
        int p = this.classLoadingPrefetchCacheCount.get();
        w.printf(Locale.ENGLISH, "Class loading count=%d%n", l);
        w.printf(Locale.ENGLISH, "Class loading prefetch hit=%s (%d%%)%n", p, p * 100 / l);
        w.printf(Locale.ENGLISH, "Class loading time=%,dms%n", this.classLoadingTime.get() / 1000000L);
        w.printf(Locale.ENGLISH, "Resource loading count=%d%n", this.resourceLoadingCount.get());
        w.printf(Locale.ENGLISH, "Resource loading time=%,dms%n", this.resourceLoadingTime.get() / 1000000L);
    }

    @Override
    public synchronized void close() throws IOException {
        this.close(null);
    }

    public synchronized void close(Throwable diagnosis) throws IOException {
        if (this.outClosed != null) {
            return;
        }
        try {
            this.send(new CloseCommand(this, diagnosis));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Having to terminate early", e);
            this.terminate(e);
            return;
        }
        this.outClosed = new IOException().initCause(diagnosis);
        this.notifyAll();
        try {
            this.transport.closeWrite();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public <T> T getProperty(ChannelProperty<T> key) {
        return key.type.cast(this.getProperty((Object)key));
    }

    @Override
    public synchronized Object waitForProperty(Object key) throws InterruptedException {
        Object v;
        while ((v = this.properties.get(key)) == null) {
            if (this.isInClosed()) {
                throw (IllegalStateException)new IllegalStateException("Channel was already closed").initCause(this.inClosed);
            }
            if (this.isOutClosed()) {
                throw (IllegalStateException)new IllegalStateException("Channel was already closed").initCause(this.outClosed);
            }
            this.wait();
        }
        return v;
    }

    public <T> T waitForProperty(ChannelProperty<T> key) throws InterruptedException {
        return key.type.cast(this.waitForProperty((Object)key));
    }

    public synchronized Object setProperty(Object key, Object value) {
        Object old = value != null ? this.properties.put(key, value) : this.properties.remove(key);
        this.notifyAll();
        return old;
    }

    public <T> T setProperty(ChannelProperty<T> key, T value) {
        return key.type.cast(this.setProperty((Object)key, (Object)value));
    }

    public Object getRemoteProperty(Object key) {
        return this.remoteChannel.getProperty(key);
    }

    public <T> T getRemoteProperty(ChannelProperty<T> key) {
        return key.type.cast(this.getRemoteProperty((Object)key));
    }

    public Object waitForRemoteProperty(Object key) throws InterruptedException {
        return this.remoteChannel.waitForProperty(key);
    }

    @Deprecated
    public <T> T waitForRemoteProperty(ChannelProperty<T> key) throws InterruptedException {
        return key.type.cast(this.waitForRemoteProperty((Object)key));
    }

    @Deprecated
    public OutputStream getUnderlyingOutput() {
        return this.underlyingOutput;
    }

    public ListeningPort createLocalToRemotePortForwarding(int recvPort, String forwardHost, int forwardPort) throws IOException, InterruptedException {
        PortForwarder portForwarder = new PortForwarder(recvPort, ForwarderFactory.create(this, forwardHost, forwardPort));
        portForwarder.start();
        return portForwarder;
    }

    public ListeningPort createRemoteToLocalPortForwarding(int recvPort, String forwardHost, int forwardPort) throws IOException, InterruptedException {
        return PortForwarder.create(this, recvPort, ForwarderFactory.create(forwardHost, forwardPort));
    }

    int newIoId() {
        int v;
        this.lastIoId.get()[0] = v = this.ioId.incrementAndGet();
        return v;
    }

    int lastIoId() {
        return this.lastIoId.get()[0];
    }

    public void syncIO() throws IOException, InterruptedException {
        this.call(new IOSyncer());
    }

    @Override
    public void syncLocalIO() throws InterruptedException {
        Thread t = Thread.currentThread();
        String old = t.getName();
        t.setName("I/O sync: " + old);
        try {
            this.pipeWriter.submit(0, new Runnable(){

                @Override
                public void run() {
                }
            }).get();
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            t.setName(old);
        }
    }

    void attachCallSiteStackTrace(Throwable t) {
        Exception e = new Exception();
        StackTraceElement[] callSite = e.getStackTrace();
        StackTraceElement[] original = t.getStackTrace();
        StackTraceElement[] combined = new StackTraceElement[original.length + 1 + callSite.length];
        System.arraycopy(original, 0, combined, 0, original.length);
        combined[original.length] = new StackTraceElement(".....", "remote call to " + this.name, null, -2);
        System.arraycopy(callSite, 0, combined, original.length + 1, callSite.length);
        t.setStackTrace(combined);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return super.toString() + ":" + this.name;
    }

    public void dumpExportTable(PrintWriter w) throws IOException {
        this.exportedObjects.dump(w);
    }

    public ExportTable.ExportList startExportRecording() {
        return this.exportedObjects.startRecording();
    }

    public long getLastHeard() {
        return this.lastHeard;
    }

    private void updateLastHeard() {
        this.lastHeard = System.currentTimeMillis();
    }

    static Channel setCurrent(Channel channel) {
        Channel old = CURRENT.get();
        if (channel == null) {
            CURRENT.remove();
        } else {
            CURRENT.set(channel);
        }
        return old;
    }

    public static Channel current() {
        return CURRENT.get();
    }

    static final class Ref {
        @CheckForNull
        private Channel channel;

        private Ref(@CheckForNull Channel channel) {
            this.channel = channel;
        }

        @CheckForNull
        public Channel channel() {
            return this.channel;
        }

        public void clear() {
            this.channel = null;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Channel.Ref{");
            sb.append("channel=").append(this.channel);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class ThreadLastIoId
    extends ThreadLocal<int[]> {
        private ThreadLastIoId() {
        }

        @Override
        protected int[] initialValue() {
            return new int[1];
        }
    }

    private static final class IOSyncer
    implements Callable<Object, InterruptedException> {
        private static final long serialVersionUID = 1L;

        private IOSyncer() {
        }

        @Override
        public Object call() throws InterruptedException {
            Channel.current().syncLocalIO();
            return null;
        }

        @Override
        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }

    private static final class OrderlyShutdown
    extends IOException {
        private static final long serialVersionUID = 1L;

        private OrderlyShutdown(Throwable cause) {
            super(cause.getMessage());
            this.initCause(cause);
        }
    }

    private static final class CloseCommand
    extends Command {
        static final long serialVersionUID = 972857271608138115L;

        private CloseCommand(Channel channel, Throwable cause) {
            super(channel, cause);
        }

        @Override
        protected void execute(Channel channel) {
            try {
                channel.close();
                channel.terminate(new OrderlyShutdown(this.createdAt));
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "close command failed on " + channel.name, e);
                logger.log(Level.INFO, "close command created at", this.createdAt);
            }
        }

        public String toString() {
            return "close";
        }
    }

    private static final class SetMaximumBytecodeLevel
    implements Callable<Void, RuntimeException> {
        private static final long serialVersionUID = 1L;
        private final short level;

        SetMaximumBytecodeLevel(short level) {
            this.level = level;
        }

        @Override
        public Void call() throws RuntimeException {
            Channel.current().maximumBytecodeLevel = this.level;
            return null;
        }

        @Override
        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }

    public static abstract class Listener {
        public void onClosed(Channel channel, IOException cause) {
        }
    }

    public static enum Mode {
        BINARY(new byte[]{0, 0, 0, 0}),
        TEXT("<===[HUDSON TRANSMISSION BEGINS]===>"){

            @Override
            protected OutputStream wrap(OutputStream os) {
                return BinarySafeStream.wrap(os);
            }

            @Override
            protected InputStream wrap(InputStream is) {
                return BinarySafeStream.wrap(is);
            }
        }
        ,
        NEGOTIATE(new byte[0]);

        final byte[] preamble;

        private Mode(String preamble) {
            try {
                this.preamble = preamble.getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }

        private Mode(byte[] preamble) {
            this.preamble = preamble;
        }

        protected OutputStream wrap(OutputStream os) {
            return os;
        }

        protected InputStream wrap(InputStream is) {
            return is;
        }
    }
}

