/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting.jnlp;

import hudson.remoting.EngineListener;
import hudson.remoting.jnlp.GUI;
import hudson.remoting.jnlp.MainDialog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class GuiListener
implements EngineListener {
    public final MainDialog frame;
    private static final Logger LOGGER = Logger.getLogger(GuiListener.class.getName());

    public GuiListener() {
        GUI.setUILookAndFeel();
        this.frame = new MainDialog();
        this.frame.setVisible(true);
    }

    @Override
    public void status(String msg) {
        this.status(msg, null);
    }

    @Override
    public void status(final String msg, final Throwable t) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiListener.this.frame.status(msg);
                if (t != null) {
                    LOGGER.log(Level.INFO, msg, t);
                }
            }
        });
    }

    @Override
    public void error(final Throwable t) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LOGGER.log(Level.SEVERE, t.getMessage(), t);
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                JOptionPane.showMessageDialog(GuiListener.this.frame, sw.toString(), "Error", 0);
                System.exit(-1);
            }
        });
    }

    @Override
    public void onDisconnect() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiListener.this.frame.resetMenuBar();
            }
        });
    }

    @Override
    public void onReconnect() {
    }
}

