/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;

class Util {
    Util() {
    }

    static String getBaseName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    static byte[] readFully(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Util.copy(in, baos);
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
        }
    }

    static File makeResource(String name, byte[] image) throws IOException {
        File tmpFile = Util.createTempDir();
        File resource = new File(tmpFile, name);
        resource.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(resource);
        fos.write(image);
        fos.close();
        Util.deleteDirectoryOnExit(tmpFile);
        return resource;
    }

    static File createTempDir() throws IOException {
        int nRetry = 0;
        while (true) {
            try {
                File tmpFile = File.createTempFile("jenkins-remoting", "");
                tmpFile.delete();
                tmpFile.mkdir();
                return tmpFile;
            }
            catch (IOException e) {
                if (nRetry++ < 100) continue;
                IOException nioe = new IOException("failed to create temp directory at default location, most probably at: " + System.getProperty("java.io.tmpdir"));
                nioe.initCause(e);
                throw nioe;
            }
            break;
        }
    }

    static void deleteDirectoryOnExit(File dir) {
        File[] childFiles;
        dir.deleteOnExit();
        if (dir.isDirectory() && (childFiles = dir.listFiles()) != null) {
            for (File f : childFiles) {
                Util.deleteDirectoryOnExit(f);
            }
        }
    }

    static String indent(String s) {
        return "    " + s.trim().replace("\n", "\n    ");
    }

    static URLConnection openURLConnection(URL url) throws IOException {
        String httpProxy = null;
        if (System.getProperty("http.proxyHost") == null) {
            httpProxy = System.getenv("http_proxy");
        }
        URLConnection con = null;
        if (httpProxy != null && "http".equals(url.getProtocol())) {
            try {
                URL proxyUrl = new URL(httpProxy);
                InetSocketAddress addr = new InetSocketAddress(proxyUrl.getHost(), proxyUrl.getPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                con = url.openConnection(proxy);
            }
            catch (MalformedURLException e) {
                System.err.println("Not use http_proxy property or environment variable which is invalid: " + e.getMessage());
                con = url.openConnection();
            }
        } else {
            con = url.openConnection();
        }
        return con;
    }

    static InetSocketAddress getResolvedHttpProxyAddress(String host, int port) throws IOException {
        String httpProxy;
        Proxy proxy;
        InetSocketAddress targetAddress = null;
        Iterator<Proxy> proxies = ProxySelector.getDefault().select(URI.create(String.format("http://%s:%d", host, port))).iterator();
        while (targetAddress == null && proxies.hasNext() && (proxy = proxies.next()).type() != Proxy.Type.DIRECT) {
            if (proxy.type() != Proxy.Type.HTTP) continue;
            SocketAddress address = proxy.address();
            if (!(address instanceof InetSocketAddress)) {
                System.err.println("Unsupported proxy address type " + (address != null ? address.getClass() : "null"));
                continue;
            }
            InetSocketAddress proxyAddress = (InetSocketAddress)address;
            if (proxyAddress.isUnresolved()) {
                proxyAddress = new InetSocketAddress(proxyAddress.getHostName(), proxyAddress.getPort());
            }
            targetAddress = proxyAddress;
        }
        if (targetAddress == null && (httpProxy = System.getenv("http_proxy")) != null) {
            try {
                URL url = new URL(httpProxy);
                targetAddress = new InetSocketAddress(url.getHost(), url.getPort());
            }
            catch (MalformedURLException e) {
                System.err.println("Not use http_proxy environment variable which is invalid: " + e.getMessage());
            }
        }
        return targetAddress;
    }
}

