/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

public abstract class ClassFilter {
    public static final ClassFilter DEFAULT = new ClassFilter(){

        @Override
        protected boolean isBlacklisted(String name) {
            if (name.startsWith("org.codehaus.groovy.runtime.")) {
                return true;
            }
            if (name.startsWith("org.apache.commons.collections.functors.")) {
                return true;
            }
            return name.contains("org.apache.xalan");
        }
    };
    public static final ClassFilter NONE = new ClassFilter(){};

    protected boolean isBlacklisted(String name) {
        return false;
    }

    protected boolean isBlacklisted(Class c) {
        return false;
    }

    public final String check(String name) {
        if (this.isBlacklisted(name)) {
            throw new SecurityException("Rejected: " + name);
        }
        return name;
    }

    public final Class check(Class c) {
        if (this.isBlacklisted(c)) {
            throw new SecurityException("Rejected: " + c.getName());
        }
        return c;
    }
}

