/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public final class Capability
implements Serializable {
    private final long mask;
    private static final long serialVersionUID = 1L;
    private static final long MASK_UNUSED1 = 1L;
    private static final long MASK_MULTI_CLASSLOADER = 2L;
    private static final long MASK_PIPE_THROTTLING = 4L;
    private static final long MASK_MIMIC_EXCEPTION = 8L;
    private static final long MASK_PREFETCH = 16L;
    private static final long GREEDY_REMOTE_INPUTSTREAM = 32L;
    private static final long MASK_PROXY_WRITER_2_35 = 64L;
    private static final long MASK_CHUNKED_ENCODING = 128L;
    static final byte[] PREAMBLE;
    public static final Capability NONE;

    Capability(long mask) {
        this.mask = mask;
    }

    public Capability() {
        this(254L);
    }

    public boolean supportsMultiClassLoaderRPC() {
        return (this.mask & 2L) != 0L;
    }

    public boolean supportsPipeThrottling() {
        return (this.mask & 4L) != 0L;
    }

    public boolean hasMimicException() {
        return (this.mask & 8L) != 0L;
    }

    public boolean supportsChunking() {
        return (this.mask & 0x80L) != 0L;
    }

    public boolean supportsPrefetch() {
        return (this.mask & 0x10L) != 0L;
    }

    public boolean supportsGreedyRemoteInputStream() {
        return (this.mask & 0x20L) != 0L;
    }

    public boolean supportsProxyWriter2_35() {
        return (this.mask & 0x40L) != 0L;
    }

    void writePreamble(OutputStream os) throws IOException {
        os.write(PREAMBLE);
        ObjectOutputStream oos = new ObjectOutputStream(Channel.Mode.TEXT.wrap(os));
        oos.writeObject(this);
        oos.flush();
    }

    public static Capability read(InputStream is) throws IOException {
        try {
            ObjectInputStream ois = new ObjectInputStream(Channel.Mode.TEXT.wrap(is)){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String n = desc.getName();
                    if (n.equals("java.lang.String") || n.equals("[Ljava.lang.String;") || n.equals(Capability.class.getName())) {
                        return super.resolveClass(desc);
                    }
                    throw new SecurityException("Rejected: " + n);
                }
            };
            return (Capability)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw (Error)new NoClassDefFoundError(e.getMessage()).initCause(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Capability{");
        boolean first = true;
        if ((this.mask & 2L) != 0L) {
            first = false;
            sb.append("Multi-ClassLoader RPC");
        }
        if ((this.mask & 4L) != 0L) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("Pipe throttling");
        }
        if ((this.mask & 8L) != 0L) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("Mimic Exception");
        }
        if ((this.mask & 0x10L) != 0L) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("Prefetch");
        }
        if ((this.mask & 0x20L) != 0L) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("Greedy RemoteInputStream");
        }
        if ((this.mask & 0x40L) != 0L) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("Proxy writer 2.35");
        }
        if ((this.mask & 0x80L) != 0L) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("Chunked encoding");
        }
        sb.append('}');
        return sb.toString();
    }

    static {
        NONE = new Capability(0L);
        try {
            PREAMBLE = "<===[JENKINS REMOTING CAPACITY]===>".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

