/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEventLogger
extends org.apache.maven.cli.event.ExecutionEventLogger {
    private final Logger logger;
    private final String mojoNote;
    private static final int MAX_PADDED_BUILD_TIME_DURATION_LENGTH = 9;
    private static final int MAX_PROJECT_NAME_LENGTH = 52;
    private static final int LINE_LENGTH = 72;
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;

    public ExecutionEventLogger() {
        this.logger = LoggerFactory.getLogger(ExecutionEventLogger.class);
        this.mojoNote = null;
    }

    @Deprecated
    public ExecutionEventLogger(Logger logger) {
        this(logger, null);
    }

    public ExecutionEventLogger(Logger logger, String mojoNote) {
        super(logger);
        this.logger = logger;
        this.mojoNote = mojoNote;
    }

    public void mojoStarted(ExecutionEvent event) {
        if (this.mojoNote != null && this.logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.mojoNote);
            buffer.append("--- ");
            this.append(buffer, event.getMojoExecution());
            this.append(buffer, event.getProject());
            buffer.append(" ---");
            this.logger.info("");
            this.logger.info(buffer.toString());
        }
    }

    private void append(StringBuilder buffer, MojoExecution me) {
        buffer.append(me.getArtifactId()).append(':').append(me.getVersion());
        buffer.append(':').append(me.getGoal());
        if (me.getExecutionId() != null) {
            buffer.append(" (").append(me.getExecutionId()).append(')');
        }
    }

    private void append(StringBuilder buffer, MavenProject project) {
        buffer.append(" @ ").append(project.getArtifactId());
    }

    public void sessionEnded(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            if (event.getSession().getProjects().size() > 1) {
                this.logReactorSummary(event.getSession());
            }
            this.logResult(event.getSession());
            this.logStats(event.getSession());
            this.infoLine('-');
        }
    }

    private void logReactorSummary(MavenSession session) {
        this.infoLine('-');
        this.infoMain("Reactor Summary:");
        this.logger.info("");
        MavenExecutionResult result = session.getResult();
        List projects = session.getProjects();
        MavenProject lastProject = (MavenProject)projects.get(projects.size() - 1);
        MavenProject topProject = session.getTopLevelProject();
        for (MavenProject project : projects) {
            int padSize;
            String buildTimeDuration;
            BuildSummary buildSummary;
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(project.getName());
            buffer.append(' ');
            if (topProject.equals((Object)project) || lastProject.equals((Object)project) || !topProject.getVersion().equals(project.getVersion())) {
                buffer.append(project.getVersion());
                buffer.append(' ');
            }
            if (buffer.length() <= 52) {
                while (buffer.length() < 52) {
                    buffer.append('.');
                }
                buffer.append(' ');
            }
            if ((buildSummary = result.getBuildSummary(project)) == null) {
                buffer.append(MessageUtils.buffer().warning((Object)"SKIPPED"));
            } else if (buildSummary instanceof BuildSuccess) {
                buffer.append(MessageUtils.buffer().success((Object)"SUCCESS"));
                buffer.append(" [");
                buildTimeDuration = ExecutionEventLogger.formatDuration(buildSummary.getTime());
                padSize = 9 - buildTimeDuration.length();
                if (padSize > 0) {
                    buffer.append(ExecutionEventLogger.chars(' ', padSize));
                }
                buffer.append(buildTimeDuration);
                buffer.append(']');
            } else if (buildSummary instanceof BuildFailure) {
                buffer.append(MessageUtils.buffer().failure((Object)"FAILURE"));
                buffer.append(" [");
                buildTimeDuration = ExecutionEventLogger.formatDuration(buildSummary.getTime());
                padSize = 9 - buildTimeDuration.length();
                if (padSize > 0) {
                    buffer.append(ExecutionEventLogger.chars(' ', padSize));
                }
                buffer.append(buildTimeDuration);
                buffer.append(']');
            }
            this.logger.info(buffer.toString());
        }
    }

    private static String formatDuration(long duration) {
        long ms = duration % 1000L;
        long s = duration / 1000L % 60L;
        long m = duration / 60000L % 60L;
        long h = duration / 3600000L % 24L;
        long d = duration / 86400000L;
        String format = d > 0L ? "%d d %02d:%02d h" : (h > 0L ? "%2$02d:%3$02d h" : (m > 0L ? "%3$02d:%4$02d min" : "%4$d.%5$03d s"));
        return String.format(format, d, h, m, s, ms);
    }

    private void logResult(MavenSession session) {
        this.infoLine('-');
        MessageBuilder buffer = MessageUtils.buffer();
        if (session.getResult().hasExceptions()) {
            buffer.failure((Object)"BUILD FAILURE");
        } else {
            buffer.success((Object)"BUILD SUCCESS");
        }
        this.logger.info(buffer.toString());
    }

    private void logStats(MavenSession session) {
        this.infoLine('-');
        long finish = System.currentTimeMillis();
        long time = finish - session.getRequest().getStartTime().getTime();
        String wallClock = "";
        this.logger.info("Total time: " + ExecutionEventLogger.formatDuration(time) + wallClock);
        this.logger.info("Finished at: " + ExecutionEventLogger.formatTimestamp(finish));
    }

    private void infoLine(char c) {
        this.infoMain(ExecutionEventLogger.chars(c, 72));
    }

    private void infoMain(String msg) {
        this.logger.info(MessageUtils.buffer().strong((Object)msg).toString());
    }

    private static String chars(char c, int count) {
        StringBuilder buffer = new StringBuilder(count);
        for (int i = count; i > 0; --i) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String formatTimestamp(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        return sdf.format(new Date(timestamp));
    }
}

