/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.AbstractMavenBuild;
import hudson.maven.AbstractMavenBuilder;
import hudson.maven.AbstractMavenProcessFactory;
import hudson.maven.ExecutedMojo;
import hudson.maven.FilteredChangeLogSet;
import hudson.maven.Maven31ProcessFactory;
import hudson.maven.Maven32ProcessFactory;
import hudson.maven.Maven33ProcessFactory;
import hudson.maven.Maven35ProcessFactory;
import hudson.maven.Maven3Builder;
import hudson.maven.Maven3ProcessFactory;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenBuildProxy2;
import hudson.maven.MavenBuilder;
import hudson.maven.MavenInformation;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenProcessFactory;
import hudson.maven.MavenProjectActionBuilder;
import hudson.maven.MavenReportInfo;
import hudson.maven.MavenReporter;
import hudson.maven.MavenUtil;
import hudson.maven.MavenVersionCallable;
import hudson.maven.Messages;
import hudson.maven.ModuleName;
import hudson.maven.MojoInfo;
import hudson.maven.ProcessCache;
import hudson.maven.RedeployPublisher;
import hudson.maven.SplittableBuildListener;
import hudson.maven.UnbuiltModuleAction;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.maven.reporters.SurefireArchiver;
import hudson.maven.reporters.TestFailureDetector;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Environment;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogSet;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import hudson.util.DescribableList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.maven3.agent.Maven31Main;
import jenkins.maven3.agent.Maven32Main;
import jenkins.maven3.agent.Maven33Main;
import jenkins.maven3.agent.Maven35Main;
import jenkins.model.ArtifactManager;
import jenkins.mvn.SettingsProvider;
import org.apache.maven.BuildFailureException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectSorter;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.jvnet.hudson.maven3.agent.Maven3Main;
import org.jvnet.hudson.maven3.launcher.Maven31Launcher;
import org.jvnet.hudson.maven3.launcher.Maven32Launcher;
import org.jvnet.hudson.maven3.launcher.Maven33Launcher;
import org.jvnet.hudson.maven3.launcher.Maven35Launcher;
import org.jvnet.hudson.maven3.launcher.Maven3Launcher;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class MavenBuild
extends AbstractMavenBuild<MavenModule, MavenBuild> {
    List<MavenProjectActionBuilder> projectActionReporters;
    private List<ExecutedMojo> executedMojos;
    private static final int MAX_PROCESS_CACHE = 5;
    protected static final ProcessCache mavenProcessCache = new ProcessCache(5);
    public static boolean debug = false;
    private static final Logger LOGGER = Logger.getLogger(MavenBuild.class.getName());

    public MavenBuild(MavenModule job) throws IOException {
        super(job);
    }

    public MavenBuild(MavenModule job, Calendar timestamp) {
        super(job, timestamp);
    }

    public MavenBuild(MavenModule project, File buildDir) throws IOException {
        super(project, buildDir);
        SurefireArchiver.fixUp(this.projectActionReporters);
    }

    public String getUpUrl() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof MavenModuleSetBuild)) continue;
                return ((Ancestor)ancs.get(i - 1)).getUrl() + '/';
            }
        }
        return super.getUpUrl();
    }

    public String getDisplayName() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            List ancs = req.getAncestors();
            for (int i = 1; i < ancs.size(); ++i) {
                if (((Ancestor)ancs.get(i)).getObject() != this || !(((Ancestor)ancs.get(i - 1)).getObject() instanceof MavenModuleSetBuild)) continue;
                return this.getParent().getDisplayName();
            }
        }
        return super.getDisplayName();
    }

    @CheckForNull
    public MavenModuleSetBuild getParentBuild() {
        return (MavenModuleSetBuild)this.getParent().getParent().getBuildByNumber(this.getNumber());
    }

    public AbstractBuild<?, ?> getRootBuild() {
        MavenModuleSetBuild parent = this.getParentBuild();
        return parent != null ? parent : this;
    }

    @CheckForNull
    public MavenModuleSetBuild getModuleSetBuild() {
        return (MavenModuleSetBuild)this.getParent().getParent().getNearestOldBuild(this.getNumber());
    }

    public ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet() {
        return new FilteredChangeLogSet(this);
    }

    public boolean hasChangeSetComputed() {
        return true;
    }

    @Exported
    public MavenArtifactRecord getMavenArtifacts() {
        return (MavenArtifactRecord)this.getAction(MavenArtifactRecord.class);
    }

    @Override
    public EnvVars getEnvironment(TaskListener log) throws IOException, InterruptedException {
        EnvVars envs = super.getEnvironment(log);
        Maven.MavenInstallation mvn = ((MavenModule)this.project).getParent().getMaven();
        if (mvn == null) {
            throw new AbortException(Messages.MavenModuleSetBuild_NoMavenConfigured());
        }
        mvn = mvn.forEnvironment(envs).forNode(Computer.currentComputer().getNode(), log);
        mvn.buildEnvVars(envs);
        return envs;
    }

    public void registerAsProjectAction(MavenReporter reporter) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<MavenProjectActionBuilder>();
        }
        this.projectActionReporters.add(reporter);
    }

    public void registerAsProjectAction(MavenProjectActionBuilder builder) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<MavenProjectActionBuilder>();
        }
        this.projectActionReporters.add(builder);
    }

    public List<MavenProjectActionBuilder> getProjectActionBuilders() {
        if (this.projectActionReporters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.projectActionReporters);
    }

    public List<ExecutedMojo> getExecutedMojos() {
        if (this.executedMojos == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.executedMojos);
    }

    public void run() {
        this.execute((Run.RunExecution)new MavenBuildExecution());
        ((MavenModule)this.getProject()).updateTransientActions();
        MavenModuleSetBuild parentBuild = this.getModuleSetBuild();
        if (parentBuild != null) {
            parentBuild.notifyModuleBuild(this);
        }
    }

    public String getWhyKeepLog() {
        MavenModuleSetBuild pb = this.getParentBuild();
        if (pb != null && pb.getWhyKeepLog() != null) {
            return Messages.MavenBuild_KeptBecauseOfParent((Object)pb);
        }
        return super.getWhyKeepLog();
    }

    public static ExecutedMojo.Cache createExecutedMojoCache() {
        return new ExecutedMojo.Cache();
    }

    protected void setWorkspace(FilePath path) {
        super.setWorkspace(path);
    }

    public MavenModule getParent() {
        return (MavenModule)super.getParent();
    }

    protected void setBuiltOnStr(String builtOn) {
        super.setBuiltOnStr(builtOn);
    }

    @Override
    public String getMavenOpts(TaskListener listener, EnvVars envVars) {
        return envVars.expand(this.expandTokens(listener, ((MavenModule)this.getProject()).getParent().getMavenOpts()));
    }

    static /* synthetic */ long access$700(MavenBuild x0) {
        return x0.duration;
    }

    private class MavenBuildExecution
    extends AbstractBuild.AbstractBuildExecution {
        private List<MavenReporter> reporters;

        private MavenBuildExecution() {
            super((AbstractBuild)MavenBuild.this);
        }

        public MavenBuild getBuild() {
            return (MavenBuild)super.getBuild();
        }

        public MavenModule getProject() {
            return (MavenModule)super.getProject();
        }

        protected WorkspaceList.Lease decideWorkspace(Node n, WorkspaceList wsl) throws InterruptedException, IOException {
            return wsl.allocate(MavenBuild.this.getModuleSetBuild().getModuleRoot().child(this.getProject().getRelativePath()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Result doRun(BuildListener listener) throws Exception {
            AbstractMavenBuilder builder = null;
            ProcessCache.MavenProcess process = null;
            boolean normalExit = false;
            SplittableBuildListener slistener = new SplittableBuildListener(listener);
            try {
                ProxyImpl proxy;
                String settingsPath;
                AbstractMavenProcessFactory factory;
                this.reporters = this.getProject().createReporters();
                MavenModuleSet mms = this.getProject().getParent();
                if (debug) {
                    listener.getLogger().println("Reporters=" + this.reporters);
                }
                for (BuildWrapper w : mms.getBuildWrappersList()) {
                    BuildWrapper.Environment e = w.setUp((AbstractBuild)MavenBuild.this, this.launcher, listener);
                    if (e == null) {
                        Result result = Result.FAILURE;
                        return result;
                    }
                    MavenBuild.this.buildEnvironments.add(e);
                }
                EnvVars envVars = MavenBuild.this.getEnvironment((TaskListener)listener);
                Maven.MavenInstallation mvn = this.getProject().getParent().getMaven();
                mvn = mvn.forEnvironment(envVars).forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
                MavenInformation mavenInformation = (MavenInformation)MavenBuild.this.getModuleRoot().act((Callable)new MavenVersionCallable(mvn.getHome()));
                String mavenVersion = mavenInformation.getVersion();
                LOGGER.fine(MavenBuild.this.getFullDisplayName() + " is building with mavenVersion " + mavenVersion + " from file " + mavenInformation.getVersionResourcePath());
                MavenBuildInformation mavenBuildInformation = new MavenBuildInformation(mavenVersion);
                MavenUtil.MavenVersion mavenVersionType = MavenUtil.getMavenVersion(mavenVersion);
                switch (mavenVersionType) {
                    case MAVEN_2: {
                        LOGGER.fine("using maven 2 " + mavenVersion);
                        factory = new MavenProcessFactory(MavenBuild.this.getParent().getParent(), MavenBuild.this, this.launcher, envVars, MavenBuild.this.getMavenOpts((TaskListener)listener, envVars), null);
                        break;
                    }
                    case MAVEN_3_0_X: {
                        LOGGER.fine("using maven 3 " + mavenVersion);
                        factory = new Maven3ProcessFactory(MavenBuild.this.getParent().getParent(), MavenBuild.this, this.launcher, envVars, MavenBuild.this.getMavenOpts((TaskListener)listener, envVars), null);
                        break;
                    }
                    case MAVEN_3_1: {
                        LOGGER.fine("using maven 3 " + mavenVersion);
                        factory = new Maven31ProcessFactory(MavenBuild.this.getParent().getParent(), MavenBuild.this, this.launcher, envVars, MavenBuild.this.getMavenOpts((TaskListener)listener, envVars), null);
                        break;
                    }
                    case MAVEN_3_2: {
                        LOGGER.fine("using maven 3 " + mavenVersion);
                        factory = new Maven32ProcessFactory(MavenBuild.this.getParent().getParent(), MavenBuild.this, this.launcher, envVars, MavenBuild.this.getMavenOpts((TaskListener)listener, envVars), null);
                        break;
                    }
                    case MAVEN_3_3: {
                        LOGGER.fine("using maven 3 " + mavenVersion);
                        factory = new Maven33ProcessFactory(MavenBuild.this.getParent().getParent(), MavenBuild.this, this.launcher, envVars, MavenBuild.this.getMavenOpts((TaskListener)listener, envVars), null);
                        break;
                    }
                    default: {
                        LOGGER.fine("using maven 3 " + mavenVersion);
                        factory = new Maven35ProcessFactory(MavenBuild.this.getParent().getParent(), MavenBuild.this, this.launcher, envVars, MavenBuild.this.getMavenOpts((TaskListener)listener, envVars), null);
                    }
                }
                process = mavenProcessCache.get(this.launcher.getChannel(), slistener, (ProcessCache.Factory)((Object)factory));
                ArgumentListBuilder margs = new ArgumentListBuilder(new String[]{"-N", "-B"});
                FilePath localRepo = mms.getLocalRepository().locate(MavenBuild.this);
                if (localRepo != null) {
                    margs.add("-Dmaven.repo.local=" + localRepo.getRemote());
                }
                if ((settingsPath = SettingsProvider.getSettingsRemotePath((SettingsProvider)mms.getSettings(), (AbstractBuild)MavenBuild.this, (TaskListener)listener)) != null) {
                    margs.add("-s").add(settingsPath);
                }
                margs.add(new String[]{"-f", MavenBuild.this.getModuleRoot().child("pom.xml").getRemote()});
                margs.addTokenized(this.getProject().getGoals());
                HashMap<String, String> systemProps = new HashMap<String, String>((Map<String, String>)envVars);
                systemProps.put("hudson.build.number", String.valueOf(MavenBuild.this.getNumber()));
                if (mavenBuildInformation.isMaven3OrLater()) {
                    ProxyImpl2 proxy2 = new ProxyImpl2((MavenModuleSetBuild)mms.getLastCompletedBuild(), slistener);
                    proxy2.setBlockBuildEvents(true);
                    proxy = proxy2;
                    builder = new Maven3Builder(this.createRequest(proxy2, this.getProject(), margs.toList(), systemProps, mavenBuildInformation));
                } else {
                    proxy = new ProxyImpl();
                    builder = new Builder(listener, proxy, this.getProject(), margs.toList(), systemProps);
                }
                Result r = (Result)process.call(builder);
                proxy.performArchiving(this.launcher, listener);
                normalExit = true;
                Result result = r;
                return result;
            }
            finally {
                if (builder != null) {
                    builder.end(this.launcher);
                }
                if (process != null) {
                    if (normalExit) {
                        process.recycle();
                    } else {
                        process.discard();
                    }
                }
                boolean failed = false;
                for (int i = MavenBuild.this.buildEnvironments.size() - 1; i >= 0; --i) {
                    Environment environment = (Environment)MavenBuild.this.buildEnvironments.get(i);
                    try {
                        if (environment.tearDown((AbstractBuild)MavenBuild.this, (BuildListener)slistener)) continue;
                        failed = true;
                        continue;
                    }
                    catch (Throwable inTearDown) {
                        failed = true;
                        listener.error("Unable to tear down: " + inTearDown.getMessage());
                        inTearDown.printStackTrace(listener.getLogger());
                    }
                }
                if (!normalExit && failed) {
                    return Result.FAILURE;
                }
            }
        }

        private Maven3Builder.Maven3BuilderRequest createRequest(ProxyImpl2 buildProxy, MavenModule module, List<String> goals, Map<String, String> systemProps, MavenBuildInformation mavenBuildInformation) {
            String mavenVersion = mavenBuildInformation.getMavenVersion();
            Maven3Builder.Maven3BuilderRequest request = new Maven3Builder.Maven3BuilderRequest();
            request.listener = buildProxy.listener;
            request.modules = Collections.singleton(module);
            request.goals = goals;
            request.systemProps = systemProps;
            request.proxies = new HashMap<ModuleName, ProxyImpl2>();
            request.proxies.put(module.getModuleName(), buildProxy);
            request.mavenBuildInformation = mavenBuildInformation;
            request.supportEventSpy = MavenUtil.supportEventSpy(mavenVersion);
            switch (MavenUtil.getMavenVersion(mavenVersion)) {
                case MAVEN_3_0_X: {
                    request.maven3MainClass = Maven3Main.class;
                    request.maven3LauncherClass = Maven3Launcher.class;
                    break;
                }
                case MAVEN_3_1: {
                    request.maven3MainClass = Maven31Main.class;
                    request.maven3LauncherClass = Maven31Launcher.class;
                    break;
                }
                case MAVEN_3_2: {
                    request.maven3MainClass = Maven32Main.class;
                    request.maven3LauncherClass = Maven32Launcher.class;
                    break;
                }
                case MAVEN_3_3: {
                    request.maven3MainClass = Maven33Main.class;
                    request.maven3LauncherClass = Maven33Launcher.class;
                }
                default: {
                    request.maven3MainClass = Maven35Main.class;
                    request.maven3LauncherClass = Maven35Launcher.class;
                }
            }
            return request;
        }

        public void post2(BuildListener listener) throws Exception {
            if (this.reporters != null) {
                for (MavenReporter reporter : this.reporters) {
                    reporter.end(MavenBuild.this, this.launcher, listener);
                }
            }
        }
    }

    public class ProxyImpl2
    extends ProxyImpl
    implements MavenBuildProxy2 {
        private static final long serialVersionUID = -3377221864644014218L;
        private final SplittableBuildListener listener;
        long startTime;
        private final OutputStream log;
        private final MavenModuleSetBuild parentBuild;
        private boolean blockBuildEvents;

        ProxyImpl2(MavenModuleSetBuild parentBuild, SplittableBuildListener listener) throws FileNotFoundException {
            this.parentBuild = parentBuild;
            this.listener = listener;
            this.log = new FileOutputStream(MavenBuild.this.getLogFile());
        }

        @Override
        public void start() {
            if (!this.blockBuildEvents) {
                MavenBuild.this.onStartBuilding();
            }
            this.startTime = System.currentTimeMillis();
            try {
                this.sync();
                this.listener.setSideOutputStream(this.log);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            RunListener.fireStarted((Run)MavenBuild.this, (TaskListener)this.listener);
        }

        @Override
        public void end() {
            if (MavenBuild.this.result == null) {
                this.setResult(Result.SUCCESS);
            }
            if (!this.blockBuildEvents) {
                MavenBuild.this.onEndBuilding();
            }
            MavenBuild.this.duration = MavenBuild.this.duration + (System.currentTimeMillis() - this.startTime);
            this.parentBuild.notifyModuleBuild(MavenBuild.this);
            try {
                this.sync();
                this.listener.setSideOutputStream(null);
                MavenBuild.this.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                MavenBuild.this.updateSymlinks((TaskListener)this.listener);
            }
            catch (InterruptedException x) {
                Logger.getLogger(MavenBuild.class.getName()).log(Level.WARNING, null, x);
            }
            RunListener.fireCompleted((Run)MavenBuild.this, (TaskListener)this.listener);
        }

        @Override
        public void appendLastLog() {
            try {
                this.sync();
                this.listener.setSideOutputStream(this.log);
                this.listener.setSideOutputStream(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void sync() throws IOException {
            try {
                Channel ch = Channel.current();
                if (ch != null) {
                    this.listener.synchronizeOnMark(ch);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        protected void close() {
            abstract class Terminate
            extends Run.RunExecution {
                Terminate() {
                    super((Run)MavenBuild.this);
                }

                public void post(BuildListener listener) {
                }

                public void cleanUp(BuildListener listener) {
                }
            }
            try {
                this.sync();
                this.log.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (MavenBuild.this.isInProgress()) {
                MavenBuild.this.execute(new Terminate(){
                    {
                    }

                    public Result run(BuildListener listener) {
                        return Result.ABORTED;
                    }
                });
            }
            if (MavenBuild.this.hasntStartedYet()) {
                MavenBuild.this.execute(new Terminate(){
                    {
                    }

                    public Result run(BuildListener listener) {
                        listener.getLogger().println(Messages.MavenBuild_FailedEarlier());
                        return Result.NOT_BUILT;
                    }
                });
            }
            this.rememberModulesToBuildAgainNextTime();
        }

        private void rememberModulesToBuildAgainNextTime() {
            MavenModuleSetBuild moduleSetBuild = MavenBuild.this.getModuleSetBuild();
            if (moduleSetBuild == null) {
                return;
            }
            if (MavenBuild.this.hasntStartedYet()) {
                if (moduleSetBuild.getParent().isIncrementalBuild() && moduleSetBuild.getResult() != Result.SUCCESS && moduleSetBuild.getResult() != Result.UNSTABLE) {
                    UnbuiltModuleAction action = (UnbuiltModuleAction)moduleSetBuild.getAction(UnbuiltModuleAction.class);
                    if (action == null) {
                        action = new UnbuiltModuleAction();
                        moduleSetBuild.getActions().add(action);
                    }
                    action.addUnbuiltModule(MavenBuild.this.getParent().getModuleName());
                }
            } else {
                UnbuiltModuleAction unbuiltModuleAction;
                MavenModuleSetBuild previousParentBuild = (MavenModuleSetBuild)moduleSetBuild.getPreviousBuild();
                if (previousParentBuild != null && (unbuiltModuleAction = (UnbuiltModuleAction)previousParentBuild.getAction(UnbuiltModuleAction.class)) != null) {
                    unbuiltModuleAction.removeUnbuildModule(MavenBuild.this.getParent().getModuleName());
                    try {
                        previousParentBuild.save();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (moduleSetBuild.getParent().isIncrementalBuild() && moduleSetBuild.getResult() != Result.SUCCESS) {
                    MavenModuleSet mavenModuleSet = moduleSetBuild.getParent();
                    boolean isDeploying = false;
                    Result deploymentThreshold = Result.SUCCESS;
                    DescribableList<Publisher, Descriptor<Publisher>> publishers = mavenModuleSet.getPublishersList();
                    for (Publisher publisher : publishers) {
                        if (!(publisher instanceof RedeployPublisher)) continue;
                        isDeploying = true;
                        deploymentThreshold = ((RedeployPublisher)publisher).getTreshold();
                        break;
                    }
                    if (isDeploying && moduleSetBuild.getResult().isWorseThan(deploymentThreshold)) {
                        UnbuiltModuleAction action = (UnbuiltModuleAction)moduleSetBuild.getAction(UnbuiltModuleAction.class);
                        if (action == null) {
                            action = new UnbuiltModuleAction();
                            moduleSetBuild.getActions().add(action);
                        }
                        action.addUnbuiltModule(MavenBuild.this.getParent().getModuleName());
                    }
                }
            }
        }

        public MavenBuild owner() {
            return MavenBuild.this;
        }

        private Object writeReplace() {
            return Channel.current().export(MavenBuildProxy2.class, Executor.currentExecutor().newImpersonatingProxy(MavenBuildProxy2.class, (Object)this));
        }

        protected void setBlockBuildEvents(boolean blockBuildEvents) {
            this.blockBuildEvents = blockBuildEvents;
        }
    }

    private static final class CanonicalPath
    extends MasterToSlaveFileCallable<String> {
        private static final long serialVersionUID = 1L;

        private CanonicalPath() {
        }

        public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return f.getCanonicalPath().replace(File.separatorChar, '/');
        }
    }

    class ProxyImpl
    implements MavenBuildProxy,
    Serializable {
        private static final long serialVersionUID = 8865133776526671879L;
        private final Map<String, String> artifacts = new LinkedHashMap<String, String>();

        ProxyImpl() {
        }

        @Override
        public <V, T extends Throwable> V execute(MavenBuildProxy.BuildCallable<V, T> program) throws T, IOException, InterruptedException {
            return program.call(MavenBuild.this);
        }

        @Override
        public final void executeAsync(MavenBuildProxy.BuildCallable<?, ?> program) throws IOException {
            throw new AssertionError();
        }

        @Override
        public FilePath getRootDir() {
            return new FilePath(MavenBuild.this.getRootDir());
        }

        @Override
        public FilePath getProjectRootDir() {
            return new FilePath(MavenBuild.this.getParent().getRootDir());
        }

        @Override
        public FilePath getModuleSetRootDir() {
            return new FilePath(MavenBuild.this.getParent().getParent().getRootDir());
        }

        @Override
        @Deprecated
        public FilePath getArtifactsDir() {
            return new FilePath(MavenBuild.this.getArtifactsDir());
        }

        @Override
        public void queueArchiving(String artifactPath, String artifact) {
            this.artifacts.put(artifactPath, artifact);
        }

        void performArchiving(Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
            long startTime = System.currentTimeMillis();
            for (Map.Entry<String, String> e : this.artifacts.entrySet()) {
                listener.getLogger().println("[JENKINS] Archiving " + e.getValue() + " to " + e.getKey());
            }
            ArtifactManager am = MavenBuild.this.pickArtifactManager();
            FilePath ws = MavenBuild.this.getWorkspace();
            LinkedHashMap<String, String> artifactsInsideWorkspace = new LinkedHashMap<String, String>();
            String prefix = (String)ws.act((FilePath.FileCallable)new CanonicalPath()) + '/';
            Iterator<Map.Entry<String, String>> it = this.artifacts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> e = it.next();
                String p = (String)new FilePath(ws, e.getValue()).act((FilePath.FileCallable)new CanonicalPath());
                if (!p.startsWith(prefix)) {
                    listener.getLogger().println(p + " is not inside " + prefix + "; will archive in a separate pass");
                    continue;
                }
                artifactsInsideWorkspace.put(e.getKey(), p.substring(prefix.length()));
                it.remove();
            }
            if (!artifactsInsideWorkspace.isEmpty()) {
                am.archive(ws, launcher, listener, artifactsInsideWorkspace);
            }
            for (Map.Entry<String, String> e : this.artifacts.entrySet()) {
                FilePath f = new FilePath(ws, e.getValue());
                am.archive(f.getParent(), launcher, listener, Collections.singletonMap(e.getKey(), f.getName()));
            }
        }

        @Override
        public void setResult(Result result) {
            if (!MavenBuild.this.isBuilding()) {
                LOGGER.log(Level.WARNING, "JENKINS-25406: illegal attempt to change result from {0} to {1} after {2} finished building", new Object[]{MavenBuild.this.getResult(), result, MavenBuild.this});
                return;
            }
            MavenBuild.this.setResult(result);
        }

        @Override
        public Calendar getTimestamp() {
            return MavenBuild.this.getTimestamp();
        }

        @Override
        public long getMilliSecsSinceBuildStart() {
            return System.currentTimeMillis() - this.getTimestamp().getTimeInMillis();
        }

        @Override
        public boolean isArchivingDisabled() {
            return MavenBuild.this.getParent().getParent().isArchivingDisabled();
        }

        @Override
        public boolean isSiteArchivingDisabled() {
            return MavenBuild.this.getParent().getParent().isSiteArchivingDisabled();
        }

        @Override
        public void registerAsProjectAction(MavenReporter reporter) {
            MavenBuild.this.registerAsProjectAction(reporter);
        }

        @Override
        public void registerAsProjectAction(MavenProjectActionBuilder builder) {
            MavenBuild.this.registerAsProjectAction(builder);
        }

        @Override
        public void registerAsAggregatedProjectAction(MavenReporter reporter) {
            MavenModuleSetBuild pb = MavenBuild.this.getParentBuild();
            if (pb != null) {
                pb.registerAsProjectAction(reporter);
            }
        }

        @Override
        public void setExecutedMojos(List<ExecutedMojo> executedMojos) {
            MavenBuild.this.executedMojos = executedMojos;
        }

        private Object writeReplace() {
            return Channel.current().export(MavenBuildProxy.class, (Object)this);
        }

        @Override
        public MavenBuildInformation getMavenBuildInformation() {
            return new MavenBuildInformation(MavenBuild.this.getModuleSetBuild().getMavenVersionUsed());
        }
    }

    private static final class Builder
    extends MavenBuilder {
        private final MavenBuildProxy buildProxy;
        private final AtomicBoolean hasTestFailures = new AtomicBoolean();
        private final List<ExecutedMojo> executedMojos = new ArrayList<ExecutedMojo>();
        private final ModuleName moduleName;
        private long startTime;
        private static final long serialVersionUID = 1L;

        public Builder(BuildListener listener, MavenBuildProxy buildProxy, MavenModule module, List<String> goals, Map<String, String> systemProps) {
            super(listener, Collections.singleton(module), goals, systemProps);
            this.buildProxy = new FilterImpl(buildProxy);
            this.moduleName = module.getModuleName();
        }

        @Deprecated
        @CheckForNull
        private static MavenProject getTopLevelProject(ReactorManager rm) throws BuildFailureException {
            ProjectSorter sorter;
            List sortedProjects = rm.getSortedProjects();
            if (sortedProjects.isEmpty()) {
                return null;
            }
            try {
                sorter = new ProjectSorter((Collection)sortedProjects);
            }
            catch (CycleDetectedException ex) {
                throw new BuildFailureException("Cannot retrieve the top-level project due to the cycle", (Throwable)ex);
            }
            catch (DuplicateProjectException ex) {
                throw new BuildFailureException("Cannot retrieve the duplicate in the project list", (Throwable)ex);
            }
            return sorter.getTopLevelProject();
        }

        @Override
        void preBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                r.preBuild(this.buildProxy, Builder.getTopLevelProject(rm), this.listener);
            }
        }

        @Override
        void postBuild(MavenSession session, ReactorManager rm, EventDispatcher dispatcher) throws BuildFailureException, LifecycleExecutionException, IOException, InterruptedException {
            this.buildProxy.setExecutedMojos(this.executedMojos);
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                r.postBuild(this.buildProxy, Builder.getTopLevelProject(rm), this.listener);
            }
        }

        @Override
        void preExecute(MavenProject project, MojoInfo info) throws IOException, InterruptedException, hudson.maven.agent.AbortException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (r.preExecute(this.buildProxy, project, info, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(r + " failed");
            }
            this.startTime = System.currentTimeMillis();
        }

        @Override
        void postExecute(MavenProject project, MojoInfo info, Exception exception) throws IOException, InterruptedException, hudson.maven.agent.AbortException {
            this.executedMojos.add(new ExecutedMojo(info, System.currentTimeMillis() - this.startTime));
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (!r.postExecute(this.buildProxy, project, info, this.listener, exception)) {
                    throw new hudson.maven.agent.AbortException(r + " failed");
                }
                if (!(r instanceof TestFailureDetector) || !((TestFailureDetector)r).hasTestFailures()) continue;
                this.hasTestFailures.compareAndSet(false, true);
            }
        }

        @Override
        void onReportGenerated(MavenProject project, MavenReportInfo report) throws IOException, InterruptedException, hudson.maven.agent.AbortException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (r.reportGenerated(this.buildProxy, project, report, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(r + " failed");
            }
        }

        @Override
        void preModule(MavenProject project) throws InterruptedException, IOException, hudson.maven.agent.AbortException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (r.enterModule(this.buildProxy, project, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(r + " failed");
            }
        }

        @Override
        void postModule(MavenProject project) throws InterruptedException, IOException, hudson.maven.agent.AbortException {
            for (MavenReporter r : (List)this.reporters.get(this.moduleName)) {
                if (r.leaveModule(this.buildProxy, project, this.listener)) continue;
                throw new hudson.maven.agent.AbortException(r + " failed");
            }
        }

        @Override
        public boolean hasBuildFailures() {
            return this.hasTestFailures.get();
        }

        private class FilterImpl
        extends MavenBuildProxy.Filter<MavenBuildProxy>
        implements Serializable {
            private static final long serialVersionUID = 1L;

            public FilterImpl(MavenBuildProxy buildProxy) {
                super(buildProxy);
            }

            @Override
            public void executeAsync(MavenBuildProxy.BuildCallable<?, ?> program) throws IOException {
                Builder.this.recordAsynchronousExecution(Channel.current().callAsync((Callable)new MavenBuildProxy.Filter.AsyncInvoker(this.core, program)));
            }
        }
    }
}

