/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenEmbedder;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenEmbedderRequest;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenUtil;
import hudson.maven.Messages;
import hudson.maven.reporters.MavenAbstractArtifactRecord;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jenkins.model.Jenkins;
import jenkins.mvn.GlobalSettingsProvider;
import jenkins.mvn.SettingsProvider;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.cli.transfer.BatchModeMavenTransferListener;
import org.apache.maven.repository.Proxy;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.transfer.TransferListener;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class RedeployPublisher
extends Recorder {
    public final String id;
    public final String url;
    public final boolean uniqueVersion;
    public final boolean evenIfUnstable;
    public final String releaseEnvVar;

    @Deprecated
    public RedeployPublisher(String id, String url, boolean uniqueVersion) {
        this(id, url, uniqueVersion, false, null);
    }

    @Deprecated
    public RedeployPublisher(String id, String url, boolean uniqueVersion, boolean evenIfUnstable) {
        this(id, url, uniqueVersion, evenIfUnstable, null);
    }

    @DataBoundConstructor
    public RedeployPublisher(String id, String url, boolean uniqueVersion, boolean evenIfUnstable, String releaseEnvVar) {
        this.id = id;
        this.url = Util.fixEmptyAndTrim((String)url);
        this.uniqueVersion = uniqueVersion;
        this.evenIfUnstable = evenIfUnstable;
        this.releaseEnvVar = Util.fixEmptyAndTrim((String)releaseEnvVar);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String envVarValue;
        if (build.getResult().isWorseThan(this.getTreshold())) {
            return true;
        }
        if (this.releaseEnvVar != null && "true".equals(envVarValue = (String)build.getEnvironment((TaskListener)listener).get((Object)this.releaseEnvVar))) {
            listener.getLogger().println("[INFO] Skipping deploying artifact as release build is in progress.");
            return true;
        }
        List<MavenAbstractArtifactRecord> mavenAbstractArtifactRecords = this.getActions(build, listener);
        if (mavenAbstractArtifactRecords == null || mavenAbstractArtifactRecords.isEmpty()) {
            listener.getLogger().println("[ERROR] No artifacts are recorded. Is this a Maven project?");
            build.setResult(Result.FAILURE);
            return true;
        }
        if (build instanceof MavenModuleSetBuild && ((MavenModuleSetBuild)build).getParent().isArchivingDisabled()) {
            listener.getLogger().println("[ERROR] You cannot use the \"Deploy artifacts to Maven repository\" feature if you disabled automatic artifact archiving");
            build.setResult(Result.FAILURE);
            return true;
        }
        long startupTime = System.currentTimeMillis();
        try {
            MavenEmbedder embedder = this.createEmbedder((TaskListener)listener, build);
            ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)embedder.lookup(ArtifactRepositoryLayout.ROLE, "default");
            ArtifactRepositoryFactory factory = (ArtifactRepositoryFactory)embedder.lookup(ArtifactRepositoryFactory.ROLE);
            ArtifactRepository artifactRepository = null;
            if (this.url != null) {
                artifactRepository = this.getDeploymentRepository(factory, layout, this.id, this.url);
            }
            for (MavenAbstractArtifactRecord mavenAbstractArtifactRecord : mavenAbstractArtifactRecords) {
                if (artifactRepository == null && mavenAbstractArtifactRecord instanceof MavenArtifactRecord) {
                    MavenArtifactRecord mavenArtifactRecord = (MavenArtifactRecord)mavenAbstractArtifactRecord;
                    artifactRepository = this.getDeploymentRepository(factory, layout, mavenArtifactRecord.repositoryId, mavenArtifactRecord.repositoryUrl);
                }
                if (artifactRepository == null) {
                    listener.getLogger().println("[ERROR] No Repository settings defined in the job configuration or distributionManagement of the module.");
                    build.setResult(Result.FAILURE);
                    return true;
                }
                mavenAbstractArtifactRecord.deploy(embedder, artifactRepository, (TaskListener)listener);
            }
            listener.getLogger().println("[INFO] Deployment done in " + Util.getTimeSpanString((long)(System.currentTimeMillis() - startupTime)));
            return true;
        }
        catch (MavenEmbedderException | ArtifactDeploymentException | ComponentLookupException e) {
            e.printStackTrace(listener.error(e.getMessage()));
            build.setResult(Result.FAILURE);
            listener.getLogger().println("[INFO] Deployment failed after " + Util.getTimeSpanString((long)(System.currentTimeMillis() - startupTime)));
            return true;
        }
    }

    private ArtifactRepository getDeploymentRepository(ArtifactRepositoryFactory factory, ArtifactRepositoryLayout layout, String repositoryId, String repositoryUrl) throws ComponentLookupException {
        if (repositoryUrl == null) {
            return null;
        }
        ArtifactRepository repository = factory.createDeploymentArtifactRepository(repositoryId, repositoryUrl, layout, this.uniqueVersion);
        return new WrappedArtifactRepository(repository, this.uniqueVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="TODO needs triage")
    private MavenEmbedder createEmbedder(TaskListener listener, AbstractBuild<?, ?> build) throws MavenEmbedderException, IOException, InterruptedException {
        Object m = null;
        File settingsLoc = null;
        File remoteGlobalSettingsFromConfig = null;
        String profiles = null;
        Properties systemProperties = null;
        String privateRepository = null;
        File tmpSettings = File.createTempFile("jenkins", "temp-settings.xml");
        File tmpSettingsGlobal = File.createTempFile("jenkins", "temp-global-settings.xml");
        try {
            AbstractProject project = build.getProject();
            if ("hudson.plugins.promoted_builds.PromotionProcess".equals(project.getClass().getName())) {
                project = project.getRootProject();
            }
            if (project instanceof MavenModuleSet) {
                MavenModuleSet mavenModuleSet = (MavenModuleSet)project;
                profiles = mavenModuleSet.getProfiles();
                systemProperties = mavenModuleSet.getMavenProperties();
                Object altSettingsPath = SettingsProvider.getSettingsRemotePath((SettingsProvider)((MavenModuleSet)project).getSettings(), build, (TaskListener)listener);
                Node buildNode = build.getBuiltOn();
                if (buildNode == null) {
                    buildNode = Jenkins.get();
                }
                if (StringUtils.isBlank((String)altSettingsPath)) {
                    String remoteUserHome = (String)build.getWorkspace().act((Callable)new GetUserHome());
                    altSettingsPath = remoteUserHome + "/.m2/settings.xml";
                }
                FilePath filePath = new FilePath(tmpSettings);
                FilePath remoteSettings = build.getWorkspace().child((String)altSettingsPath);
                if (!remoteSettings.exists()) {
                    String mavenHome = ((MavenModuleSet)project).getMaven().forNode(buildNode, listener).getHome();
                    String settingsPath = mavenHome + "/conf/settings.xml";
                    remoteSettings = build.getWorkspace().child(settingsPath);
                }
                listener.getLogger().println("Maven RedeployPublisher use remote " + (buildNode != null ? buildNode.getNodeName() : "local") + " maven settings from : " + remoteSettings.getRemote());
                remoteSettings.copyTo(filePath);
                settingsLoc = tmpSettings;
                String remoteGlobalSettingsPath = GlobalSettingsProvider.getSettingsRemotePath((GlobalSettingsProvider)((MavenModuleSet)project).getGlobalSettings(), build, (TaskListener)listener);
                if (remoteGlobalSettingsPath != null) {
                    FilePath filePathGlobal = new FilePath(tmpSettingsGlobal);
                    FilePath remoteSettingsGlobal = build.getWorkspace().child(remoteGlobalSettingsPath);
                    listener.getLogger().println("Maven RedeployPublisher use remote " + (buildNode != null ? buildNode.getNodeName() : "local") + " maven global settings from : " + remoteSettingsGlobal.getRemote());
                    remoteSettingsGlobal.copyTo(filePathGlobal);
                    remoteGlobalSettingsFromConfig = tmpSettingsGlobal;
                }
            }
            MavenEmbedderRequest mavenEmbedderRequest = new MavenEmbedderRequest(listener, m != null ? m.getHomeDir() : null, profiles, systemProperties, privateRepository, settingsLoc);
            if (remoteGlobalSettingsFromConfig != null) {
                mavenEmbedderRequest.setGlobalSettings(remoteGlobalSettingsFromConfig);
            }
            mavenEmbedderRequest.setTransferListener((TransferListener)new BatchModeMavenTransferListener(listener.getLogger()));
            MavenEmbedder mavenEmbedder = MavenUtil.createEmbedder(mavenEmbedderRequest);
            return mavenEmbedder;
        }
        finally {
            if (tmpSettings != null) {
                tmpSettings.delete();
            }
            if (tmpSettingsGlobal != null) {
                tmpSettingsGlobal.delete();
            }
        }
    }

    protected MavenModuleSetBuild getMavenBuild(AbstractBuild<?, ?> build) {
        return build instanceof MavenModuleSetBuild ? (MavenModuleSetBuild)build : null;
    }

    protected List<MavenAbstractArtifactRecord> getActions(AbstractBuild<?, ?> build, BuildListener listener) {
        ArrayList<MavenAbstractArtifactRecord> actions = new ArrayList<MavenAbstractArtifactRecord>();
        MavenModuleSetBuild mavenBuild = this.getMavenBuild(build);
        if (mavenBuild == null) {
            return actions;
        }
        for (Map.Entry<MavenModule, MavenBuild> e : mavenBuild.getModuleLastBuilds().entrySet()) {
            MavenAbstractArtifactRecord a = (MavenAbstractArtifactRecord)e.getValue().getAction(MavenAbstractArtifactRecord.class);
            if (a == null) {
                listener.getLogger().println("No artifacts are recorded for module" + e.getKey().getName() + ". Is this a Maven project?");
                continue;
            }
            actions.add(a);
        }
        return actions;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    protected Result getTreshold() {
        if (this.evenIfUnstable) {
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    public static class WrappedArtifactRepository
    implements ArtifactRepository {
        private ArtifactRepository artifactRepository;
        private boolean uniqueVersion;
        private boolean blocked;

        public WrappedArtifactRepository(ArtifactRepository artifactRepository, boolean uniqueVersion) {
            this.artifactRepository = artifactRepository;
            this.uniqueVersion = uniqueVersion;
        }

        public String pathOf(Artifact artifact) {
            return this.artifactRepository.pathOf(artifact);
        }

        public String pathOfRemoteRepositoryMetadata(ArtifactMetadata artifactMetadata) {
            return this.artifactRepository.pathOfRemoteRepositoryMetadata(artifactMetadata);
        }

        public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
            return this.artifactRepository.pathOfLocalRepositoryMetadata(metadata, repository);
        }

        public String getUrl() {
            return this.artifactRepository.getUrl();
        }

        public void setUrl(String url) {
            this.artifactRepository.setUrl(url);
        }

        public String getBasedir() {
            return this.artifactRepository.getBasedir();
        }

        public String getProtocol() {
            return this.artifactRepository.getProtocol();
        }

        public String getId() {
            return this.artifactRepository.getId();
        }

        public void setId(String id) {
            this.artifactRepository.setId(id);
        }

        public ArtifactRepositoryPolicy getSnapshots() {
            return this.artifactRepository.getSnapshots();
        }

        public void setSnapshotUpdatePolicy(ArtifactRepositoryPolicy policy) {
            this.artifactRepository.setSnapshotUpdatePolicy(policy);
        }

        public ArtifactRepositoryPolicy getReleases() {
            return this.artifactRepository.getReleases();
        }

        public void setReleaseUpdatePolicy(ArtifactRepositoryPolicy policy) {
            this.artifactRepository.setReleaseUpdatePolicy(policy);
        }

        public ArtifactRepositoryLayout getLayout() {
            return this.artifactRepository.getLayout();
        }

        public void setLayout(ArtifactRepositoryLayout layout) {
            this.artifactRepository.setLayout(layout);
        }

        public String getKey() {
            return this.artifactRepository.getKey();
        }

        public boolean isUniqueVersion() {
            return this.uniqueVersion;
        }

        public void setUniqueVersion(boolean uniqueVersion) {
            this.uniqueVersion = uniqueVersion;
        }

        public boolean isBlacklisted() {
            return this.artifactRepository.isBlacklisted();
        }

        public void setBlacklisted(boolean blackListed) {
            this.artifactRepository.setBlacklisted(blackListed);
        }

        public Artifact find(Artifact artifact) {
            return this.artifactRepository.find(artifact);
        }

        public List<String> findVersions(Artifact artifact) {
            return this.artifactRepository.findVersions(artifact);
        }

        public boolean isProjectAware() {
            return this.artifactRepository.isProjectAware();
        }

        public void setAuthentication(Authentication authentication) {
            this.artifactRepository.setAuthentication(authentication);
        }

        public Authentication getAuthentication() {
            return this.artifactRepository.getAuthentication();
        }

        public void setProxy(Proxy proxy) {
            this.artifactRepository.setProxy(proxy);
        }

        public Proxy getProxy() {
            return this.artifactRepository.getProxy();
        }

        public List<ArtifactRepository> getMirroredRepositories() {
            return Collections.emptyList();
        }

        public void setMirroredRepositories(List<ArtifactRepository> arg0) {
        }

        public boolean isBlocked() {
            return this.blocked;
        }

        public void setBlocked(boolean blocked) {
            this.blocked = blocked;
        }
    }

    private static final class GetUserHome
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = -8755705771716056636L;

        private GetUserHome() {
        }

        public String call() throws IOException {
            return System.getProperty("user.home");
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
        }

        protected DescriptorImpl(Class<? extends Publisher> clazz) {
            super(clazz);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return jobType == MavenModuleSet.class;
        }

        public RedeployPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (RedeployPublisher)((Object)req.bindJSON(RedeployPublisher.class, formData));
        }

        public String getDisplayName() {
            return Messages.RedeployPublisher_getDisplayName();
        }

        public boolean showEvenIfUnstableOption() {
            return true;
        }
    }
}

