/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Util;
import hudson.maven.MavenEmbedder;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenEmbedderRequest;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenRequest;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tasks.Maven;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.mvn.SettingsProvider;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.cli.logging.Slf4jLoggerManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.logging.LoggerManager;

public class MavenUtil {
    public static boolean debugMavenEmbedder = Boolean.getBoolean("debugMavenEmbedder");
    private static final Logger LOGGER = Logger.getLogger(MavenUtil.class.getName());

    public static MavenEmbedder createEmbedder(TaskListener listener, String profiles) throws MavenEmbedderException, IOException {
        return MavenUtil.createEmbedder(listener, (File)null, profiles);
    }

    public static MavenEmbedder createEmbedder(TaskListener listener, AbstractProject<?, ?> project, String profiles) throws MavenEmbedderException, IOException, InterruptedException {
        Maven.MavenInstallation m = null;
        if (project instanceof Maven.ProjectWithMaven) {
            m = ((Maven.ProjectWithMaven)project).inferMavenInstallation().forNode((Node)Jenkins.get(), listener);
        }
        return MavenUtil.createEmbedder(listener, m != null ? m.getHomeDir() : null, profiles);
    }

    public static MavenEmbedder createEmbedder(TaskListener listener, AbstractBuild<?, ?> build) throws MavenEmbedderException, IOException, InterruptedException {
        Maven.MavenInstallation m = null;
        File settingsLoc = null;
        String profiles = null;
        Properties systemProperties = null;
        String privateRepository = null;
        AbstractProject project = build.getProject();
        if (project instanceof Maven.ProjectWithMaven) {
            m = ((Maven.ProjectWithMaven)project).inferMavenInstallation().forNode((Node)Jenkins.get(), listener);
        }
        if (project instanceof MavenModuleSet) {
            String altSet = SettingsProvider.getSettingsRemotePath((SettingsProvider)((MavenModuleSet)project).getSettings(), build, (TaskListener)listener);
            settingsLoc = altSet == null ? null : new File(build.getWorkspace().child(altSet).getRemote());
            FilePath localRepo = ((MavenModuleSet)project).getLocalRepository().locate((MavenModuleSetBuild)build);
            if (localRepo != null) {
                privateRepository = localRepo.getRemote();
            }
            profiles = ((MavenModuleSet)project).getProfiles();
            systemProperties = ((MavenModuleSet)project).getMavenProperties();
        }
        return MavenUtil.createEmbedder(new MavenEmbedderRequest(listener, m != null ? m.getHomeDir() : null, profiles, systemProperties, privateRepository, settingsLoc));
    }

    public static MavenEmbedder createEmbedder(TaskListener listener, File mavenHome, String profiles) throws MavenEmbedderException, IOException {
        return MavenUtil.createEmbedder(listener, mavenHome, profiles, new Properties());
    }

    public static MavenEmbedder createEmbedder(TaskListener listener, File mavenHome, String profiles, Properties systemProperties) throws MavenEmbedderException, IOException {
        return MavenUtil.createEmbedder(listener, mavenHome, profiles, systemProperties, null);
    }

    public static MavenEmbedder createEmbedder(TaskListener listener, File mavenHome, String profiles, Properties systemProperties, String privateRepository) throws MavenEmbedderException, IOException {
        return MavenUtil.createEmbedder(new MavenEmbedderRequest(listener, mavenHome, profiles, systemProperties, privateRepository, null));
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public static MavenEmbedder createEmbedder(MavenEmbedderRequest mer) throws MavenEmbedderException, IOException {
        MavenRequest mavenRequest = new MavenRequest();
        File m2Home = new File(MavenEmbedder.userHome, ".m2");
        m2Home.mkdirs();
        if (!m2Home.exists()) {
            throw new AbortException("Failed to create " + m2Home);
        }
        if (mer.getPrivateRepository() != null) {
            mavenRequest.setLocalRepositoryPath(mer.getPrivateRepository());
        }
        if (mer.getProfiles() != null) {
            mavenRequest.setProfiles(Arrays.asList(StringUtils.split((String)mer.getProfiles(), (String)",")));
        }
        if (mer.getAlternateSettings() != null) {
            mavenRequest.setUserSettingsFile(mer.getAlternateSettings().getAbsolutePath());
        } else {
            mavenRequest.setUserSettingsFile(new File(m2Home, "settings.xml").getAbsolutePath());
        }
        if (mer.getGlobalSettings() != null) {
            mavenRequest.setGlobalSettingsFile(mer.getGlobalSettings().getAbsolutePath());
        } else {
            mavenRequest.setGlobalSettingsFile(new File(mer.getMavenHome(), "conf/settings.xml").getAbsolutePath());
        }
        if (mer.getWorkspaceReader() != null) {
            mavenRequest.setWorkspaceReader(mer.getWorkspaceReader());
        }
        mavenRequest.setUpdateSnapshots(mer.isUpdateSnapshots());
        mavenRequest.setSystemProperties(mer.getSystemProperties());
        if (mer.getTransferListener() != null) {
            if (debugMavenEmbedder) {
                mer.getListener().getLogger().println("use transfertListener " + mer.getTransferListener().getClass().getName());
            }
            mavenRequest.setTransferListener(mer.getTransferListener());
        }
        mavenRequest.setMavenLoggerManager((LoggerManager)new Slf4jLoggerManager());
        ClassLoader mavenEmbedderClassLoader = mer.getClassLoader();
        Enumeration<URL> e = mavenEmbedderClassLoader.getResources("META-INF/plexus/components.xml");
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            LOGGER.fine("components.xml from " + url);
        }
        mavenRequest.setProcessPlugins(mer.isProcessPlugins());
        mavenRequest.setResolveDependencies(mer.isResolveDependencies());
        mavenRequest.setValidationLevel(mer.getValidationLevel());
        MavenEmbedder maven = new MavenEmbedder(mavenEmbedderClassLoader, mavenRequest);
        return maven;
    }

    public static void resolveModules(MavenEmbedder embedder, MavenProject project, String rel, Map<MavenProject, String> relativePathInfo, BuildListener listener, boolean nonRecursive) throws ProjectBuildingException, AbortException, MavenEmbedderException {
        File basedir = project.getFile().getParentFile();
        relativePathInfo.put(project, rel);
        ArrayList<MavenProject> modules = new ArrayList<MavenProject>();
        if (!nonRecursive) {
            for (String modulePath : project.getModules()) {
                if (Util.fixEmptyAndTrim((String)modulePath) == null) continue;
                File moduleFile = new File(basedir, modulePath);
                if (moduleFile.exists() && moduleFile.isDirectory()) {
                    moduleFile = new File(basedir, modulePath + "/pom.xml");
                }
                if (!moduleFile.exists()) {
                    throw new AbortException(moduleFile + " is referenced from " + project.getFile() + " but it doesn't exist");
                }
                Object relativePath = rel;
                if (((String)relativePath).length() > 0) {
                    relativePath = (String)relativePath + "/";
                }
                relativePath = (String)relativePath + modulePath;
                MavenProject child = embedder.readProject(moduleFile);
                MavenUtil.resolveModules(embedder, child, (String)relativePath, relativePathInfo, listener, nonRecursive);
                modules.add(child);
            }
        }
        project.setCollectedProjects(modules);
    }

    public static boolean maven3orLater(String mavenVersion) {
        if (StringUtils.isBlank((String)mavenVersion)) {
            return false;
        }
        return new ComparableVersion(mavenVersion).compareTo(new ComparableVersion("3.0")) >= 0;
    }

    public static MavenVersion getMavenVersion(String mavenVersion) {
        if (StringUtils.isBlank((String)mavenVersion)) {
            return MavenVersion.MAVEN_2;
        }
        ComparableVersion maven3_0 = new ComparableVersion("3.0");
        ComparableVersion mavenCurrent = new ComparableVersion(mavenVersion);
        ComparableVersion maven2_0 = new ComparableVersion("2.0");
        if (mavenCurrent.compareTo(maven2_0) >= 0 && mavenCurrent.compareTo(maven3_0) < 0) {
            return MavenVersion.MAVEN_2;
        }
        ComparableVersion maven3_1_0 = new ComparableVersion("3.1.0");
        if (mavenCurrent.compareTo(maven3_0) >= 0 && mavenCurrent.compareTo(maven3_1_0) < 0) {
            return MavenVersion.MAVEN_3_0_X;
        }
        ComparableVersion maven3_2_0 = new ComparableVersion("3.2.0");
        if (mavenCurrent.compareTo(maven3_1_0) >= 0 && mavenCurrent.compareTo(maven3_2_0) < 0) {
            return MavenVersion.MAVEN_3_1;
        }
        ComparableVersion maven3_3_1 = new ComparableVersion("3.3.1");
        if (mavenCurrent.compareTo(maven3_2_0) >= 0 && mavenCurrent.compareTo(maven3_3_1) < 0) {
            return MavenVersion.MAVEN_3_2;
        }
        ComparableVersion maven3_5_0 = new ComparableVersion("3.5.0");
        if (mavenCurrent.compareTo(maven3_3_1) >= 0 && mavenCurrent.compareTo(maven3_5_0) < 0) {
            return MavenVersion.MAVEN_3_3;
        }
        return MavenVersion.MAVEN_3_5;
    }

    public static boolean supportEventSpy(String mavenVersion) {
        if (StringUtils.isBlank((String)mavenVersion)) {
            return false;
        }
        return new ComparableVersion(mavenVersion).compareTo(new ComparableVersion("3.1.0")) >= 0;
    }

    public static String resolveVersion(String version, MavenProject project) {
        int tokenIdx = version.indexOf("${");
        if (tokenIdx == -1) {
            LOGGER.finest("Returning version " + version + " unchanged");
            return version;
        }
        Properties props = project.getProperties();
        if (props != null) {
            if (tokenIdx == 0) {
                if (version.indexOf("}") == version.length() - 1) {
                    String propName = version.substring(2, version.length() - 1);
                    if (props.containsKey(propName)) {
                        String value = props.getProperty(propName);
                        LOGGER.finest("Found property value " + value + " for version " + version);
                        return value;
                    }
                    LOGGER.finest("No property found for " + propName);
                } else {
                    LOGGER.finest("Matching curly brace not at end of version " + version);
                }
            }
        } else {
            LOGGER.finest("No properties to resolve version " + version);
        }
        LOGGER.fine("Could not resolve version " + version + ", returning null instead");
        return null;
    }

    public static enum MavenVersion {
        MAVEN_2,
        MAVEN_3_0_X,
        MAVEN_3_1,
        MAVEN_3_2,
        MAVEN_3_3,
        MAVEN_3_5;

    }
}

