/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.InternalErrorException;
import org.apache.maven.exception.DefaultExceptionHandler;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.jvnet.hudson.maven3.listeners.HudsonMavenExecutionResult;
import org.jvnet.hudson.maven3.listeners.MavenProjectInfo;
import org.slf4j.Logger;

class Maven3FailureLogger {
    private Logger slf4jLogger;
    boolean showErrors = false;
    boolean failNever = false;

    public Maven3FailureLogger(Logger slf4jLogger) {
        this.slf4jLogger = slf4jLogger;
    }

    public void logFailures(HudsonMavenExecutionResult result) {
        if (!result.getThrowables().isEmpty()) {
            DefaultExceptionHandler handler = new DefaultExceptionHandler();
            LinkedHashMap<String, String> references = new LinkedHashMap<String, String>();
            MavenProject project = null;
            for (Throwable throwable : result.getThrowables()) {
                ExceptionSummary summary = handler.handleException(throwable);
                this.logSummary(summary, references, "", this.showErrors);
                if (project != null || !(throwable instanceof LifecycleExecutionException)) continue;
                project = ((LifecycleExecutionException)throwable).getProject();
            }
            this.slf4jLogger.error("");
            if (!this.showErrors) {
                this.slf4jLogger.error("To see the full stack trace of the errors, re-run Maven with the -e switch.");
            }
            if (!this.slf4jLogger.isDebugEnabled()) {
                this.slf4jLogger.error("Re-run Maven using the -X switch to enable full debug logging.");
            }
            if (!references.isEmpty()) {
                this.slf4jLogger.error("");
                this.slf4jLogger.error("For more information about the errors and possible solutions, please read the following articles:");
                for (Map.Entry entry : references.entrySet()) {
                    this.slf4jLogger.error((String)entry.getValue() + " " + (String)entry.getKey());
                }
            }
            if (project != null && !project.equals((Object)this.convert((MavenProjectInfo)result.getMavenProjectInfos().get(0)))) {
                this.slf4jLogger.error("");
                this.slf4jLogger.error("After correcting the problems, you can resume the build with the command");
                this.slf4jLogger.error("  mvn <goals> -rf :" + project.getArtifactId());
            }
            if (this.failNever) {
                this.slf4jLogger.info("Build failures were ignored.");
            }
        }
    }

    private void logSummary(ExceptionSummary summary, Map<String, String> references, String indent, boolean showErrors) {
        Object referenceKey = "";
        if (StringUtils.isNotEmpty((String)summary.getReference()) && (referenceKey = references.get(summary.getReference())) == null) {
            referenceKey = "[Help " + (references.size() + 1) + "]";
            references.put(summary.getReference(), (String)referenceKey);
        }
        Object msg = summary.getMessage();
        if (StringUtils.isNotEmpty((String)referenceKey)) {
            msg = ((String)msg).indexOf(10) < 0 ? (String)msg + " -> " + (String)referenceKey : (String)msg + "\n-> " + (String)referenceKey;
        }
        String[] lines = ((String)msg).split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < lines.length; ++i) {
            String line = (String)indent + lines[i].trim();
            if (i == lines.length - 1 && (showErrors || summary.getException() instanceof InternalErrorException)) {
                this.slf4jLogger.error(line, summary.getException());
                continue;
            }
            this.slf4jLogger.error(line);
        }
        indent = (String)indent + "  ";
        for (ExceptionSummary child : summary.getChildren()) {
            this.logSummary(child, references, (String)indent, showErrors);
        }
    }

    private MavenProject convert(MavenProjectInfo prjInfo) {
        MavenProject prj = new MavenProject();
        prj.setArtifactId(prjInfo.getArtifactId());
        prj.setGroupId(prjInfo.getGroupId());
        prj.setVersion(prjInfo.getVersion());
        return prj;
    }

    public void setOptions(List<String> goals) {
        this.showErrors = goals.contains("-X") || goals.contains("-e");
        this.failNever = goals.contains("-fn");
    }
}

