/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.util;

import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEventLogger
extends org.apache.maven.cli.event.ExecutionEventLogger {
    private final Logger logger;
    private final String mojoNote;

    public ExecutionEventLogger() {
        this.logger = LoggerFactory.getLogger(ExecutionEventLogger.class);
        this.mojoNote = null;
    }

    @Deprecated
    public ExecutionEventLogger(Logger logger) {
        this(logger, null);
    }

    public ExecutionEventLogger(Logger logger, String mojoNote) {
        super(logger);
        this.logger = logger;
        this.mojoNote = mojoNote;
    }

    public void mojoStarted(ExecutionEvent event) {
        if (this.mojoNote != null && this.logger.isInfoEnabled()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.mojoNote);
            buffer.append("--- ");
            this.append(buffer, event.getMojoExecution());
            this.append(buffer, event.getProject());
            buffer.append(" ---");
            this.logger.info("");
            this.logger.info(buffer.toString());
        }
    }

    private void append(StringBuilder buffer, MojoExecution me) {
        buffer.append(me.getArtifactId()).append(':').append(me.getVersion());
        buffer.append(':').append(me.getGoal());
        if (me.getExecutionId() != null) {
            buffer.append(" (").append(me.getExecutionId()).append(')');
        }
    }

    private void append(StringBuilder buffer, MavenProject project) {
        buffer.append(" @ ").append(project.getArtifactId());
    }
}

