/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.Extension;
import hudson.Launcher;
import hudson.maven.MavenBuild;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.reporters.Messages;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.tasks.MailSender;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class MavenMailer
extends MavenReporter {
    private static final Logger LOGGER = Logger.getLogger(MavenMailer.class.getName());
    public String recipients;
    public String mavenRecipients;
    public boolean dontNotifyEveryUnstableBuild;
    public boolean sendToIndividuals;
    public boolean perModuleEmail;
    private static final long serialVersionUID = 1L;

    @Deprecated
    public MavenMailer() {
    }

    @DataBoundConstructor
    public MavenMailer(String recipients, boolean notifyEveryUnstableBuild, boolean sendToIndividuals, boolean perModuleEmail) {
        this.recipients = recipients;
        this.dontNotifyEveryUnstableBuild = !notifyEveryUnstableBuild;
        this.sendToIndividuals = sendToIndividuals;
        this.perModuleEmail = perModuleEmail;
    }

    public boolean isNotifyEveryUnstableBuild() {
        return !this.dontNotifyEveryUnstableBuild;
    }

    @Override
    public boolean end(MavenBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.perModuleEmail) {
            LOGGER.log(Level.FINE, "for {0} potentially mailing to {1} plus {2}", new Object[]{build, this.recipients, this.mavenRecipients});
            if (this.sendToIndividuals) {
                LOGGER.log(Level.FINE, "would also include {0}", build.getCulprits());
            }
            new MailSender(this.getAllRecipients(), this.dontNotifyEveryUnstableBuild, this.sendToIndividuals).execute((AbstractBuild)build, listener);
        }
        return true;
    }

    public String getAllRecipients() {
        StringBuilder sb = new StringBuilder();
        if (this.recipients != null) {
            sb.append(this.recipients);
        }
        if (this.mavenRecipients != null) {
            sb.append(" ");
            sb.append(this.mavenRecipients);
        }
        return sb.toString().trim();
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return Messages.MavenMailer_DisplayName();
        }
    }
}

