/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.maven.AggregatableAction;
import hudson.maven.MavenBuild;
import hudson.maven.MavenEmbedder;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenUtil;
import hudson.maven.RedeployPublisher;
import hudson.maven.reporters.MavenAbstractArtifactRecord;
import hudson.maven.reporters.MavenAggregatedArtifactRecord;
import hudson.maven.reporters.MavenArtifact;
import hudson.maven.reporters.Messages;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.GroupRepositoryMetadata;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class MavenArtifactRecord
extends MavenAbstractArtifactRecord<MavenBuild>
implements AggregatableAction {
    @Exported
    public final MavenBuild parent;
    @Exported(inline=true)
    public final MavenArtifact pomArtifact;
    @Exported(inline=true)
    public final MavenArtifact mainArtifact;
    @Exported(inline=true)
    public final List<MavenArtifact> attachedArtifacts;
    public final String repositoryId;
    public final String repositoryUrl;

    @Deprecated
    public MavenArtifactRecord(MavenBuild parent, MavenArtifact pomArtifact, MavenArtifact mainArtifact, List<MavenArtifact> attachedArtifacts) {
        this(parent, pomArtifact, mainArtifact, attachedArtifacts, null, null);
    }

    public MavenArtifactRecord(MavenBuild parent, MavenArtifact pomArtifact, MavenArtifact mainArtifact, List<MavenArtifact> attachedArtifacts, String repositoryUrl, String repositoryId) {
        assert (parent != null);
        assert (pomArtifact != null);
        assert (attachedArtifacts != null);
        if (mainArtifact == null) {
            mainArtifact = pomArtifact;
        }
        this.parent = parent;
        this.pomArtifact = pomArtifact;
        this.mainArtifact = mainArtifact;
        this.attachedArtifacts = attachedArtifacts;
        this.repositoryUrl = repositoryUrl;
        this.repositoryId = repositoryId;
    }

    @Override
    public MavenBuild getBuild() {
        return this.parent;
    }

    public String getUrl() {
        return this.parent.getUrl() + "mavenArtifacts/";
    }

    @Exported(visibility=2, name="url")
    public String getAbsoluteUrl() {
        return this.parent.getAbsoluteUrl() + "mavenArtifacts/";
    }

    public boolean isPOM() {
        return this.mainArtifact.isPOM();
    }

    @Override
    public MavenAggregatedArtifactRecord createAggregatedAction(MavenModuleSetBuild build, Map<MavenModule, List<MavenBuild>> moduleBuilds) {
        return new MavenAggregatedArtifactRecord(build);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(MavenEmbedder embedder, ArtifactRepository deploymentRepository, TaskListener listener) throws MavenEmbedderException, IOException, ComponentLookupException, ArtifactDeploymentException {
        ArtifactDeployer deployer;
        ArtifactHandlerManager handlerManager = (ArtifactHandlerManager)embedder.lookup(ArtifactHandlerManager.class);
        ArtifactFactory artifactFactory = (ArtifactFactory)embedder.lookup(ArtifactFactory.class);
        PrintStream logger = listener.getLogger();
        boolean maven3orLater = MavenUtil.maven3orLater(this.parent.getModuleSetBuild().getMavenVersionUsed());
        boolean uniqueVersion = true;
        if (!deploymentRepository.isUniqueVersion()) {
            if (maven3orLater) {
                logger.println("[ERROR] uniqueVersion == false is not anymore supported in maven 3");
            } else {
                ((RedeployPublisher.WrappedArtifactRepository)deploymentRepository).setUniqueVersion(false);
                uniqueVersion = false;
            }
        } else {
            ((RedeployPublisher.WrappedArtifactRepository)deploymentRepository).setUniqueVersion(true);
        }
        try (MavenArtifact.CloseableArtifact mainC = this.mainArtifact.toCloseableArtifact(handlerManager, artifactFactory, this.parent);){
            Artifact main = mainC.get();
            MavenArtifact.TemporaryFile pomFile = null;
            if (!this.isPOM()) {
                pomFile = this.pomArtifact.getTemporaryFile(this.parent);
                main.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(main, pomFile.getFile()));
            }
            try {
                if (main.getType().equals("maven-plugin")) {
                    GroupRepositoryMetadata metadata = new GroupRepositoryMetadata(main.getGroupId());
                    String goalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)main.getArtifactId());
                    metadata.addPluginMapping(goalPrefix, main.getArtifactId(), null);
                    main.addMetadata((ArtifactMetadata)metadata);
                }
                deployer = (ArtifactDeployer)embedder.lookup(ArtifactDeployer.class, uniqueVersion ? "default" : "maven2");
                logger.println("[INFO] Deployment in " + deploymentRepository.getUrl() + " (id=" + deploymentRepository.getId() + ",uniqueVersion=" + deploymentRepository.isUniqueVersion() + ")");
                logger.println(Messages.MavenArtifact_DeployingMainArtifact(main.getFile().getName()));
                deployer.deploy(main.getFile(), main, deploymentRepository, embedder.getLocalRepository());
            }
            finally {
                if (pomFile != null) {
                    pomFile.close();
                }
            }
        }
        for (MavenArtifact aa : this.attachedArtifacts) {
            try (MavenArtifact.CloseableArtifact aC = aa.toCloseableArtifact(handlerManager, artifactFactory, this.parent);){
                Artifact a = aC.get();
                logger.println(Messages.MavenArtifact_DeployingMainArtifact(a.getFile().getName()));
                deployer.deploy(a.getFile(), a, deploymentRepository, embedder.getLocalRepository());
            }
        }
    }
}

