/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.maven.AbstractMavenBuild;
import hudson.maven.AbstractMavenBuilder;
import hudson.maven.AbstractMavenProcessFactory;
import hudson.maven.AggregatableAction;
import hudson.maven.Maven2Builder;
import hudson.maven.Maven31ProcessFactory;
import hudson.maven.Maven32ProcessFactory;
import hudson.maven.Maven33ProcessFactory;
import hudson.maven.Maven35ProcessFactory;
import hudson.maven.Maven3Builder;
import hudson.maven.Maven3ProcessFactory;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenArgumentInterceptorAction;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildInformation;
import hudson.maven.MavenEmbedder;
import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenEmbedderRequest;
import hudson.maven.MavenInformation;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenProbeAction;
import hudson.maven.MavenProcessFactory;
import hudson.maven.MavenReporter;
import hudson.maven.MavenUtil;
import hudson.maven.MavenVersionCallable;
import hudson.maven.Messages;
import hudson.maven.ModuleName;
import hudson.maven.NeedsFullBuildAction;
import hudson.maven.PlexusModuleContributor;
import hudson.maven.PlexusModuleContributorFactory;
import hudson.maven.PomInfo;
import hudson.maven.ProcessCache;
import hudson.maven.ReactorReader;
import hudson.maven.SplittableBuildListener;
import hudson.maven.UnbuiltModuleAction;
import hudson.maven.reporters.MavenAggregatedArtifactRecord;
import hudson.maven.reporters.MavenFingerprinter;
import hudson.maven.reporters.MavenMailer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Environment;
import hudson.model.Executor;
import hudson.model.Fingerprint;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import hudson.tasks.MailSender;
import hudson.tasks.Maven;
import hudson.util.ArgumentListBuilder;
import hudson.util.IOUtils;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.maven3.agent.Maven31Main;
import jenkins.maven3.agent.Maven32Main;
import jenkins.maven3.agent.Maven33Main;
import jenkins.maven3.agent.Maven35Main;
import jenkins.model.Jenkins;
import jenkins.mvn.GlobalSettingsProvider;
import jenkins.mvn.SettingsProvider;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.util.PathTool;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.jvnet.hudson.maven3.agent.Maven3Main;
import org.jvnet.hudson.maven3.launcher.Maven31Launcher;
import org.jvnet.hudson.maven3.launcher.Maven32Launcher;
import org.jvnet.hudson.maven3.launcher.Maven33Launcher;
import org.jvnet.hudson.maven3.launcher.Maven35Launcher;
import org.jvnet.hudson.maven3.launcher.Maven3Launcher;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public class MavenModuleSetBuild
extends AbstractMavenBuild<MavenModuleSet, MavenModuleSetBuild> {
    List<MavenReporter> projectActionReporters;
    private String mavenVersionUsed;
    private transient Object notifyModuleBuildLock = new Object();
    private transient Result effectiveResult;
    private static final Logger LOGGER = Logger.getLogger(MavenModuleSetBuild.class.getName());
    public static boolean debug = Boolean.getBoolean("hudson.maven.debug");

    public MavenModuleSetBuild(MavenModuleSet job) throws IOException {
        super(job);
    }

    public MavenModuleSetBuild(MavenModuleSet project, File buildDir) throws IOException {
        super(project, buildDir);
    }

    protected void onLoad() {
        super.onLoad();
        this.notifyModuleBuildLock = new Object();
    }

    @Override
    public EnvVars getEnvironment(TaskListener log) throws IOException, InterruptedException {
        MavenModule root;
        Node node;
        EnvVars envs = super.getEnvironment(log);
        Maven.MavenInstallation mvn = ((MavenModuleSet)this.project).getMaven();
        if (mvn == null) {
            throw new AbortException(Messages.MavenModuleSetBuild_NoMavenConfigured());
        }
        mvn = mvn.forEnvironment(envs);
        Computer computer = Computer.currentComputer();
        if (computer != null && (node = computer.getNode()) != null) {
            mvn = mvn.forNode(node, log);
            mvn.buildEnvVars(envs);
        }
        if ((root = ((MavenModuleSet)this.getProject()).getRootModule()) != null) {
            envs.putIfNotNull("POM_DISPLAYNAME", root.getDisplayName());
            envs.putIfNotNull("POM_VERSION", root.getVersion());
            envs.putIfNotNull("POM_GROUPID", root.getGroupId());
            envs.putIfNotNull("POM_ARTIFACTID", root.getArtifactId());
            envs.putIfNotNull("POM_PACKAGING", root.getPackaging());
        }
        return envs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getResult() {
        if (this.isBuilding()) {
            return this.computeResult();
        }
        Object object = this.notifyModuleBuildLock;
        synchronized (object) {
            if (this.effectiveResult == null) {
                this.effectiveResult = this.computeResult();
            }
            return this.effectiveResult;
        }
    }

    private Result computeResult() {
        Result r = super.getResult();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Current result is: " + r);
        }
        for (MavenBuild b : this.getModuleLastBuilds().values()) {
            Result br = b.getResult();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Module result is: " + br + " for " + b.getParent().getGroupId() + ":" + b.getParent().getArtifactId());
            }
            if (r == null) {
                r = br;
            } else {
                if (br == Result.NOT_BUILT || br == Result.ABORTED) {
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.finest("Result not updated: " + r);
                    continue;
                }
                if (br != null) {
                    r = r.combine(br);
                }
            }
            if (!LOGGER.isLoggable(Level.FINEST)) continue;
            LOGGER.finest("New result is: " + r);
        }
        return r;
    }

    List<ChangeLogSet.Entry> getChangeSetFor(final MavenModule mod) {
        return new ArrayList<ChangeLogSet.Entry>(){
            private static final long serialVersionUID = 5572368347535713298L;
            {
                List<MavenModule> subsidiaries = null;
                for (ChangeLogSet.Entry e : MavenModuleSetBuild.this.getChangeSet()) {
                    Collection affectedPaths = e.getAffectedPaths();
                    if (!this.isDescendantOf(affectedPaths, mod)) {
                        LOGGER.log(Level.FINEST, "{0} are not a descendant of {1}", new Object[]{affectedPaths, mod});
                        continue;
                    }
                    if (subsidiaries == null) {
                        subsidiaries = mod.getSubsidiaries();
                    }
                    if (this.notInSubsidiary(subsidiaries, affectedPaths)) {
                        LOGGER.log(Level.FINEST, "{0} are indeed in the change set for {1}", new Object[]{affectedPaths, mod});
                        this.add(e);
                        continue;
                    }
                    LOGGER.log(Level.FINEST, "{0} are in subsidiaries {1} of {2}", new Object[]{affectedPaths, subsidiaries, mod});
                }
            }

            private boolean notInSubsidiary(List<MavenModule> subsidiaries, Collection<String> affectedPaths) {
                for (String path : affectedPaths) {
                    if (!this.isDescendantOf(path, mod) || this.belongsToSubsidiary(subsidiaries, path)) continue;
                    return true;
                }
                return false;
            }

            private boolean belongsToSubsidiary(List<MavenModule> subsidiaries, String path) {
                for (MavenModule sub : subsidiaries) {
                    if (!this.isDescendantOf(path, sub)) continue;
                    return true;
                }
                return false;
            }

            private boolean isDescendantOf(Collection<String> affectedPaths, MavenModule mod2) {
                for (String path : affectedPaths) {
                    if (!this.isDescendantOf(path, mod2)) continue;
                    return true;
                }
                return false;
            }

            private boolean isDescendantOf(String path, MavenModule mod2) {
                return FilenameUtils.separatorsToUnix((String)path).startsWith(MavenModuleSetBuild.normalizePath(mod2.getRelativePath()));
            }
        };
    }

    public Map<MavenModule, List<MavenBuild>> getModuleBuilds() {
        Collection<MavenModule> mods = this.getParent().getModules();
        MavenModuleSetBuild nb = (MavenModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() : Integer.MAX_VALUE;
        LinkedHashMap<MavenModule, List<MavenBuild>> r = new LinkedHashMap<MavenModule, List<MavenBuild>>(mods.size());
        for (MavenModule m : mods) {
            ArrayList<MavenBuild> builds = new ArrayList<MavenBuild>();
            for (MavenBuild b = (MavenBuild)m.getNearestBuild(this.number); b != null && b.getNumber() < end; b = (MavenBuild)b.getNextBuild()) {
                builds.add(b);
            }
            r.put(m, builds);
        }
        return r;
    }

    public long getEstimatedDuration() {
        if (!((MavenModuleSet)this.project).isIncrementalBuild()) {
            return super.getEstimatedDuration();
        }
        long result = 0L;
        Map<MavenModule, List<MavenBuild>> moduleBuilds = this.getModuleBuilds();
        boolean noModuleBuildsYet = true;
        for (List<MavenBuild> builds : moduleBuilds.values()) {
            if (builds.isEmpty()) continue;
            noModuleBuildsYet = false;
            MavenBuild build = builds.get(0);
            if (build.getResult() == Result.NOT_BUILT || build.getEstimatedDuration() == -1L) continue;
            result += build.getEstimatedDuration();
        }
        if (noModuleBuildsYet) {
            return super.getEstimatedDuration();
        }
        return (result += this.estimateModuleSetBuildDurationOverhead(3)) != 0L ? result : -1L;
    }

    private long estimateModuleSetBuildDurationOverhead(int numberOfBuilds) {
        List<MavenModuleSetBuild> moduleSetBuilds = this.getParent().getEstimatedDurationCandidates();
        if (moduleSetBuilds.isEmpty()) {
            return 0L;
        }
        long overhead = 0L;
        for (MavenModuleSetBuild moduleSetBuild : moduleSetBuilds) {
            long sumOfModuleBuilds = 0L;
            for (List<MavenBuild> builds : moduleSetBuild.getModuleBuilds().values()) {
                if (builds.isEmpty()) continue;
                MavenBuild moduleBuild = builds.get(0);
                sumOfModuleBuilds += moduleBuild.getDuration();
            }
            overhead += Math.max(0L, moduleSetBuild.getDuration() - sumOfModuleBuilds);
        }
        return Math.round((double)overhead / (double)moduleSetBuilds.size());
    }

    private static String normalizePath(String relPath) {
        if (StringUtils.isEmpty((String)(relPath = StringUtils.trimToEmpty((String)relPath)))) {
            LOGGER.config("No need to normalize an empty path.");
        } else if (FilenameUtils.indexOfLastSeparator((String)relPath) == -1) {
            LOGGER.config("No need to normalize " + relPath);
        } else {
            String tmp = FilenameUtils.normalize((String)relPath);
            if (tmp == null) {
                LOGGER.config("Path " + relPath + " can not be normalized (parent dir is unknown). Keeping as is.");
            } else {
                LOGGER.config("Normalized path " + relPath + " to " + tmp);
                relPath = tmp;
            }
            relPath = FilenameUtils.separatorsToUnix((String)relPath);
        }
        LOGGER.fine("Returning path " + relPath);
        return relPath;
    }

    @Exported
    public String getMavenVersionUsed() {
        return this.mavenVersionUsed;
    }

    public void setMavenVersionUsed(String mavenVersionUsed) throws IOException {
        this.mavenVersionUsed = Util.intern((String)mavenVersionUsed);
        this.save();
    }

    public synchronized void delete() throws IOException {
        super.delete();
        for (List<MavenBuild> list : this.getModuleBuilds().values()) {
            for (MavenBuild build : list) {
                build.delete();
            }
        }
    }

    public synchronized void deleteArtifacts() throws IOException {
        super.deleteArtifacts();
        for (List<MavenBuild> list : this.getModuleBuilds().values()) {
            for (MavenBuild build : list) {
                build.deleteArtifacts();
            }
        }
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        MavenModule m;
        if (token.indexOf(36) > 0 && (m = ((MavenModuleSet)this.getProject()).getModule(token)) != null) {
            return m.getBuildByNumber(this.getNumber());
        }
        return super.getDynamic(token, req, rsp);
    }

    @Exported
    public MavenAggregatedArtifactRecord getMavenArtifacts() {
        return (MavenAggregatedArtifactRecord)this.getAction(MavenAggregatedArtifactRecord.class);
    }

    public Map<MavenModule, MavenBuild> getModuleLastBuilds() {
        Collection<MavenModule> mods = this.getParent().getModules();
        MavenModuleSetBuild nb = (MavenModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() : Integer.MAX_VALUE;
        LinkedHashMap<MavenModule, MavenBuild> r = new LinkedHashMap<MavenModule, MavenBuild>(mods.size());
        for (MavenModule m : mods) {
            MavenBuild b = (MavenBuild)m.getNearestOldBuild(end - 1);
            if (b == null || b.getNumber() < this.getNumber()) continue;
            r.put(m, b);
        }
        return r;
    }

    public void registerAsProjectAction(MavenReporter reporter) {
        if (this.projectActionReporters == null) {
            this.projectActionReporters = new ArrayList<MavenReporter>();
        }
        this.projectActionReporters.add(reporter);
    }

    public <T extends Action> List<T> findModuleBuildActions(Class<T> action) {
        Collection<MavenModule> mods = this.getParent().getModules();
        ArrayList<Action> r = new ArrayList<Action>(mods.size());
        MavenModuleSetBuild nb = (MavenModuleSetBuild)this.getNextBuild();
        int end = nb != null ? nb.getNumber() - 1 : Integer.MAX_VALUE;
        block0: for (MavenModule m : mods) {
            for (MavenBuild b = (MavenBuild)m.getNearestOldBuild(end); b != null && b.getNumber() >= this.number; b = (MavenBuild)b.getPreviousBuild()) {
                Action a = b.getAction(action);
                if (a == null) continue;
                r.add(a);
                continue block0;
            }
        }
        return r;
    }

    public void run() {
        this.execute((Run.RunExecution)new MavenModuleSetBuildExecution());
        ((MavenModuleSet)this.getProject()).updateTransientActions();
    }

    public Fingerprint.RangeSet getDownstreamRelationship(AbstractProject that) {
        Fingerprint.RangeSet rs = super.getDownstreamRelationship(that);
        for (List<MavenBuild> builds : this.getModuleBuilds().values()) {
            for (MavenBuild b : builds) {
                rs.add(b.getDownstreamRelationship(that));
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyModuleBuild(MavenBuild newBuild) {
        try {
            this.getParent().updateNextBuildNumber();
            Map<MavenModule, List<MavenBuild>> moduleBuilds = this.getModuleBuilds();
            Object object = this.notifyModuleBuildLock;
            synchronized (object) {
                MavenAggregatedReport mar;
                this.effectiveResult = null;
                boolean modified = false;
                List actions = this.getActions();
                HashSet individuals = new HashSet();
                for (Action a : actions) {
                    if (!(a instanceof MavenAggregatedReport)) continue;
                    mar = (MavenAggregatedReport)a;
                    mar.update(moduleBuilds, newBuild);
                    individuals.add(mar.getIndividualActionType());
                    modified = true;
                }
                for (AggregatableAction aa : newBuild.getActions(AggregatableAction.class)) {
                    if (!individuals.add(aa.getClass())) continue;
                    mar = aa.createAggregatedAction(this, moduleBuilds);
                    mar.update(moduleBuilds, newBuild);
                    this.addAction(mar);
                    modified = true;
                }
                if (modified) {
                    this.save();
                    ((MavenModuleSet)this.getProject()).updateTransientActions();
                }
            }
            String moduleFsName = ((MavenModule)newBuild.getProject()).getModuleName().toFileSystemName();
            Util.createSymlink((File)this.getRootDir(), (String)("../../modules/" + moduleFsName + "/builds/" + newBuild.getId()), (String)moduleFsName, (TaskListener)StreamTaskListener.NULL);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to update " + (Object)((Object)this), e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Failed to update " + (Object)((Object)this), e);
        }
    }

    @Override
    public String getMavenOpts(TaskListener listener, EnvVars envVars) {
        return envVars.expand(this.expandTokens(listener, ((MavenModuleSet)this.project).getMavenOpts()));
    }

    protected Boolean isRelease() {
        MavenModuleSet mavenModuleSet = (MavenModuleSet)this.getProject();
        for (MavenModule mavenModule : mavenModuleSet.getModules()) {
            if (!ArtifactUtils.isSnapshot((String)mavenModule.getVersion())) continue;
            return false;
        }
        return true;
    }

    public MavenModuleSet getParent() {
        return (MavenModuleSet)super.getParent();
    }

    public static class SimpleTransferListener
    implements TransferListener {
        private TaskListener taskListener;

        public SimpleTransferListener(TaskListener taskListener) {
            this.taskListener = taskListener;
        }

        public void transferCorrupted(TransferEvent arg0) throws TransferCancelledException {
        }

        public void transferFailed(TransferEvent transferEvent) {
            this.taskListener.getLogger().println(Messages.MavenModuleSetBuild_FailedToTransfer(transferEvent.getException().getMessage()));
        }

        public void transferInitiated(TransferEvent arg0) throws TransferCancelledException {
        }

        public void transferProgressed(TransferEvent arg0) throws TransferCancelledException {
        }

        public void transferStarted(TransferEvent arg0) throws TransferCancelledException {
        }

        public void transferSucceeded(TransferEvent transferEvent) {
            this.taskListener.getLogger().println(Messages.MavenModuleSetBuild_DownloadedArtifact(transferEvent.getResource().getRepositoryUrl(), transferEvent.getResource().getResourceName()));
        }
    }

    private static final class PomParser
    extends MasterToSlaveFileCallable<Result> {
        private final BuildListener listener;
        private final String rootPOM;
        private final boolean verbose = debug;
        private final Maven.MavenInstallation mavenHome;
        private final String profiles;
        private final Properties properties;
        private final String privateRepository;
        private final String alternateSettings;
        private final String globalSettings;
        private final boolean nonRecursive;
        private final String workspaceProper;
        private final String mavenVersion;
        private final String moduleRootPath;
        private boolean resolveDependencies = false;
        private boolean processPlugins = false;
        private int mavenValidationLevel = -1;
        private boolean updateSnapshots = false;
        String rootPOMRelPrefix;
        private final PlexusModuleContributor plexusContributors;
        private static final long serialVersionUID = 1L;

        PomParser(BuildListener listener, Maven.MavenInstallation mavenHome, String mavenVersion, EnvVars envVars, MavenModuleSetBuild build) throws IOException, InterruptedException {
            MavenModuleSet project = (MavenModuleSet)build.getProject();
            this.listener = listener;
            this.mavenHome = mavenHome;
            this.rootPOM = project.getRootPOM(envVars);
            this.profiles = project.getProfiles();
            this.properties = project.getMavenProperties();
            this.updateSnapshots = this.isUpdateSnapshots(project.getGoals());
            ParametersDefinitionProperty parametersDefinitionProperty = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
            if (parametersDefinitionProperty != null && parametersDefinitionProperty.getParameterDefinitions() != null) {
                for (ParameterDefinition parameterDefinition : parametersDefinitionProperty.getParameterDefinitions()) {
                    if (!(parameterDefinition instanceof StringParameterDefinition)) continue;
                    this.properties.put("env." + parameterDefinition.getName(), ((StringParameterDefinition)parameterDefinition).getDefaultValue());
                }
            }
            if (envVars != null && !envVars.isEmpty()) {
                for (Map.Entry entry : envVars.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    this.properties.put("env." + (String)entry.getKey(), entry.getValue());
                }
            }
            this.nonRecursive = project.isNonRecursive();
            this.workspaceProper = build.getWorkspace().getRemote();
            LOGGER.fine("Workspace is " + this.workspaceProper);
            FilePath localRepo = project.getLocalRepository().locate(build);
            this.privateRepository = localRepo != null ? localRepo.getRemote() : null;
            this.alternateSettings = SettingsProvider.getSettingsRemotePath((SettingsProvider)project.getSettings(), (AbstractBuild)build, (TaskListener)listener);
            this.globalSettings = GlobalSettingsProvider.getSettingsRemotePath((GlobalSettingsProvider)project.getGlobalSettings(), (AbstractBuild)build, (TaskListener)listener);
            this.mavenVersion = mavenVersion;
            this.resolveDependencies = project.isResolveDependencies();
            this.processPlugins = project.isProcessPlugins();
            this.moduleRootPath = project.getScm().getModuleRoot(build.getWorkspace(), project.getLastBuild()).getRemote();
            this.mavenValidationLevel = project.getMavenValidationLevel();
            this.plexusContributors = PlexusModuleContributorFactory.aggregate(build);
        }

        private boolean isUpdateSnapshots(String goals) {
            return StringUtils.contains((String)goals, (String)"-U") || StringUtils.contains((String)goals, (String)"--update-snapshots");
        }

        /*
         * WARNING - void declaration
         */
        public Result invoke(File ws, VirtualChannel channel) throws IOException {
            File settingsLoc;
            File wsp;
            File pom;
            PrintStream logger = this.listener.getLogger();
            if (IOUtils.isAbsolute((String)this.rootPOM)) {
                pom = new File(this.rootPOM);
            } else {
                pom = new File(ws, this.rootPOM);
                File parentLoc = new File(ws.getParentFile(), this.rootPOM);
                if (!pom.exists() && parentLoc.exists()) {
                    pom = parentLoc;
                }
            }
            if (!pom.exists()) {
                throw new AbortException(Messages.MavenModuleSetBuild_NoSuchPOMFile(pom));
            }
            this.rootPOMRelPrefix = this.rootPOM.startsWith("../") || this.rootPOM.startsWith("..\\") ? (!ws.equals(wsp = new File(this.workspaceProper)) ? ws.getCanonicalPath().substring(wsp.getCanonicalPath().length() + 1) + "/" : wsp.getName() + "/") : "";
            if (this.verbose) {
                logger.println("Parsing " + (this.nonRecursive ? "non-recursively " : "recursively ") + pom);
            }
            if (this.alternateSettings == null) {
                settingsLoc = null;
            } else if (IOUtils.isAbsolute((String)this.alternateSettings)) {
                settingsLoc = new File(this.alternateSettings);
            } else {
                settingsLoc = new File(this.workspaceProper, this.alternateSettings);
                File mrSettingsLoc = new File(this.workspaceProper, this.alternateSettings);
                if (!settingsLoc.exists() && mrSettingsLoc.exists()) {
                    settingsLoc = mrSettingsLoc;
                }
            }
            if (debug) {
                logger.println(Messages.MavenModuleSetBuild_SettinsgXmlAndPrivateRepository(settingsLoc, this.privateRepository));
            }
            if (settingsLoc != null && !settingsLoc.exists()) {
                throw new AbortException(Messages.MavenModuleSetBuild_NoSuchAlternateSettings(settingsLoc.getAbsolutePath()));
            }
            try {
                MavenEmbedderRequest mer = new MavenEmbedderRequest((TaskListener)this.listener, this.mavenHome.getHomeDir(), this.profiles, this.properties, this.privateRepository, settingsLoc);
                mer.setTransferListener(new SimpleTransferListener((TaskListener)this.listener));
                mer.setUpdateSnapshots(this.updateSnapshots);
                mer.setProcessPlugins(this.processPlugins);
                mer.setResolveDependencies(this.resolveDependencies);
                if (this.globalSettings != null) {
                    mer.setGlobalSettings(new File(this.globalSettings));
                }
                ReactorReader reactorReader = null;
                boolean maven3OrLater = MavenUtil.maven3orLater(this.mavenVersion);
                if (maven3OrLater) {
                    mer.setValidationLevel(30);
                } else {
                    reactorReader = new ReactorReader(new HashMap(), new File(this.workspaceProper));
                    mer.setWorkspaceReader((WorkspaceReader)reactorReader);
                }
                List<URL> urls = this.plexusContributors.getPlexusComponentJars();
                if (!urls.isEmpty()) {
                    mer.setClassLoader(new URLClassLoader(urls.toArray(new URL[urls.size()]), mer.getClassLoader()));
                }
                if (this.mavenValidationLevel >= 0) {
                    mer.setValidationLevel(this.mavenValidationLevel);
                }
                MavenEmbedder embedder = MavenUtil.createEmbedder(mer);
                MavenProject rootProject = null;
                List<MavenProject> mps = new ArrayList<MavenProject>(0);
                if (maven3OrLater) {
                    mps = embedder.readProjects(pom, !this.nonRecursive);
                } else {
                    MavenProject mavenProject;
                    rootProject = mavenProject = embedder.readProject(pom);
                    mps.add(mavenProject);
                    reactorReader.addProject(mavenProject);
                    if (!this.nonRecursive) {
                        this.readChilds(mavenProject, embedder, mps, reactorReader);
                    }
                }
                HashMap<String, MavenProject> canonicalPaths = new HashMap<String, MavenProject>(mps.size());
                HashMap<String, String> modelParents = new HashMap<String, String>();
                for (MavenProject mavenProject : mps) {
                    MavenProject mpp;
                    void var15_17;
                    String k;
                    canonicalPaths.put(mavenProject.getFile().getCanonicalPath(), mavenProject);
                    while (!modelParents.containsKey(k = var15_17.getId()) && (mpp = var15_17.getParent()) != null) {
                        modelParents.put(k, mpp.getId());
                        MavenProject mavenProject2 = mpp;
                    }
                }
                if (this.verbose) {
                    for (Map.Entry entry : canonicalPaths.entrySet()) {
                        logger.printf("Discovered %s at %s\n", ((MavenProject)entry.getValue()).getId(), entry.getKey());
                    }
                }
                LinkedHashSet<PomInfo> infos = new LinkedHashSet<PomInfo>();
                if (maven3OrLater) {
                    for (MavenProject mp : mps) {
                        if (!mp.isExecutionRoot()) continue;
                        rootProject = mp;
                    }
                }
                if (rootProject == null) {
                    rootProject = mps.get(0);
                }
                this.toPomInfo(rootProject, null, canonicalPaths, infos);
                for (PomInfo pi : infos) {
                    pi.cutCycle();
                }
                return new Result(new ArrayList<PomInfo>(infos), modelParents);
            }
            catch (MavenEmbedderException e) {
                throw new MavenExecutionException((Exception)((Object)e));
            }
            catch (ProjectBuildingException e) {
                throw new MavenExecutionException((Exception)((Object)e));
            }
        }

        private void toPomInfo(MavenProject mp, PomInfo parent, Map<String, MavenProject> abslPath, Set<PomInfo> infos) throws IOException {
            String relPath = PathTool.getRelativeFilePath((String)this.moduleRootPath, (String)mp.getBasedir().getPath());
            relPath = MavenModuleSetBuild.normalizePath(relPath);
            if (parent == null) {
                relPath = this.getRootPath(this.rootPOMRelPrefix);
            }
            relPath = StringUtils.removeStart((String)relPath, (String)"/");
            PomInfo pi = new PomInfo(mp, parent, relPath);
            infos.add(pi);
            if (!this.nonRecursive) {
                for (String modulePath : mp.getModules()) {
                    MavenProject child;
                    if (StringUtils.isBlank((String)modulePath)) continue;
                    File path = new File(mp.getBasedir(), modulePath);
                    if (path.isDirectory()) {
                        path = new File(mp.getBasedir(), modulePath + "/pom.xml");
                    }
                    if ((child = abslPath.get(path.getCanonicalPath())) == null) {
                        this.listener.getLogger().printf(Messages.MavenModuleSetBuild_FoundModuleWithoutProject(modulePath), new Object[0]);
                        continue;
                    }
                    this.toPomInfo(child, pi, abslPath, infos);
                }
            }
        }

        private void readChilds(MavenProject mp, MavenEmbedder mavenEmbedder, List<MavenProject> mavenProjects, ReactorReader reactorReader) throws ProjectBuildingException, MavenEmbedderException {
            if (mp.getModules() == null || mp.getModules().isEmpty()) {
                return;
            }
            for (String module : mp.getModules()) {
                if (Util.fixEmptyAndTrim((String)module) == null) continue;
                File pomFile = new File(mp.getFile().getParent(), module);
                MavenProject mavenProject2 = null;
                mavenProject2 = pomFile.isFile() ? mavenEmbedder.readProject(pomFile) : mavenEmbedder.readProject(new File(mp.getFile().getParent(), module + "/pom.xml"));
                mavenProjects.add(mavenProject2);
                reactorReader.addProject(mavenProject2);
                this.readChilds(mavenProject2, mavenEmbedder, mavenProjects, reactorReader);
            }
        }

        private String getRootPath(String prefix) {
            int idx = Math.max(this.rootPOM.lastIndexOf(47), this.rootPOM.lastIndexOf(92));
            if (idx == -1) {
                return "";
            }
            return prefix + this.rootPOM.substring(0, idx);
        }

        public static final class Result
        implements Serializable {
            private static final long serialVersionUID = 1770277148826049154L;
            public final List<PomInfo> infos;
            public final Map<String, String> modelParents;

            public Result(List<PomInfo> infos, Map<String, String> modelParents) {
                this.infos = infos;
                this.modelParents = modelParents;
            }
        }
    }

    private static final class MavenExecutionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private MavenExecutionException(Exception cause) {
            super(cause);
        }

        @Override
        public Exception getCause() {
            return (Exception)super.getCause();
        }
    }

    private class MavenModuleSetBuildExecution
    extends AbstractBuild.AbstractBuildExecution {
        private Map<ModuleName, MavenBuild.ProxyImpl2> proxies;

        private MavenModuleSetBuildExecution() {
            super((AbstractBuild)MavenModuleSetBuild.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        protected Result doRun(BuildListener listener) throws Exception {
            Result r = null;
            PrintStream logger = listener.getLogger();
            try {
                EnvVars envVars = MavenModuleSetBuild.this.getEnvironment((TaskListener)listener);
                Maven.MavenInstallation mvn = ((MavenModuleSet)MavenModuleSetBuild.this.project).getMaven();
                if (mvn == null) {
                    throw new AbortException(Messages.MavenModuleSetBuild_NoMavenConfigured());
                }
                mvn = mvn.forEnvironment(envVars).forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
                MavenInformation mavenInformation = (MavenInformation)MavenModuleSetBuild.this.getModuleRoot().act((Callable)new MavenVersionCallable(mvn.getHome()));
                String mavenVersion = mavenInformation.getVersion();
                MavenBuildInformation mavenBuildInformation = new MavenBuildInformation(mavenVersion);
                MavenModuleSetBuild.this.setMavenVersionUsed(mavenVersion);
                LOGGER.fine(MavenModuleSetBuild.this.getFullDisplayName() + " is building with mavenVersion " + mavenVersion + " from file " + mavenInformation.getVersionResourcePath());
                if (((MavenModuleSet)MavenModuleSetBuild.this.project).isAggregatorStyleBuild()) {
                    try {
                        Result result;
                        AbstractMavenBuilder builder;
                        FilePath remoteGlobalSettings;
                        FilePath remoteSettings;
                        AbstractMavenProcessFactory factory;
                        boolean incrementalBuild;
                        Object w2;
                        ArrayList<BuildWrapper> wrappers = new ArrayList<BuildWrapper>();
                        for (Object w2 : ((MavenModuleSet)MavenModuleSetBuild.this.project).getBuildWrappersList()) {
                            wrappers.add((BuildWrapper)w2);
                        }
                        ParametersAction parameters = (ParametersAction)MavenModuleSetBuild.this.getAction(ParametersAction.class);
                        if (parameters != null) {
                            parameters.createBuildWrappers((AbstractBuild)MavenModuleSetBuild.this, wrappers);
                        }
                        for (BuildWrapper w3 : wrappers) {
                            BuildWrapper.Environment e = w3.setUp((AbstractBuild)MavenModuleSetBuild.this, this.launcher, listener);
                            if (e == null) {
                                r = Result.FAILURE;
                                MavenModuleSetBuild.this.setResult(r);
                                Result result2 = r;
                                return result2;
                            }
                            MavenModuleSetBuild.this.buildEnvironments.add(e);
                        }
                        if (!(this.preBuild(listener, (Collection)((MavenModuleSet)MavenModuleSetBuild.this.project).getPrebuilders()) && this.preBuild(listener, (Collection)((MavenModuleSet)MavenModuleSetBuild.this.project).getPostbuilders()) && this.preBuild(listener, (Collection)((MavenModuleSet)MavenModuleSetBuild.this.project).getPublishers()))) {
                            r = Result.FAILURE;
                            MavenModuleSetBuild.this.setResult(r);
                            w2 = r;
                            return w2;
                        }
                        if (!this.build(listener, ((MavenModuleSet)MavenModuleSetBuild.this.project).getPrebuilders().toList())) {
                            r = Result.FAILURE;
                            MavenModuleSetBuild.this.setResult(r);
                            w2 = r;
                            return w2;
                        }
                        envVars = MavenModuleSetBuild.this.getEnvironment((TaskListener)listener);
                        this.parsePoms(listener, logger, envVars, mvn, mavenVersion, mavenBuildInformation);
                        SplittableBuildListener slistener = new SplittableBuildListener(listener);
                        this.proxies = new HashMap<ModuleName, MavenBuild.ProxyImpl2>();
                        ArrayList<ModuleName> changedModules = new ArrayList<ModuleName>();
                        if (((MavenModuleSet)MavenModuleSetBuild.this.project).isIncrementalBuild()) {
                            if (MavenModuleSetBuild.this.getChangeSet().isEmptySet()) {
                                LOGGER.log(Level.FINER, "{0} has no changes and thus we are not doing an incremental build", (Object)MavenModuleSetBuild.this);
                                incrementalBuild = false;
                            } else {
                                incrementalBuild = true;
                            }
                        } else {
                            incrementalBuild = false;
                        }
                        if (incrementalBuild) {
                            changedModules.addAll(this.getUnbuiltModulesSinceLastSuccessfulBuild());
                        }
                        for (MavenModule m : ((MavenModuleSet)((MavenModuleSetBuild)MavenModuleSetBuild.this).project).sortedActiveModules) {
                            MavenBuild mb = m.newBuild();
                            mb.setBuiltOnStr(MavenModuleSetBuild.this.getBuiltOnStr());
                            ModuleName moduleName = m.getModuleName();
                            if (incrementalBuild) {
                                if (!MavenModuleSetBuild.this.getChangeSetFor(m).isEmpty()) {
                                    LOGGER.log(Level.FINER, "adding {0} to changedModules for {1} because it has changes", new Object[]{moduleName, MavenModuleSetBuild.this});
                                    changedModules.add(moduleName);
                                } else if (mb.getPreviousBuiltBuild() == null) {
                                    LOGGER.log(Level.FINER, "adding {0} to changedModules for {1} because we have never seen this module before", new Object[]{moduleName, MavenModuleSetBuild.this});
                                    changedModules.add(moduleName);
                                } else if (((MavenBuild)mb.getPreviousBuiltBuild()).getResult().isWorseThan(Result.SUCCESS)) {
                                    LOGGER.log(Level.FINER, "adding {0} to changedModules for {1} because the previous build failed or was unstable", new Object[]{moduleName, MavenModuleSetBuild.this});
                                    changedModules.add(moduleName);
                                } else {
                                    LOGGER.log(Level.FINER, "no reason to add {0} to changedModules for {1}", new Object[]{moduleName, MavenModuleSetBuild.this});
                                }
                            }
                            mb.setWorkspace(MavenModuleSetBuild.this.getModuleRoot().child(m.getRelativePath()));
                            MavenBuild mavenBuild = mb;
                            ((Object)((Object)mavenBuild)).getClass();
                            this.proxies.put(moduleName, mavenBuild.new MavenBuild.ProxyImpl2(MavenModuleSetBuild.this, slistener));
                        }
                        String rootPOM = ((MavenModuleSet)MavenModuleSetBuild.this.project).getRootPOM(envVars);
                        FilePath pom = MavenModuleSetBuild.this.getModuleRoot().child(rootPOM);
                        FilePath parentLoc = MavenModuleSetBuild.this.getWorkspace().child(rootPOM);
                        if (!pom.exists() && parentLoc.exists()) {
                            pom = parentLoc;
                        }
                        boolean maven3orLater = mavenBuildInformation.isMaven3OrLater();
                        MavenUtil.MavenVersion mavenVersionType = MavenUtil.getMavenVersion(mavenVersion);
                        Class<Maven3Main> maven3MainClass = null;
                        Class<Maven3Launcher> maven3LauncherClass = null;
                        String mavenOpts = MavenModuleSetBuild.this.getMavenOpts((TaskListener)listener, envVars);
                        switch (mavenVersionType) {
                            case MAVEN_2: {
                                LOGGER.fine("using maven 2 " + mavenVersion);
                                factory = new MavenProcessFactory((MavenModuleSet)MavenModuleSetBuild.this.project, MavenModuleSetBuild.this, this.launcher, envVars, mavenOpts, pom.getParent());
                                break;
                            }
                            case MAVEN_3_0_X: {
                                LOGGER.fine("using maven 3 " + mavenVersion);
                                factory = new Maven3ProcessFactory((MavenModuleSet)MavenModuleSetBuild.this.project, MavenModuleSetBuild.this, this.launcher, envVars, mavenOpts, pom.getParent());
                                maven3MainClass = Maven3Main.class;
                                maven3LauncherClass = Maven3Launcher.class;
                                break;
                            }
                            case MAVEN_3_1: {
                                LOGGER.fine("using maven 3 " + mavenVersion);
                                factory = new Maven31ProcessFactory((MavenModuleSet)MavenModuleSetBuild.this.project, MavenModuleSetBuild.this, this.launcher, envVars, mavenOpts, pom.getParent());
                                maven3MainClass = Maven31Main.class;
                                maven3LauncherClass = Maven31Launcher.class;
                                break;
                            }
                            case MAVEN_3_2: {
                                LOGGER.fine("using maven 3 " + mavenVersion);
                                factory = new Maven32ProcessFactory((MavenModuleSet)MavenModuleSetBuild.this.project, MavenModuleSetBuild.this, this.launcher, envVars, mavenOpts, pom.getParent());
                                maven3MainClass = Maven32Main.class;
                                maven3LauncherClass = Maven32Launcher.class;
                                break;
                            }
                            case MAVEN_3_3: {
                                LOGGER.fine("using maven 3 " + mavenVersion);
                                factory = new Maven33ProcessFactory((MavenModuleSet)MavenModuleSetBuild.this.project, MavenModuleSetBuild.this, this.launcher, envVars, mavenOpts, pom.getParent());
                                maven3MainClass = Maven33Main.class;
                                maven3LauncherClass = Maven33Launcher.class;
                                break;
                            }
                            default: {
                                LOGGER.fine("using maven 3 " + mavenVersion);
                                factory = new Maven35ProcessFactory((MavenModuleSet)MavenModuleSetBuild.this.project, MavenModuleSetBuild.this, this.launcher, envVars, mavenOpts, pom.getParent());
                                maven3MainClass = Maven35Main.class;
                                maven3LauncherClass = Maven35Launcher.class;
                            }
                        }
                        ProcessCache.MavenProcess process = MavenBuild.mavenProcessCache.get(this.launcher.getChannel(), slistener, (ProcessCache.Factory)((Object)factory));
                        ArgumentListBuilder margs = new ArgumentListBuilder().add("-B").add(new String[]{"-f", pom.getRemote()});
                        FilePath localRepo = ((MavenModuleSet)MavenModuleSetBuild.this.project).getLocalRepository().locate(MavenModuleSetBuild.this);
                        if (localRepo != null) {
                            margs.add("-Dmaven.repo.local=" + localRepo.getRemote());
                        }
                        if ((remoteSettings = SettingsProvider.getSettingsFilePath((SettingsProvider)((MavenModuleSet)MavenModuleSetBuild.this.project).getSettings(), (AbstractBuild)MavenModuleSetBuild.this, (TaskListener)listener)) != null) {
                            margs.add(new String[]{"-s", remoteSettings.getRemote()});
                        }
                        if ((remoteGlobalSettings = GlobalSettingsProvider.getSettingsFilePath((GlobalSettingsProvider)((MavenModuleSet)MavenModuleSetBuild.this.project).getGlobalSettings(), (AbstractBuild)MavenModuleSetBuild.this, (TaskListener)listener)) != null) {
                            margs.add(new String[]{"-gs", remoteGlobalSettings.getRemote()});
                        }
                        if (changedModules.isEmpty()) {
                            LOGGER.log(Level.FINER, "{0} was not configured to do incremental builds or had no changed modules, so skipping incremental build", (Object)MavenModuleSetBuild.this);
                        } else if (new ComparableVersion(mavenVersion).compareTo(new ComparableVersion("2.1")) < 0) {
                            LOGGER.log(Level.FINER, "{0} is using Maven {1} but need 2.1+ for incremental builds", new Object[]{MavenModuleSetBuild.this, mavenVersion});
                        } else if (MavenModuleSetBuild.this.getPreviousCompletedBuild() != null && ((MavenModuleSetBuild)MavenModuleSetBuild.this.getPreviousCompletedBuild()).getAction(NeedsFullBuildAction.class) != null && MavenModuleSetBuild.this.getCause(Cause.UpstreamCause.class) != null) {
                            LOGGER.log(Level.FINER, "{0} had a previous build asking for this one to not be incremental", (Object)MavenModuleSetBuild.this);
                        } else {
                            LOGGER.log(Level.FINER, "{0} can do an incremental build on {1}", new Object[]{MavenModuleSetBuild.this, changedModules});
                            margs.add("-amd");
                            margs.add(new String[]{"-pl", Util.join(changedModules, (String)",")});
                        }
                        List argInterceptors = ((MavenModuleSetBuild)this.getBuild()).getActions(MavenArgumentInterceptorAction.class);
                        String goals = ((MavenModuleSet)MavenModuleSetBuild.this.project).getGoals();
                        for (MavenArgumentInterceptorAction mavenArgInterceptor : argInterceptors) {
                            String goalsAndOptions = mavenArgInterceptor.getGoalsAndOptions((MavenModuleSetBuild)this.getBuild());
                            if (!StringUtils.isNotBlank((String)goalsAndOptions)) continue;
                            goals = goalsAndOptions;
                            break;
                        }
                        margs.addTokenized(envVars.expand(goals));
                        for (MavenArgumentInterceptorAction mavenArgInterceptor : argInterceptors) {
                            ArgumentListBuilder newMargs = mavenArgInterceptor.intercept(margs, (MavenModuleSetBuild)this.getBuild());
                            if (newMargs == null) continue;
                            margs = newMargs;
                        }
                        if (maven3orLater) {
                            Maven3Builder.Maven3BuilderRequest maven3BuilderRequest = new Maven3Builder.Maven3BuilderRequest();
                            maven3BuilderRequest.listener = slistener;
                            maven3BuilderRequest.proxies = this.proxies;
                            maven3BuilderRequest.modules = ((MavenModuleSet)((MavenModuleSetBuild)MavenModuleSetBuild.this).project).sortedActiveModules;
                            maven3BuilderRequest.goals = margs.toList();
                            maven3BuilderRequest.systemProps = envVars;
                            maven3BuilderRequest.mavenBuildInformation = mavenBuildInformation;
                            maven3BuilderRequest.maven3MainClass = maven3MainClass;
                            maven3BuilderRequest.maven3LauncherClass = maven3LauncherClass;
                            maven3BuilderRequest.supportEventSpy = MavenUtil.supportEventSpy(mavenVersion);
                            builder = new Maven3Builder(maven3BuilderRequest);
                        } else {
                            builder = new Maven2Builder(slistener, this.proxies, ((MavenModuleSet)((MavenModuleSetBuild)MavenModuleSetBuild.this).project).sortedActiveModules, margs.toList(), (Map<String, String>)envVars, mavenBuildInformation);
                        }
                        MavenProbeAction mpa = null;
                        try {
                            mpa = new MavenProbeAction((AbstractProject)MavenModuleSetBuild.this.project, process.channel, MavenModuleSetBuild.this);
                            MavenModuleSetBuild.this.addAction(mpa);
                            r = (Result)process.call(builder);
                            for (MavenBuild.ProxyImpl2 proxy : this.proxies.values()) {
                                proxy.performArchiving(this.launcher, listener);
                            }
                            result = r;
                        }
                        catch (Throwable throwable) {
                            try {
                                builder.end(this.launcher);
                                MavenModuleSetBuild.this.getActions().remove(mpa);
                                process.discard();
                                throw throwable;
                            }
                            catch (InterruptedException e) {
                                r = Executor.currentExecutor().abortResult();
                                throw e;
                            }
                        }
                        builder.end(this.launcher);
                        MavenModuleSetBuild.this.getActions().remove(mpa);
                        process.discard();
                        return result;
                    }
                    finally {
                        if ((r == null || r.isBetterOrEqualTo(((MavenModuleSet)MavenModuleSetBuild.this.project).getRunPostStepsIfResult())) && !this.build(listener, ((MavenModuleSet)MavenModuleSetBuild.this.project).getPostbuilders().toList())) {
                            r = Result.FAILURE;
                        }
                        if (r != null) {
                            MavenModuleSetBuild.this.setResult(r);
                        }
                        boolean failed = false;
                        for (int i = MavenModuleSetBuild.this.buildEnvironments.size() - 1; i >= 0; --i) {
                            if (((Environment)MavenModuleSetBuild.this.buildEnvironments.get(i)).tearDown((AbstractBuild)MavenModuleSetBuild.this, listener)) continue;
                            failed = true;
                        }
                        if (failed) {
                            Result i = Result.FAILURE;
                            return i;
                        }
                    }
                }
                this.parsePoms(listener, logger, envVars, mvn, mavenVersion, mavenBuildInformation);
                logger.println("Triggering " + ((MavenModuleSet)MavenModuleSetBuild.this.project).getRootModule().getModuleName());
                ((MavenModuleSet)MavenModuleSetBuild.this.project).getRootModule().scheduleBuild((Cause)new Cause.UpstreamCause((Run)MavenModuleSetBuild.this));
                Result result = r;
                return result;
            }
            catch (AbortException e) {
                if (e.getMessage() != null) {
                    listener.error(e.getMessage());
                }
                Result result = Result.FAILURE;
                return result;
            }
            catch (InterruptedIOException e) {
                e.printStackTrace(listener.error("Aborted Maven execution for InterruptedIOException"));
                Result result = Executor.currentExecutor().abortResult();
                return result;
            }
            catch (IOException e) {
                e.printStackTrace(listener.error(Messages.MavenModuleSetBuild_FailedToParsePom()));
                Result result = Result.FAILURE;
                return result;
            }
            catch (Run.RunnerAbortedException e) {
                Result result = Result.FAILURE;
                return result;
            }
            catch (RuntimeException e) {
                e.printStackTrace(listener.error("Processing failed due to a bug in the code. Please report this to the issue tracker (https://jenkins.io/redirect/report-an-issue)."));
                logger.println("project=" + MavenModuleSetBuild.this.project);
                logger.println("project.getModules()=" + ((MavenModuleSet)MavenModuleSetBuild.this.project).getModules());
                logger.println("project.getRootModule()=" + (Object)((Object)((MavenModuleSet)MavenModuleSetBuild.this.project).getRootModule()));
                throw e;
            }
        }

        private boolean build(BuildListener listener, Collection<Builder> steps) throws IOException, InterruptedException {
            for (BuildStep buildStep : steps) {
                if (this.perform(buildStep, listener)) continue;
                LOGGER.fine(MessageFormat.format("{1} failed", buildStep));
                return false;
            }
            return true;
        }

        private Collection<ModuleName> getUnbuiltModulesSinceLastSuccessfulBuild() {
            ArrayList<ModuleName> unbuiltModules = new ArrayList<ModuleName>();
            MavenModuleSetBuild previousSuccessfulBuild = (MavenModuleSetBuild)MavenModuleSetBuild.this.getPreviousSuccessfulBuild();
            if (previousSuccessfulBuild == null) {
                LOGGER.log(Level.FINER, "no successful build from {0} yet; taking the first build instead", (Object)MavenModuleSetBuild.this);
                previousSuccessfulBuild = (MavenModuleSetBuild)MavenModuleSetBuild.this.getParent().getFirstBuild();
            }
            for (MavenModuleSetBuild previousBuild = previousSuccessfulBuild; previousBuild != null && previousBuild != MavenModuleSetBuild.this; previousBuild = (MavenModuleSetBuild)previousBuild.getNextBuild()) {
                UnbuiltModuleAction unbuiltModuleAction = (UnbuiltModuleAction)previousBuild.getAction(UnbuiltModuleAction.class);
                if (unbuiltModuleAction != null) {
                    Collection<ModuleName> newUnbuiltModules = unbuiltModuleAction.getUnbuildModules();
                    LOGGER.log(Level.FINER, "considered {0} and consequently adding {1}", new Object[]{previousBuild, newUnbuiltModules});
                    unbuiltModules.addAll(newUnbuiltModules);
                    continue;
                }
                LOGGER.log(Level.FINER, "considered {0} but it has no list of unbuilt modules", (Object)previousBuild);
            }
            LOGGER.log(Level.FINER, "unbuilt modules since last successful build of {0}: {1}", new Object[]{MavenModuleSetBuild.this, unbuiltModules});
            return unbuiltModules;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parsePoms(BuildListener listener, PrintStream logger, EnvVars envVars, Maven.MavenInstallation mvn, String mavenVersion, MavenBuildInformation mavenBuildInformation) throws IOException, InterruptedException {
            List<PomInfo> poms;
            logger.println("Parsing POMs");
            try {
                PomParser.Result result = (PomParser.Result)MavenModuleSetBuild.this.getModuleRoot().act((FilePath.FileCallable)new PomParser(listener, mvn, mavenVersion, envVars, MavenModuleSetBuild.this));
                poms = result.infos;
                mavenBuildInformation.modelParents.putAll(result.modelParents);
            }
            catch (IOException e) {
                if (((MavenModuleSet)MavenModuleSetBuild.this.project).isIncrementalBuild()) {
                    MavenModuleSetBuild.this.getActions().add(new NeedsFullBuildAction());
                }
                if (e.getCause() instanceof AbortException) {
                    throw (AbortException)e.getCause();
                }
                throw e;
            }
            catch (MavenExecutionException e) {
                e.getCause().printStackTrace(listener.error(Messages.MavenModuleSetBuild_FailedToParsePom()));
                if (((MavenModuleSet)MavenModuleSetBuild.this.project).isIncrementalBuild()) {
                    MavenModuleSetBuild.this.getActions().add(new NeedsFullBuildAction());
                }
                throw new AbortException();
            }
            boolean needsDependencyGraphRecalculation = false;
            Map<ModuleName, MavenModule> modules = ((MavenModuleSet)((MavenModuleSetBuild)MavenModuleSetBuild.this).project).modules;
            Map<ModuleName, MavenModule> map = modules;
            synchronized (map) {
                HashMap<ModuleName, MavenModule> old = new HashMap<ModuleName, MavenModule>(modules);
                ArrayList<MavenModule> sortedModules = new ArrayList<MavenModule>();
                modules.clear();
                if (debug) {
                    logger.println("Root POM is " + poms.get((int)0).name);
                }
                ((MavenModuleSet)MavenModuleSetBuild.this.project).reconfigure(poms.get(0));
                for (PomInfo pom : poms) {
                    MavenModule mm = (MavenModule)((Object)old.get(pom.name));
                    if (mm != null) {
                        if (debug) {
                            logger.println("Reconfiguring " + (Object)((Object)mm));
                        }
                        if (!mm.isSameModule(pom)) {
                            needsDependencyGraphRecalculation = true;
                        }
                        mm.reconfigure(pom);
                        modules.put(pom.name, mm);
                    } else {
                        logger.println(Messages.MavenModuleSetBuild_DiscoveredModule(pom.name, pom.displayName));
                        mm = new MavenModule((MavenModuleSet)MavenModuleSetBuild.this.project, pom, MavenModuleSetBuild.this.getNumber());
                        mm.onCreatedFromScratch();
                        modules.put(mm.getModuleName(), mm);
                        needsDependencyGraphRecalculation = true;
                    }
                    sortedModules.add(mm);
                    mm.save();
                }
                ((MavenModuleSet)((MavenModuleSetBuild)MavenModuleSetBuild.this).project).sortedActiveModules = sortedModules;
                old.keySet().removeAll(modules.keySet());
                for (MavenModule om : old.values()) {
                    if (debug) {
                        logger.println("Disabling " + (Object)((Object)om));
                    }
                    om.makeDisabled(true);
                    needsDependencyGraphRecalculation = true;
                }
                modules.putAll(old);
            }
            if (needsDependencyGraphRecalculation) {
                logger.println("Modules changed, recalculating dependency graph");
                Jenkins.getInstance().rebuildDependencyGraph();
            }
            for (MavenModule m : modules.values()) {
                m.updateNextBuildNumber(MavenModuleSetBuild.this.getNumber());
            }
        }

        protected void post2(BuildListener listener) throws Exception {
            for (MavenBuild b : MavenModuleSetBuild.this.getModuleLastBuilds().values()) {
                b.save();
            }
            if (!this.performAllBuildSteps(listener, (Iterable)((MavenModuleSet)MavenModuleSetBuild.this.project).getPublishers(), true)) {
                MavenModuleSetBuild.this.setResult(Result.FAILURE);
            }
            if (!this.performAllBuildSteps(listener, ((MavenModuleSet)MavenModuleSetBuild.this.project).getProperties(), true)) {
                MavenModuleSetBuild.this.setResult(Result.FAILURE);
            }
            MavenFingerprinter.aggregate(MavenModuleSetBuild.this);
        }

        public void cleanUp(BuildListener listener) throws Exception {
            MavenMailer mailer = (MavenMailer)((MavenModuleSet)MavenModuleSetBuild.this.project).getReporters().get(MavenMailer.class);
            if (mailer != null) {
                new MailSender(mailer.getAllRecipients(), mailer.dontNotifyEveryUnstableBuild, mailer.sendToIndividuals).execute((AbstractBuild)MavenModuleSetBuild.this, listener);
            }
            this.performAllBuildSteps(listener, (Iterable)((MavenModuleSet)MavenModuleSetBuild.this.project).getPublishers(), false);
            this.performAllBuildSteps(listener, ((MavenModuleSet)MavenModuleSetBuild.this.project).getProperties(), false);
            super.cleanUp(listener);
        }
    }
}

