/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric;

import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import io.jenkins.cli.shaded.org.bouncycastle.internal.asn1.bsi.BSIObjectIdentifiers;
import io.jenkins.cli.shaded.org.bouncycastle.internal.asn1.cms.CMSObjectIdentifiers;
import io.jenkins.cli.shaded.org.bouncycastle.internal.asn1.eac.EACObjectIdentifiers;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import io.jenkins.cli.shaded.org.bouncycastle.jce.ECNamedCurveTable;
import io.jenkins.cli.shaded.org.bouncycastle.util.Properties;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class EC {
    private static final String PREFIX = "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.";
    private static final Map<String, String> generalEcAttributes;
    private static final Map<String, String> ecSupportCurves;

    static {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        generalEcAttributes = new HashMap<String, String>();
        ecSupportCurves = new HashMap<String, String>();
        generalEcAttributes.put("SupportedKeyClasses", "java.security.interfaces.ECPublicKey|java.security.interfaces.ECPrivateKey");
        generalEcAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        Enumeration enumeration = io.jenkins.cli.shaded.org.bouncycastle.asn1.x9.ECNamedCurveTable.getNames();
        Hashtable<Object, Serializable> hashtable = new Hashtable<Object, Serializable>();
        while (enumeration.hasMoreElements()) {
            object4 = (String)enumeration.nextElement();
            object3 = ECNamedCurveTable.getParameterSpec((String)object4);
            if (object3 == null || (object2 = io.jenkins.cli.shaded.org.bouncycastle.asn1.x9.ECNamedCurveTable.getOID((String)object4)) == null) continue;
            object = ((ASN1ObjectIdentifier)object2).getId();
            serializable = (Vector)hashtable.get(object);
            if (serializable == null) {
                serializable = new Vector();
                hashtable.put(object, serializable);
            }
            if (((Vector)serializable).contains(object4)) continue;
            ((Vector)serializable).addElement(object4);
        }
        object4 = hashtable.keys();
        object3 = new Vector();
        while (object4.hasMoreElements()) {
            object2 = (String)object4.nextElement();
            object = (Vector)hashtable.get(object2);
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("[");
            ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier((String)object2);
            if (X9ObjectIdentifiers.prime256v1.equals(aSN1ObjectIdentifier)) {
                ((StringBuffer)serializable).append("secp256r1,NIST P-256,X9.62 prime256v1");
            } else if (X9ObjectIdentifiers.prime192v1.equals(aSN1ObjectIdentifier)) {
                ((StringBuffer)serializable).append("secp192r1,NIST P-192,X9.62 prime192v1");
            } else {
                if (aSN1ObjectIdentifier.on(X9ObjectIdentifiers.primeCurve) || aSN1ObjectIdentifier.on(X9ObjectIdentifiers.cTwoCurve)) {
                    ((StringBuffer)serializable).append("X9.62 ");
                }
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    if (i > 0) {
                        ((StringBuffer)serializable).append(",");
                    }
                    String string = (String)((Vector)object).elementAt(i);
                    if ((aSN1ObjectIdentifier.on(SECObjectIdentifiers.ellipticCurve) || X9ObjectIdentifiers.prime256v1.equals(aSN1ObjectIdentifier) || X9ObjectIdentifiers.prime192v1.equals(aSN1ObjectIdentifier)) && (string.startsWith("K-") || string.startsWith("B-") || string.startsWith("P-"))) {
                        ((StringBuffer)serializable).append("NIST ");
                    }
                    ((StringBuffer)serializable).append(string);
                }
            }
            ((StringBuffer)serializable).append(",").append((String)object2).append("]");
            ((Vector)object3).addElement(((StringBuffer)serializable).toString());
        }
        object2 = new StringBuffer();
        for (int i = 0; i < ((Vector)object3).size(); ++i) {
            if (i > 0) {
                ((StringBuffer)object2).append("|");
            }
            ((StringBuffer)object2).append((String)((Vector)object3).elementAt(i));
        }
        ecSupportCurves.put("SupportedCurves", ((StringBuffer)object2).toString());
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("AlgorithmParameters.EC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.AlgorithmParametersSpi", ecSupportCurves);
            configurableProvider.addAlgorithm("KeyAgreement.ECDH", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DH", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECDHC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHC", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDH", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHC", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHU", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHUC", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECDHWITHSHA1KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA1KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHWITHSHA1KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA1KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECDHWITHSHA224KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA224KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHWITHSHA224KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA224KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECDHWITHSHA256KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA256KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHWITHSHA256KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA256KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECDHWITHSHA384KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA384KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHWITHSHA384KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA384KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECDHWITHSHA512KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA512KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHWITHSHA512KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA512KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA1KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", X9ObjectIdentifiers.dhSinglePass_cofactorDH_sha1kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA1KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", SECObjectIdentifiers.dhSinglePass_stdDH_sha224kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA224KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", SECObjectIdentifiers.dhSinglePass_cofactorDH_sha224kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA224KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", SECObjectIdentifiers.dhSinglePass_stdDH_sha256kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA256KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", SECObjectIdentifiers.dhSinglePass_cofactorDH_sha256kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA256KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", SECObjectIdentifiers.dhSinglePass_stdDH_sha384kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA384KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", SECObjectIdentifiers.dhSinglePass_cofactorDH_sha384kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA384KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", SECObjectIdentifiers.dhSinglePass_stdDH_sha512kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA512KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", SECObjectIdentifiers.dhSinglePass_cofactorDH_sha512kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA512KDFAndSharedInfo", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHWITHSHA1CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA1CKDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHWITHSHA256CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA256CKDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHWITHSHA384CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA384CKDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHWITHSHA512CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA512CKDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHUWITHSHA1CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHUwithSHA1CKDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHUWITHSHA224CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHUwithSHA224CKDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHUWITHSHA256CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHUwithSHA256CKDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHUWITHSHA384CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHUwithSHA384CKDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHUWITHSHA512CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHUwithSHA512CKDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHUWITHSHA1KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHUwithSHA1KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHUWITHSHA224KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHUwithSHA224KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHUWITHSHA256KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHUwithSHA256KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHUWITHSHA384KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHUwithSHA384KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECCDHUWITHSHA512KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHUwithSHA512KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECKAEGWITHSHA1KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$ECKAEGwithSHA1KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECKAEGWITHSHA224KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$ECKAEGwithSHA224KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECKAEGWITHSHA256KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$ECKAEGwithSHA256KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECKAEGWITHSHA384KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$ECKAEGwithSHA384KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECKAEGWITHSHA512KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$ECKAEGwithSHA512KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", BSIObjectIdentifiers.ecka_eg_X963kdf_SHA1, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$ECKAEGwithSHA1KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", BSIObjectIdentifiers.ecka_eg_X963kdf_SHA224, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$ECKAEGwithSHA224KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", BSIObjectIdentifiers.ecka_eg_X963kdf_SHA256, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$ECKAEGwithSHA256KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", BSIObjectIdentifiers.ecka_eg_X963kdf_SHA384, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$ECKAEGwithSHA384KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", BSIObjectIdentifiers.ecka_eg_X963kdf_SHA512, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$ECKAEGwithSHA512KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement", BSIObjectIdentifiers.ecka_eg_X963kdf_RIPEMD160, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$ECKAEGwithRIPEMD160KDF", generalEcAttributes);
            configurableProvider.addAlgorithm("KeyAgreement.ECKAEGWITHRIPEMD160KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$ECKAEGwithRIPEMD160KDF", generalEcAttributes);
            this.registerOid(configurableProvider, X9ObjectIdentifiers.id_ecPublicKey, "EC", new KeyFactorySpi.EC());
            this.registerOid(configurableProvider, X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(configurableProvider, X9ObjectIdentifiers.dhSinglePass_cofactorDH_sha1kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(configurableProvider, SECObjectIdentifiers.dhSinglePass_stdDH_sha224kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(configurableProvider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha224kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(configurableProvider, SECObjectIdentifiers.dhSinglePass_stdDH_sha256kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(configurableProvider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha256kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(configurableProvider, SECObjectIdentifiers.dhSinglePass_stdDH_sha384kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(configurableProvider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha384kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(configurableProvider, SECObjectIdentifiers.dhSinglePass_stdDH_sha512kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(configurableProvider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha512kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOidAlgorithmParameters(configurableProvider, X9ObjectIdentifiers.id_ecPublicKey, "EC");
            this.registerOidAlgorithmParameters(configurableProvider, X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(configurableProvider, X9ObjectIdentifiers.dhSinglePass_cofactorDH_sha1kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(configurableProvider, SECObjectIdentifiers.dhSinglePass_stdDH_sha224kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(configurableProvider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha224kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(configurableProvider, SECObjectIdentifiers.dhSinglePass_stdDH_sha256kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(configurableProvider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha256kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(configurableProvider, SECObjectIdentifiers.dhSinglePass_stdDH_sha384kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(configurableProvider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha384kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(configurableProvider, SECObjectIdentifiers.dhSinglePass_stdDH_sha512kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(configurableProvider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha512kdf_scheme, "EC");
            if (!Properties.isOverrideSet("io.jenkins.cli.shaded.org.bouncycastle.ec.disable_mqv")) {
                configurableProvider.addAlgorithm("KeyAgreement.ECMQV", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQV", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement.ECMQVWITHSHA1CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA1CKDF", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement.ECMQVWITHSHA224CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA224CKDF", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement.ECMQVWITHSHA256CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA256CKDF", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement.ECMQVWITHSHA384CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA384CKDF", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement.ECMQVWITHSHA512CKDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA512CKDF", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement.ECMQVWITHSHA1KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA1KDF", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement.ECMQVWITHSHA224KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA224KDF", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement.ECMQVWITHSHA256KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA256KDF", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement.ECMQVWITHSHA384KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA384KDF", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement.ECMQVWITHSHA512KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA512KDF", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement." + X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA1KDFAndSharedInfo", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.mqvSinglePass_sha224kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA224KDFAndSharedInfo", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.mqvSinglePass_sha256kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA256KDFAndSharedInfo", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.mqvSinglePass_sha384kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA384KDFAndSharedInfo", generalEcAttributes);
                configurableProvider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.mqvSinglePass_sha512kdf_scheme, "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA512KDFAndSharedInfo", generalEcAttributes);
                this.registerOid(configurableProvider, X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme, "ECMQV", new KeyFactorySpi.ECMQV());
                this.registerOidAlgorithmParameters(configurableProvider, X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme, "EC");
                this.registerOid(configurableProvider, SECObjectIdentifiers.mqvSinglePass_sha224kdf_scheme, "ECMQV", new KeyFactorySpi.ECMQV());
                this.registerOidAlgorithmParameters(configurableProvider, SECObjectIdentifiers.mqvSinglePass_sha224kdf_scheme, "EC");
                this.registerOid(configurableProvider, SECObjectIdentifiers.mqvSinglePass_sha256kdf_scheme, "ECMQV", new KeyFactorySpi.ECMQV());
                this.registerOidAlgorithmParameters(configurableProvider, SECObjectIdentifiers.mqvSinglePass_sha256kdf_scheme, "EC");
                this.registerOid(configurableProvider, SECObjectIdentifiers.mqvSinglePass_sha384kdf_scheme, "ECMQV", new KeyFactorySpi.ECMQV());
                this.registerOidAlgorithmParameters(configurableProvider, SECObjectIdentifiers.mqvSinglePass_sha384kdf_scheme, "EC");
                this.registerOid(configurableProvider, SECObjectIdentifiers.mqvSinglePass_sha512kdf_scheme, "ECMQV", new KeyFactorySpi.ECMQV());
                this.registerOidAlgorithmParameters(configurableProvider, SECObjectIdentifiers.mqvSinglePass_sha512kdf_scheme, "EC");
                configurableProvider.addAlgorithm("KeyFactory.ECMQV", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi$ECMQV");
                configurableProvider.addAlgorithm("KeyPairGenerator.ECMQV", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECMQV");
            }
            configurableProvider.addAlgorithm("KeyFactory.EC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi$EC");
            configurableProvider.addAlgorithm("KeyFactory.ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi$ECDSA");
            configurableProvider.addAlgorithm("KeyFactory.ECDH", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi$ECDH");
            configurableProvider.addAlgorithm("KeyFactory.ECDHC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi$ECDHC");
            configurableProvider.addAlgorithm("KeyPairGenerator.EC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$EC");
            configurableProvider.addAlgorithm("KeyPairGenerator.ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECDSA");
            configurableProvider.addAlgorithm("KeyPairGenerator.ECDH", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECDH");
            configurableProvider.addAlgorithm("KeyPairGenerator.ECDHWITHSHA1KDF", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECDH");
            configurableProvider.addAlgorithm("KeyPairGenerator.ECDHC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECDHC");
            configurableProvider.addAlgorithm("KeyPairGenerator.ECIES", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECDH");
            configurableProvider.addAlgorithm("Cipher.ECIES", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIES", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithSHA1", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIES", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHSHA1", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIES", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithSHA256", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA256", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHSHA256", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA256", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithSHA384", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA384", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHSHA384", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA384", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithSHA512", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA512", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHSHA512", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA512", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithAES-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithAESCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHAES-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithAESCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithSHA1andAES-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithAESCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHSHA1ANDAES-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithAESCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithSHA256andAES-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA256andAESCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHSHA256ANDAES-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA256andAESCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithSHA384andAES-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA384andAESCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHSHA384ANDAES-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA384andAESCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithSHA512andAES-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA512andAESCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHSHA512ANDAES-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA512andAESCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithDESEDE-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithDESedeCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHDESEDE-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithDESedeCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithSHA1andDESEDE-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithDESedeCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHSHA1ANDDESEDE-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithDESedeCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithSHA256andDESEDE-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA256andDESedeCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHSHA256ANDDESEDE-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA256andDESedeCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithSHA384andDESEDE-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA384andDESedeCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHSHA384ANDDESEDE-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA384andDESedeCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESwithSHA512andDESEDE-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA512andDESedeCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ECIESWITHSHA512ANDDESEDE-CBC", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithSHA512andDESedeCBC", generalEcAttributes);
            configurableProvider.addAlgorithm("Cipher.ETSIKEMWITHSHA256", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.IESKEMCipher$KEMwithSHA256", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSA", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.NONEwithECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSAnone", generalEcAttributes);
            configurableProvider.addAlgorithm("Alg.Alias.Signature.SHA1withECDSA", "ECDSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.ECDSAwithSHA1", "ECDSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.SHA1WITHECDSA", "ECDSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.ECDSAWITHSHA1", "ECDSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.SHA1WithECDSA", "ECDSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.ECDSAWithSHA1", "ECDSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.1.2.840.10045.4.1", "ECDSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature." + TeleTrusTObjectIdentifiers.ecSignWithSha1, "ECDSA");
            configurableProvider.addAlgorithm("Signature.ECDDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSA", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA1WITHECDDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSA", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA224WITHECDDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSA224", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA256WITHECDDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSA256", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA384WITHECDDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSA384", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA512WITHECDDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSA512", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA3-224WITHECDDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSASha3_224", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA3-256WITHECDDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSASha3_256", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA3-384WITHECDDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSASha3_384", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA3-512WITHECDDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSASha3_512", generalEcAttributes);
            configurableProvider.addAlgorithm("Alg.Alias.Signature.DETECDSA", "ECDDSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.SHA1WITHDETECDSA", "SHA1WITHECDDSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.SHA224WITHDETECDSA", "SHA224WITHECDDSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.SHA256WITHDETECDSA", "SHA256WITHECDDSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.SHA384WITHDETECDSA", "SHA384WITHECDDSA");
            configurableProvider.addAlgorithm("Alg.Alias.Signature.SHA512WITHDETECDSA", "SHA512WITHECDDSA");
            this.addSignatureAlgorithm(configurableProvider, "SHA224", "ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSA224", X9ObjectIdentifiers.ecdsa_with_SHA224, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA256", "ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSA256", X9ObjectIdentifiers.ecdsa_with_SHA256, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA384", "ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSA384", X9ObjectIdentifiers.ecdsa_with_SHA384, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA512", "ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSA512", X9ObjectIdentifiers.ecdsa_with_SHA512, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA3-224", "ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSASha3_224", NISTObjectIdentifiers.id_ecdsa_with_sha3_224, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA3-256", "ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSASha3_256", NISTObjectIdentifiers.id_ecdsa_with_sha3_256, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA3-384", "ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSASha3_384", NISTObjectIdentifiers.id_ecdsa_with_sha3_384, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA3-512", "ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSASha3_512", NISTObjectIdentifiers.id_ecdsa_with_sha3_512, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHAKE128", "ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSAShake128", CMSObjectIdentifiers.id_ecdsa_with_shake128, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHAKE256", "ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSAShake256", CMSObjectIdentifiers.id_ecdsa_with_shake256, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "RIPEMD160", "ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSARipeMD160", TeleTrusTObjectIdentifiers.ecSignWithRipemd160, generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA1WITHECNR", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecNR", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA224WITHECNR", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecNR224", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA256WITHECNR", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecNR256", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA384WITHECNR", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecNR384", generalEcAttributes);
            configurableProvider.addAlgorithm("Signature.SHA512WITHECNR", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecNR512", generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA1", "CVC-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_1, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA224", "CVC-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA224", EACObjectIdentifiers.id_TA_ECDSA_SHA_224, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA256", "CVC-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA256", EACObjectIdentifiers.id_TA_ECDSA_SHA_256, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA384", "CVC-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA384", EACObjectIdentifiers.id_TA_ECDSA_SHA_384, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA512", "CVC-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA512", EACObjectIdentifiers.id_TA_ECDSA_SHA_512, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA1", "PLAIN-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA", BSIObjectIdentifiers.ecdsa_plain_SHA1, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA224", "PLAIN-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA224", BSIObjectIdentifiers.ecdsa_plain_SHA224, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA256", "PLAIN-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA256", BSIObjectIdentifiers.ecdsa_plain_SHA256, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA384", "PLAIN-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA384", BSIObjectIdentifiers.ecdsa_plain_SHA384, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA512", "PLAIN-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA512", BSIObjectIdentifiers.ecdsa_plain_SHA512, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "RIPEMD160", "PLAIN-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecPlainDSARP160", BSIObjectIdentifiers.ecdsa_plain_RIPEMD160, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA3-224", "PLAIN-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA3_224", BSIObjectIdentifiers.ecdsa_plain_SHA3_224, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA3-256", "PLAIN-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA3_256", BSIObjectIdentifiers.ecdsa_plain_SHA3_256, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA3-384", "PLAIN-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA3_384", BSIObjectIdentifiers.ecdsa_plain_SHA3_384, generalEcAttributes);
            this.addSignatureAlgorithm(configurableProvider, "SHA3-512", "PLAIN-ECDSA", "io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA3_512", BSIObjectIdentifiers.ecdsa_plain_SHA3_512, generalEcAttributes);
        }
    }
}

