/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.net;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InetAddressRange {
    private static final String IP4_BYTE = "(\\d{1,3})";
    private static final String IP4_DOT_BYTE = "(?:\\.(\\d{1,3}))";
    private static final String IP4_PREFIX = "(\\d{1,3})(?:(?:\\.(\\d{1,3}))(?:(?:\\.(\\d{1,3}))(?:(?:\\.(\\d{1,3})))?)?)?";
    private static final String BITS = "(\\d{1,3})";
    private static final Pattern IP4_CIDR = Pattern.compile("^(\\d{1,3})(?:(?:\\.(\\d{1,3}))(?:(?:\\.(\\d{1,3}))(?:(?:\\.(\\d{1,3})))?)?)?/(\\d{1,3})$");
    private static final String IP6_WORD = "(?:[0-9a-fA-F]{1,4})";
    private static final String IP6_PART = "((?:[0-9a-fA-F]{1,4})(?::(?:[0-9a-fA-F]{1,4}))*+)";
    private static final Pattern IP6_CIDR = Pattern.compile("^((?:[0-9a-fA-F]{1,4})(?::(?:[0-9a-fA-F]{1,4}))*+)?(?:::((?:[0-9a-fA-F]{1,4})(?::(?:[0-9a-fA-F]{1,4}))*+)?)?/(\\d{1,3})$");
    private final byte[] base;
    private final byte[] mask;
    private final byte[] broadcast;
    private final int networkZoneBits;

    private InetAddressRange(byte[] base, int bits) {
        byte[] netmask = new byte[base.length];
        Builder.computeMask(netmask, bits);
        byte[] net = Builder.and(base, netmask);
        this.broadcast = Builder.invertedOr(net, netmask);
        this.base = net;
        this.mask = netmask;
        this.networkZoneBits = bits;
    }

    public static InetAddressRange fromCIDR(String cidr) {
        return Builder.build(cidr);
    }

    public static boolean isCIDR(String cidr) {
        try {
            return InetAddressRange.fromCIDR(cidr) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isIpV4() {
        return this.base.length == 4;
    }

    public boolean isIpV6() {
        return this.base.length == 16;
    }

    public byte[] first(boolean inclusive) {
        if (inclusive || this.networkZoneBits + 1 >= this.base.length * 8) {
            return (byte[])this.base.clone();
        }
        byte[] result = (byte[])this.base.clone();
        int n = result.length - 1;
        result[n] = (byte)(result[n] | 1);
        return result;
    }

    public byte[] last(boolean inclusive) {
        if (inclusive || this.networkZoneBits + 1 >= this.base.length * 8) {
            return (byte[])this.broadcast.clone();
        }
        byte[] result = (byte[])this.broadcast.clone();
        int n = result.length - 1;
        result[n] = (byte)(result[n] & 0xFFFFFFFE);
        return result;
    }

    public byte[] broadcastAddress() {
        return (byte[])this.broadcast.clone();
    }

    public boolean contains(InetAddress address) {
        return this.contains(address.getAddress());
    }

    public boolean contains(byte[] address) {
        if (address.length != this.mask.length) {
            return false;
        }
        return Arrays.equals(this.base, Builder.and(address, this.mask));
    }

    public boolean contains(InetAddressRange other) {
        return this.contains(other.first(true)) && this.contains(other.last(true));
    }

    public boolean overlaps(InetAddressRange other) {
        return this.contains(other.first(true)) || this.contains(other.last(true));
    }

    public int networkZoneBits() {
        return this.networkZoneBits;
    }

    public int subnetBits() {
        return this.base.length * 8 - this.networkZoneBits;
    }

    public long numberOfAddresses(boolean inclusive) {
        long n = 1L << this.subnetBits();
        return inclusive || n <= 2L ? n : n - 2L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.base);
        result = 31 * result + Integer.hashCode(this.networkZoneBits);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InetAddressRange other = (InetAddressRange)obj;
        return Arrays.equals(this.base, other.base) && this.networkZoneBits == other.networkZoneBits;
    }

    public String toString() {
        if (this.base.length == 4) {
            return this.toStringIp4();
        }
        return this.toStringIp6();
    }

    private String toStringIp4() {
        int j;
        StringBuilder b = new StringBuilder();
        for (j = this.base.length; j > 0 && this.base[j - 1] == 0; --j) {
        }
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                b.append('.');
            }
            b.append(this.base[i] & 0xFF);
        }
        return b.append('/').append(this.networkZoneBits).toString();
    }

    private String toStringIp6() {
        int i;
        StringBuilder b = new StringBuilder();
        int[] w = new int[this.base.length / 2];
        for (int i2 = 0; i2 < w.length; ++i2) {
            w[i2] = ((this.base[2 * i2] & 0xFF) << 8) + (this.base[2 * i2 + 1] & 0xFF);
        }
        int longest = -1;
        int longestStart = -1;
        int length = -1;
        int start = -1;
        for (i = 0; i < w.length; ++i) {
            if (w[i] != 0) {
                if (length > longest) {
                    longest = length;
                    longestStart = start;
                }
                length = -1;
                start = -1;
                continue;
            }
            if (start < 0) {
                start = i;
                length = 1;
                continue;
            }
            ++length;
        }
        if (length >= longest) {
            longest = length;
            longestStart = start;
        }
        if (longestStart < 0) {
            longestStart = w.length;
            longest = 1;
        }
        for (i = 0; i < longestStart; ++i) {
            if (i > 0) {
                b.append(':');
            }
            b.append(Integer.toHexString(w[i]));
        }
        if (longestStart < w.length) {
            b.append(':');
            if (longestStart + longest >= w.length) {
                b.append(':');
            } else {
                for (i = longestStart + longest; i < w.length; ++i) {
                    b.append(':').append(Integer.toHexString(w[i]));
                }
            }
        }
        return b.append('/').append(this.networkZoneBits).toString();
    }

    private static final class Builder {
        private Builder() {
            throw new IllegalStateException();
        }

        static InetAddressRange build(String cidr) {
            IllegalArgumentException ex = null;
            if (!cidr.isEmpty()) {
                try {
                    if ("/0".equals(cidr)) {
                        return new InetAddressRange(new byte[4], 0);
                    }
                    Matcher m = IP4_CIDR.matcher(cidr);
                    if (m.matches()) {
                        return Builder.fromIp4(m);
                    }
                    m = IP6_CIDR.matcher(cidr);
                    if (m.matches() && cidr.charAt(0) != '/') {
                        return Builder.fromIp6(m);
                    }
                }
                catch (IllegalArgumentException e) {
                    ex = e;
                }
            }
            throw new IllegalArgumentException(cidr + " is not a CIDR", ex);
        }

        private static InetAddressRange fromIp4(Matcher m) {
            byte[] base = new byte[4];
            for (int i = 0; i < 4; ++i) {
                String s = m.group(i + 1);
                if (s == null || s.isEmpty()) continue;
                base[i] = Builder.byteRange(Integer.parseInt(s));
            }
            int bits = Integer.parseInt(m.group(5));
            return new InetAddressRange(base, bits);
        }

        private static InetAddressRange fromIp6(Matcher m) {
            int i;
            String[] post;
            String prefix = m.group(1);
            String suffix = m.group(2);
            String[] pre = prefix == null ? new String[]{} : prefix.split(":");
            String[] stringArray = post = suffix == null ? new String[]{} : suffix.split(":");
            if (pre.length + post.length > 8) {
                throw new IllegalArgumentException("Too many components");
            }
            byte[] base = new byte[16];
            for (i = 0; i < pre.length; ++i) {
                int w = Builder.wordRange(Integer.parseInt(pre[i], 16));
                base[2 * i] = (byte)(w >>> 8);
                base[2 * i + 1] = (byte)w;
            }
            i = post.length - 1;
            int j = base.length / 2 - 1;
            while (i >= 0) {
                int w = Builder.wordRange(Integer.parseInt(post[i], 16));
                base[2 * j] = (byte)(w >>> 8);
                base[2 * j + 1] = (byte)w;
                --i;
                --j;
            }
            int bits = Integer.parseInt(m.group(3));
            return new InetAddressRange(base, bits);
        }

        private static byte byteRange(int x) {
            Builder.rangeCheck(x, 0, 255);
            return (byte)x;
        }

        private static int wordRange(int x) {
            Builder.rangeCheck(x, 0, 32768);
            return x;
        }

        private static void rangeCheck(int x, int min, int max) {
            if (x < min || x > max) {
                throw new IllegalArgumentException(x + " not in range [" + min + ',' + max + ']');
            }
        }

        static void computeMask(byte[] mask, int bits) {
            Builder.rangeCheck(bits, 0, mask.length * 8);
            for (int i = 0; i < bits; ++i) {
                int j = i / 8;
                int b = 1 << 7 - i % 8;
                int n = j;
                mask[n] = (byte)(mask[n] | b);
            }
        }

        static byte[] and(byte[] a, byte[] b) {
            if (a.length != b.length) {
                throw new IllegalArgumentException();
            }
            byte[] r = (byte[])a.clone();
            for (int i = 0; i < a.length; ++i) {
                int n = i;
                r[n] = (byte)(r[n] & b[i]);
            }
            return r;
        }

        static byte[] invertedOr(byte[] a, byte[] b) {
            if (a.length != b.length) {
                throw new IllegalArgumentException();
            }
            byte[] r = (byte[])a.clone();
            for (int i = 0; i < a.length; ++i) {
                int n = i;
                r[n] = (byte)(r[n] | ~b[i]);
            }
            return r;
        }
    }
}

