/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec;

import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.DERNull;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.x9.X962Parameters;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.x9.X9ECParameters;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.x9.X9ECPoint;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import io.jenkins.cli.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import io.jenkins.cli.shaded.org.bouncycastle.jce.spec.ECNamedCurveSpec;
import io.jenkins.cli.shaded.org.bouncycastle.math.ec.ECCurve;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class AlgorithmParametersSpi
extends java.security.AlgorithmParametersSpi {
    private ECParameterSpec ecParameterSpec;
    private String curveName;

    protected boolean isASN1FormatString(String string) {
        return string == null || string.equals("ASN.1");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)algorithmParameterSpec;
            ProviderConfiguration providerConfiguration = BouncyCastleProvider.CONFIGURATION;
            X9ECParameters x9ECParameters = ECUtils.getDomainParametersFromGenSpec(eCGenParameterSpec, providerConfiguration);
            if (null == x9ECParameters) {
                throw new InvalidParameterSpecException("EC curve name not recognized: " + eCGenParameterSpec.getName());
            }
            this.curveName = eCGenParameterSpec.getName();
            ECParameterSpec eCParameterSpec = EC5Util.convertToSpec(x9ECParameters);
            this.ecParameterSpec = new ECNamedCurveSpec(this.curveName, eCParameterSpec.getCurve(), eCParameterSpec.getGenerator(), eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor()));
        } else if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.curveName = algorithmParameterSpec instanceof ECNamedCurveSpec ? ((ECNamedCurveSpec)algorithmParameterSpec).getName() : null;
            this.ecParameterSpec = (ECParameterSpec)algorithmParameterSpec;
        } else {
            throw new InvalidParameterSpecException("AlgorithmParameterSpec class not recognized: " + algorithmParameterSpec.getClass().getName());
        }
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        this.engineInit(byArray, "ASN.1");
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        ECCurve eCCurve;
        X962Parameters x962Parameters;
        if (this.isASN1FormatString(string)) {
            x962Parameters = X962Parameters.getInstance(byArray);
            eCCurve = EC5Util.getCurve(BouncyCastleProvider.CONFIGURATION, x962Parameters);
            if (x962Parameters.isNamedCurve()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(x962Parameters.getParameters());
                this.curveName = ECNamedCurveTable.getName(aSN1ObjectIdentifier);
                if (this.curveName == null) {
                    this.curveName = aSN1ObjectIdentifier.getId();
                }
            }
        } else {
            throw new IOException("Unknown encoded parameters format in AlgorithmParameters object: " + string);
        }
        this.ecParameterSpec = EC5Util.convertToSpec(x962Parameters, eCCurve);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (ECParameterSpec.class.isAssignableFrom(clazz) || clazz == AlgorithmParameterSpec.class) {
            return (T)this.ecParameterSpec;
        }
        if (ECGenParameterSpec.class.isAssignableFrom(clazz)) {
            if (this.curveName != null) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ECUtil.getNamedCurveOid(this.curveName);
                if (aSN1ObjectIdentifier != null) {
                    return (T)new ECGenParameterSpec(aSN1ObjectIdentifier.getId());
                }
                return (T)new ECGenParameterSpec(this.curveName);
            }
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ECUtil.getNamedCurveOid(EC5Util.convertSpec(this.ecParameterSpec));
            if (aSN1ObjectIdentifier != null) {
                return (T)new ECGenParameterSpec(aSN1ObjectIdentifier.getId());
            }
        }
        throw new InvalidParameterSpecException("EC AlgorithmParameters cannot convert to " + clazz.getName());
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded("ASN.1");
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        if (this.isASN1FormatString(string)) {
            X962Parameters x962Parameters;
            if (this.ecParameterSpec == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else if (this.curveName != null) {
                x962Parameters = new X962Parameters(ECUtil.getNamedCurveOid(this.curveName));
            } else {
                io.jenkins.cli.shaded.org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = EC5Util.convertSpec(this.ecParameterSpec);
                X9ECParameters x9ECParameters = new X9ECParameters(eCParameterSpec.getCurve(), new X9ECPoint(eCParameterSpec.getG(), false), eCParameterSpec.getN(), eCParameterSpec.getH(), eCParameterSpec.getSeed());
                x962Parameters = new X962Parameters(x9ECParameters);
            }
            return x962Parameters.getEncoded();
        }
        throw new IOException("Unknown parameters format in AlgorithmParameters object: " + string);
    }

    @Override
    protected String engineToString() {
        return "EC Parameters";
    }
}

