/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.resource.PathResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.Console;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;

public class PrivateKeyProvider {
    private final List<KeyPair> privateKeys = new ArrayList<KeyPair>();
    private static final Logger LOGGER = Logger.getLogger(PrivateKeyProvider.class.getName());

    public List<KeyPair> getKeys() {
        return Collections.unmodifiableList(this.privateKeys);
    }

    public boolean hasKeys() {
        return !this.privateKeys.isEmpty();
    }

    public boolean readFromDefaultLocations() {
        File home = new File(System.getProperty("user.home"));
        boolean read = false;
        for (String path : new String[]{".ssh/id_rsa", ".ssh/id_dsa", ".ssh/identity"}) {
            File key = new File(home, path);
            if (!key.exists()) continue;
            try {
                this.readFrom(key);
                read = true;
            }
            catch (IOException | GeneralSecurityException e) {
                LOGGER.log(Level.FINE, "Failed to load " + String.valueOf(key), e);
            }
        }
        return read;
    }

    public void readFrom(File keyFile) throws IOException, GeneralSecurityException {
        String password = PrivateKeyProvider.isPemEncrypted(keyFile) ? PrivateKeyProvider.askForPasswd(keyFile.getCanonicalPath()) : null;
        this.privateKeys.add(PrivateKeyProvider.loadKey(keyFile, password));
    }

    private static boolean isPemEncrypted(File f) throws IOException {
        return PrivateKeyProvider.readPemFile(f).contains("4,ENCRYPTED");
    }

    private static String askForPasswd(String filePath) {
        Console cons = System.console();
        String passwd = null;
        if (cons != null) {
            char[] p = cons.readPassword("%s", "Enter passphrase for " + filePath + ":");
            passwd = String.valueOf(p);
        }
        return passwd;
    }

    public static KeyPair loadKey(File f, String passwd) throws IOException, GeneralSecurityException {
        return PrivateKeyProvider.loadKey(PrivateKeyProvider.readPemFile(f), passwd);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String readPemFile(File f) throws IOException {
        try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);){
            String string;
            try (DataInputStream dis = new DataInputStream(is);){
                byte[] bytes = new byte[(int)f.length()];
                dis.readFully(bytes);
                string = new String(bytes, StandardCharsets.UTF_8);
            }
            return string;
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    public static KeyPair loadKey(String pemString, String passwd) throws IOException, GeneralSecurityException {
        long numLoaded;
        Iterable<KeyPair> itr = SecurityUtils.loadKeyPairIdentities(null, new PathResource(Paths.get("key", new String[0])), new ByteArrayInputStream(pemString.getBytes(StandardCharsets.UTF_8)), FilePasswordProvider.of(passwd));
        long l = numLoaded = itr == null ? 0L : StreamSupport.stream(itr.spliterator(), false).count();
        if (numLoaded <= 0L) {
            throw new InvalidKeyException("Unsupported private key file format: key");
        }
        if (numLoaded != 1L) {
            throw new InvalidKeySpecException("Multiple private key pairs N/A: key");
        }
        return itr.iterator().next();
    }
}

