/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.logging;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.LoggingUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.SimplifiedLog;
import io.jenkins.cli.shaded.org.slf4j.Logger;
import io.jenkins.cli.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractLoggingBean {
    protected final Logger log;
    private final AtomicReference<SimplifiedLog> simplifiedLog = new AtomicReference();

    protected AbstractLoggingBean() {
        this((Logger)null);
    }

    protected AbstractLoggingBean(String discriminator) {
        String name = this.getClass().getName();
        if (GenericUtils.isNotEmpty(discriminator)) {
            name = name + "[" + discriminator + "]";
        }
        this.log = LoggerFactory.getLogger(name);
    }

    protected AbstractLoggingBean(Logger logger) {
        this.log = logger == null ? LoggerFactory.getLogger(this.getClass()) : logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimplifiedLog getSimplifiedLogger() {
        SimplifiedLog logger;
        AtomicReference<SimplifiedLog> atomicReference = this.simplifiedLog;
        synchronized (atomicReference) {
            logger = this.simplifiedLog.get();
            if (logger == null) {
                logger = LoggingUtils.wrap(this.log);
            }
        }
        return logger;
    }

    protected void debug(String message, Object o1, Object o2, Throwable t) {
        LoggingUtils.debug(this.log, message, o1, o2, t);
    }

    protected void debug(String message, Object o1, Object o2, Object o3, Throwable t) {
        LoggingUtils.debug(this.log, message, o1, o2, o3, t);
    }

    protected void debug(String message, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        LoggingUtils.debug(this.log, message, o1, o2, o3, o4, t);
    }

    protected void debug(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        LoggingUtils.debug(this.log, message, o1, o2, o3, o4, o5, t);
    }

    protected void debug(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Throwable t) {
        LoggingUtils.debug(this.log, message, o1, o2, o3, o4, o5, o6, t);
    }

    protected void info(String message, Object o1, Object o2, Throwable t) {
        LoggingUtils.info(this.log, message, o1, o2, t);
    }

    protected void info(String message, Object o1, Object o2, Object o3, Throwable t) {
        LoggingUtils.info(this.log, message, o1, o2, o3, t);
    }

    protected void warn(String message, Object o1, Object o2, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, o6, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, o6, o7, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, o6, o7, o8, t);
    }

    protected void warn(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Throwable t) {
        LoggingUtils.warn(this.log, message, o1, o2, o3, o4, o5, o6, o7, o8, o9, t);
    }

    protected void error(String message, Object o1, Object o2, Throwable t) {
        LoggingUtils.error(this.log, message, o1, o2, t);
    }

    protected void error(String message, Object o1, Object o2, Object o3, Throwable t) {
        LoggingUtils.error(this.log, message, o1, o2, o3, t);
    }

    protected void error(String message, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        LoggingUtils.error(this.log, message, o1, o2, o3, o4, t);
    }

    protected void error(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        LoggingUtils.error(this.log, message, o1, o2, o3, o4, o5, t);
    }

    protected void error(String message, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Throwable t) {
        LoggingUtils.error(this.log, message, o1, o2, o3, o4, o5, o6, t);
    }
}

