/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex;

import io.jenkins.cli.shaded.org.apache.sshd.common.OptionalFeature;
import io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider.KeySizeIndicator;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;

public enum MontgomeryCurve implements KeySizeIndicator,
OptionalFeature
{
    x25519("X25519", 32, new byte[]{48, 42, 48, 5, 6, 3, 43, 101, 110, 3, 33, 0}),
    x448("X448", 56, new byte[]{48, 66, 48, 5, 6, 3, 43, 101, 111, 3, 57, 0});

    private final String algorithm;
    private final int keySize;
    private final boolean supported;
    private final KeyPairGenerator keyPairGenerator;
    private final KeyFactory keyFactory;
    private final byte[] encodedPublicKeyPrefix;

    private MontgomeryCurve(String algorithm, int keySize, byte[] encodedPublicKeyPrefix) {
        boolean isSupported;
        this.algorithm = algorithm;
        this.keySize = keySize;
        this.encodedPublicKeyPrefix = encodedPublicKeyPrefix;
        KeyPairGenerator generator = null;
        KeyFactory factory = null;
        try {
            SecurityUtils.getKeyAgreement(algorithm);
            generator = SecurityUtils.getKeyPairGenerator(algorithm);
            factory = SecurityUtils.getKeyFactory(algorithm);
            isSupported = true;
        }
        catch (GeneralSecurityException ignored) {
            isSupported = false;
        }
        this.supported = isSupported;
        this.keyPairGenerator = generator;
        this.keyFactory = factory;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public boolean isSupported() {
        return this.supported && !SecurityUtils.isFipsMode();
    }

    public KeyAgreement createKeyAgreement() throws GeneralSecurityException {
        return SecurityUtils.getKeyAgreement(this.algorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPair generateKeyPair() {
        MontgomeryCurve montgomeryCurve = this;
        synchronized (montgomeryCurve) {
            return this.keyPairGenerator.generateKeyPair();
        }
    }

    public byte[] encode(PublicKey key) throws InvalidKeyException {
        byte[] subjectPublicKeyInfo = key.getEncoded();
        byte[] result = Arrays.copyOfRange(subjectPublicKeyInfo, subjectPublicKeyInfo.length - this.getKeySize(), subjectPublicKeyInfo.length);
        return result;
    }

    public PublicKey decode(byte[] key) throws InvalidKeySpecException {
        int size = this.getKeySize();
        int offset = key.length - size;
        if (offset < 0 || offset > 1) {
            throw new InvalidKeySpecException("Provided key has wrong length (" + key.length + " bytes) for " + this.getAlgorithm());
        }
        if (offset == 1 && key[0] != 0) {
            throw new InvalidKeySpecException("Provided key for " + this.getAlgorithm() + " has extra byte, but it's non-zero: 0x" + Integer.toHexString(key[0] & 0xFF));
        }
        byte[] encoded = Arrays.copyOf(this.encodedPublicKeyPrefix, this.encodedPublicKeyPrefix.length + size);
        System.arraycopy(key, offset, encoded, this.encodedPublicKeyPrefix.length, size);
        return this.keyFactory.generatePublic(new X509EncodedKeySpec(encoded));
    }
}

