/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.ThreadUtils;
import io.jenkins.cli.shaded.org.slf4j.Logger;
import io.jenkins.cli.shaded.org.slf4j.LoggerFactory;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.TreeMap;

public final class VersionProperties {
    public static final String REPORTED_VERSION = "sshd-version";

    private VersionProperties() {
        throw new UnsupportedOperationException("No instance");
    }

    public static NavigableMap<String, String> getVersionProperties() {
        return LazyVersionPropertiesHolder.PROPERTIES;
    }

    private static final class LazyVersionPropertiesHolder {
        private static final NavigableMap<String, String> PROPERTIES = Collections.unmodifiableNavigableMap(LazyVersionPropertiesHolder.loadVersionProperties(LazyVersionPropertiesHolder.class));

        private LazyVersionPropertiesHolder() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        private static NavigableMap<String, String> loadVersionProperties(Class<?> anchor) {
            return LazyVersionPropertiesHolder.loadVersionProperties(anchor, ThreadUtils.iterateDefaultClassLoaders(anchor));
        }

        private static NavigableMap<String, String> loadVersionProperties(Class<?> anchor, Iterator<? extends ClassLoader> loaders) {
            while (loaders != null && loaders.hasNext()) {
                Properties props;
                block17: {
                    ClassLoader cl = loaders.next();
                    try {
                        InputStream input = cl.getResourceAsStream("io/jenkins/cli/shaded/org/apache/sshd/sshd-version.properties");
                        Object object = null;
                        try {
                            if (input == null) continue;
                            props = new Properties();
                            props.load(input);
                            break block17;
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (input == null) continue;
                            if (object != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                continue;
                            }
                            input.close();
                        }
                    }
                    catch (Exception e) {
                        Logger log = LoggerFactory.getLogger(anchor);
                        log.warn("Failed ({}) to load version properties from {}: {}", e.getClass().getSimpleName(), cl, e.getMessage());
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Version property failure details for loader={}", (Object)cl, (Object)e);
                    }
                    continue;
                }
                TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                for (String key : props.stringPropertyNames()) {
                    String prev;
                    String propValue = props.getProperty(key);
                    String value = GenericUtils.trimToEmpty(propValue);
                    if (GenericUtils.isEmpty(value) || (prev = result.put(key, value)) == null) continue;
                    Logger log = LoggerFactory.getLogger(anchor);
                    log.warn("Multiple values for key={}: current={}, previous={}", key, value, prev);
                }
                return result;
            }
            return Collections.emptyNavigableMap();
        }
    }
}

